/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.application.options.CodeStyle;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageFeatureUsagesTracker;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfiguration;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.frameworks.IntegrationUtil;
import com.jetbrains.php.lang.PhpLanguage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhpSettingsUsageCollector
extends ProjectUsagesCollector {
    private static final String DEBUG_SKIP_PATH_TOTAL_METRIC = "debug.skip.path.total";
    private static final String DEBUG_SERVER_TOTAL_METRIC = "debug.server.total";
    private static final String DEBUG_SERVER_METRIC = "debug.server";
    private static final String PROJECT_PHP_LEVEL_METRIC = "project.language.level";
    private static final String DEFAULT_INTERPRETER_METRIC = "default.interpreter";
    private static final String INTERPRETERS_TOTAL_METRIC = "interpreters.total";
    private static final String INTERPRETER_METRIC = "interpreter";
    private static final String LANGUAGE_LEVEL_DATA = "php_level";
    private static final String IS_PROJECT_LEVEL_DATA = "equals_to_project_level";
    private static final String DEBUGGER_DATA = "debugger";
    private static final String WITH_MAPPINGS_DATA = "with_mappings";
    public static final String CODE_STYLE_METRIC = "php.code.style";
    public static final String FEATURE_USAGE_METRIC = "php.feature.usage";
    public static final String NAME_DATA = "name";

    PhpSettingsUsageCollector() {
    }

    @NotNull
    public String getGroupId() {
        return "php.config";
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        PhpProjectConfigurationFacade configuration;
        if (project == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(0);
        }
        if (project.isDefault() || project.isDisposed()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                PhpSettingsUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<MetricEvent> metrics = new HashSet<MetricEvent>();
        PhpDebugSkippedPathsConfiguration skippedPathsSettings = PhpDebugSkippedPathsConfiguration.getInstance(project);
        if (skippedPathsSettings != null) {
            PhpDebugSkippedPathsConfiguration.State state = skippedPathsSettings.getState();
            MetricEventUtilKt.addCounterIfNotZero(metrics, (String)DEBUG_SKIP_PATH_TOTAL_METRIC, (int)(state != null ? state.getSkippedFiles().size() : 0));
        }
        if ((configuration = PhpProjectConfigurationFacade.getInstance(project)) != null) {
            List<PhpServer> servers = configuration.getServers();
            metrics.add(MetricEventFactoryKt.newCounterMetric((String)DEBUG_SERVER_TOTAL_METRIC, (int)servers.size()));
            if (!servers.isEmpty()) {
                Object2IntOpenHashMap infos = new Object2IntOpenHashMap();
                for (PhpServer server : servers) {
                    PhpDebugExtension extension = PhpDebugUtil.getDebugExtensionByDebuggerId(server.getDebuggerId());
                    PhpDebugServerInfo info = new PhpDebugServerInfo(extension, server.isUsePathMappings());
                    infos.mergeInt((Object)info, 1, Math::addExact);
                }
                for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable((Object2IntMap)infos)) {
                    metrics.add(MetricEventFactoryKt.newCounterMetric((String)DEBUG_SERVER_METRIC, (int)entry.getIntValue(), (FeatureUsageData)((PhpDebugServerInfo)entry.getKey()).createData()));
                }
            }
            PhpLanguageLevel projectLevel = configuration.getLanguageLevel();
            metrics.add(MetricEventFactoryKt.newMetric((String)PROJECT_PHP_LEVEL_METRIC, (FeatureUsageData)new FeatureUsageData().addData(LANGUAGE_LEVEL_DATA, projectLevel.getPresentableName())));
            metrics.add(PhpSettingsUsageCollector.createDefaultInterpreterMetric(project, configuration.getInterpreter(), projectLevel));
            PhpInterpretersManagerImpl interpretersManager = PhpInterpretersManagerImpl.getInstance(project);
            if (interpretersManager != null) {
                List<PhpInterpreter> interpreters = interpretersManager.getInterpreters();
                MetricEventUtilKt.addCounterIfNotZero(metrics, (String)INTERPRETERS_TOTAL_METRIC, (int)interpreters.size());
                if (!interpreters.isEmpty()) {
                    Object2IntOpenHashMap interpreterData = new Object2IntOpenHashMap();
                    for (PhpInterpreter interpreter : interpreters) {
                        FeatureUsageData data = PhpSettingsUsageCollector.createInterpreterData(project, interpreter, projectLevel);
                        interpreterData.mergeInt((Object)data, 1, Math::addExact);
                    }
                    for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable((Object2IntMap)interpreterData)) {
                        metrics.add(MetricEventFactoryKt.newCounterMetric((String)INTERPRETER_METRIC, (int)entry.getIntValue(), (FeatureUsageData)((FeatureUsageData)entry.getKey())));
                    }
                }
            }
        }
        metrics.add(MetricEventFactoryKt.newMetric((String)CODE_STYLE_METRIC, (String)PhpSettingsUsageCollector.getPhpCodeStyle(project)));
        EnumSet<PhpLanguageFeature> features = PhpLanguageFeatureUsagesTracker.getInstance().getUsedFeatures(project);
        for (PhpLanguageFeature feature : features) {
            metrics.add(MetricEventFactoryKt.newMetric((String)FEATURE_USAGE_METRIC, (FeatureUsageData)new FeatureUsageData().addData(NAME_DATA, feature.name())));
        }
        HashSet<MetricEvent> hashSet = metrics;
        if (hashSet == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    private static String getPhpCodeStyle(@NotNull Project project) {
        Optional<PredefinedCodeStyle> first;
        if (project == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(3);
        }
        if ((first = Arrays.stream((PredefinedCodeStyle[])PredefinedCodeStyle.EP_NAME.getExtensions()).filter(e -> e.getLanguage() == PhpLanguage.INSTANCE).filter(e -> IntegrationUtil.isFormattingStyleSet(project, e)).findFirst()).isPresent()) {
            return PluginInfoDetectorKt.getPluginInfo(first.get().getClass()).isDevelopedByJetBrains() ? first.get().getName() : "third.party";
        }
        if (CodeStyleSettings.getDefaults().equals((Object)CodeStyle.getSettings((Project)project))) {
            return "default";
        }
        return "edited";
    }

    @NotNull
    private static MetricEvent createDefaultInterpreterMetric(@Nullable Project project, @Nullable PhpInterpreter interpreter, @NotNull PhpLanguageLevel projectLevel) {
        if (projectLevel == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(4);
        }
        if (interpreter == null) {
            MetricEvent metricEvent = MetricEventFactoryKt.newMetric((String)DEFAULT_INTERPRETER_METRIC, (String)"not.installed");
            if (metricEvent == null) {
                PhpSettingsUsageCollector.$$$reportNull$$$0(5);
            }
            return metricEvent;
        }
        FeatureUsageData data = PhpSettingsUsageCollector.createInterpreterData(project, interpreter, projectLevel);
        MetricEvent metricEvent = MetricEventFactoryKt.newMetric((String)DEFAULT_INTERPRETER_METRIC, (String)"installed", (FeatureUsageData)data);
        if (metricEvent == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(6);
        }
        return metricEvent;
    }

    @NotNull
    private static FeatureUsageData createInterpreterData(@Nullable Project project, @NotNull PhpInterpreter interpreter, @NotNull PhpLanguageLevel projectLevel) {
        PhpInfo info;
        if (interpreter == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(7);
        }
        if (projectLevel == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(8);
        }
        if ((info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName())) == null) {
            FeatureUsageData featureUsageData = new FeatureUsageData().addData(LANGUAGE_LEVEL_DATA, "unknown");
            if (featureUsageData == null) {
                PhpSettingsUsageCollector.$$$reportNull$$$0(9);
            }
            return featureUsageData;
        }
        PhpDebugExtension extension = PhpSettingsUsageCollector.getDebuggerExtensionId(info);
        String debuggerId = extension != null ? extension.getId() : "unknown";
        PhpLanguageLevel level = PhpLanguageLevel.parse(info.getShortVersion());
        if (level == null) {
            FeatureUsageData featureUsageData = new FeatureUsageData().addData(LANGUAGE_LEVEL_DATA, "invalid.format").addData(DEBUGGER_DATA, debuggerId);
            if (featureUsageData == null) {
                PhpSettingsUsageCollector.$$$reportNull$$$0(10);
            }
            return featureUsageData;
        }
        FeatureUsageData featureUsageData = new FeatureUsageData().addData(LANGUAGE_LEVEL_DATA, level.getPresentableName()).addData(IS_PROJECT_LEVEL_DATA, projectLevel == level).addData(DEBUGGER_DATA, debuggerId);
        if (featureUsageData == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(11);
        }
        return featureUsageData;
    }

    @Nullable
    private static PhpDebugExtension getDebuggerExtensionId(@NotNull PhpInfo info) {
        List<PhpDebuggerInfo> debuggers;
        if (info == null) {
            PhpSettingsUsageCollector.$$$reportNull$$$0(12);
        }
        if (!(debuggers = info.getDebuggers()).isEmpty()) {
            PhpDebuggerInfo debuggerInfo = debuggers.get(0);
            if (StringUtil.equals((CharSequence)debuggerInfo.getDebugger(), (CharSequence)XdebugExtension.INSTANCE.getName())) {
                return XdebugExtension.INSTANCE;
            }
            if (StringUtil.equals((CharSequence)debuggerInfo.getDebugger(), (CharSequence)ZendDebuggerExtension.INSTANCE.getName())) {
                return ZendDebuggerExtension.INSTANCE;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpSettingsUsageCollector";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = INTERPRETER_METRIC;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpSettingsUsageCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultInterpreterMetric";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterpreterData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPhpCodeStyle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultInterpreterMetric";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInterpreterData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggerExtensionId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpDebugServerInfo {
        private final PhpDebugExtension myExtension;
        private final boolean myWithMappings;

        private PhpDebugServerInfo(@NotNull PhpDebugExtension extension, boolean withMappings) {
            if (extension == null) {
                PhpDebugServerInfo.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
            this.myWithMappings = withMappings;
        }

        @NotNull
        public FeatureUsageData createData() {
            FeatureUsageData featureUsageData = new FeatureUsageData().addData(PhpSettingsUsageCollector.DEBUGGER_DATA, this.myExtension.getId()).addData(PhpSettingsUsageCollector.WITH_MAPPINGS_DATA, this.myWithMappings);
            if (featureUsageData == null) {
                PhpDebugServerInfo.$$$reportNull$$$0(1);
            }
            return featureUsageData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpDebugServerInfo info = (PhpDebugServerInfo)o;
            return this.myWithMappings == info.myWithMappings && Objects.equals(this.myExtension, info.myExtension);
        }

        public int hashCode() {
            return Objects.hash(this.myExtension, this.myWithMappings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/statistics/PhpSettingsUsageCollector$PhpDebugServerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/statistics/PhpSettingsUsageCollector$PhpDebugServerInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

