/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDefaultNameInterpretersCollectorHelper {
    private static final PhpDefaultNameInterpretersCollectorHelper ourDefaultNameCollector = new PhpDefaultNameInterpretersCollectorHelper();
    private static final String EXTENDED_NAME_METRIC = "extended.name";
    private static final String DEFAULT_NAME_METRIC = "default.name";
    private static final String CUSTOM_NAME_METRIC = "custom.name";
    private static final String INTERPRETER_TYPE_FIELD = "interpreter_type";
    protected static final String LOCAL = "local";

    @NotNull
    public Set<MetricEvent> collectMetrics(@Nullable Project project) {
        boolean isProjectLevel = project != null;
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
        if (manager == null) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(0);
            }
            return set;
        }
        THashSet metrics = new THashSet();
        List<PhpInterpreter> localInterpreters = manager.getInterpreters().stream().filter(interpreter -> interpreter.isProjectLevel() == isProjectLevel).filter(interpreter -> !interpreter.isRemote()).collect(Collectors.toList());
        this.collectMetrics(project, null, localInterpreters, (Set<MetricEvent>)metrics);
        Map remoteInterpreters = manager.getInterpreters().stream().filter(interpreter -> interpreter.isProjectLevel() == isProjectLevel).filter(interpreter -> interpreter.getPhpSdkAdditionalData() instanceof RemoteSdkAdditionalData).collect(Collectors.groupingBy(interpreter -> ((RemoteSdkAdditionalData)interpreter.getPhpSdkAdditionalData()).getRemoteConnectionType(), Collectors.mapping(Function.identity(), Collectors.toList())));
        for (Map.Entry entry : remoteInterpreters.entrySet()) {
            this.collectMetrics(project, entry.getKey(), entry.getValue(), (Set<MetricEvent>)metrics);
        }
        THashSet tHashSet = metrics;
        if (tHashSet == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    protected void collectMetrics(@Nullable Project project, @Nullable CredentialsType type, @NotNull List<PhpInterpreter> interpreters, @NotNull Set<MetricEvent> metrics) {
        boolean byJB;
        if (interpreters == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(2);
        }
        if (metrics == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(3);
        }
        List notDefault = ContainerUtil.filter(interpreters, interpreter -> !PhpDefaultNameInterpretersCollectorHelper.isDefaultName(project, interpreter));
        int numNotDefault = notDefault.size();
        int numExtendedDefault = (Integer)notDefault.stream().filter(interpreter -> PhpDefaultNameInterpretersCollectorHelper.isExtendedDefaultName(project, interpreter)).collect(MoreCollectors.countingInt());
        boolean bl = byJB = type == null || PluginInfoDetectorKt.getPluginInfo(type.getClass()).isDevelopedByJetBrains();
        String typeName = type != null ? (byJB ? PhpDefaultNameInterpretersCollectorHelper.escapeUsageKey(type.getName()) : "third.party") : LOCAL;
        FeatureUsageData data = new FeatureUsageData().addData("level", project == null ? "ide" : "project");
        MetricEventUtilKt.addCounterIfNotZero(metrics, (String)DEFAULT_NAME_METRIC, (int)(interpreters.size() - numNotDefault), (FeatureUsageData)data.addData(INTERPRETER_TYPE_FIELD, typeName));
        MetricEventUtilKt.addCounterIfNotZero(metrics, (String)EXTENDED_NAME_METRIC, (int)numExtendedDefault, (FeatureUsageData)data.addData(INTERPRETER_TYPE_FIELD, typeName));
        MetricEventUtilKt.addCounterIfNotZero(metrics, (String)CUSTOM_NAME_METRIC, (int)(numNotDefault - numExtendedDefault), (FeatureUsageData)data.addData(INTERPRETER_TYPE_FIELD, typeName));
    }

    @NotNull
    protected static String escapeUsageKey(@NotNull String key) {
        if (key == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(4);
        }
        String string = StringUtil.replace((String)StringUtil.toLowerCase((String)key), (String)" ", (String)"-");
        if (string == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isDefaultName(@Nullable Project project, @NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(6);
        }
        String name = interpreter.getName();
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(name);
        String suggested = interpreter.getPhpSdkAdditionalData().suggestName(info);
        if (StringUtil.equals((CharSequence)suggested, (CharSequence)name)) {
            return true;
        }
        return StringUtil.startsWith((CharSequence)name, (CharSequence)suggested) && PhpDefaultNameInterpretersCollectorHelper.isCounterPrefix(name, suggested.length());
    }

    private static boolean isCounterPrefix(@NotNull String name, int prefixStart) {
        int nameLength;
        if (name == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(7);
        }
        if ((nameLength = name.length()) <= prefixStart + 3) {
            return false;
        }
        if (name.charAt(nameLength - 1) == ')' && name.charAt(prefixStart) == ' ' && name.charAt(prefixStart + 1) == '(') {
            String count = name.substring(prefixStart + 2, nameLength - 1);
            try {
                return Integer.valueOf(count) > 0;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isExtendedDefaultName(@Nullable Project project, @NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(8);
        }
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName());
        String suggested = interpreter.getPhpSdkAdditionalData().suggestName(info);
        return StringUtil.containsIgnoreCase((String)interpreter.getName(), (String)suggested);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetrics";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeUsageKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectMetrics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeUsageKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCounterPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExtendedDefaultName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ApplicationUsageCollector
    extends ApplicationUsagesCollector {
        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set<MetricEvent> set = ourDefaultNameCollector.collectMetrics(null);
            if (set == null) {
                ApplicationUsageCollector.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public String getGroupId() {
            return "php.interpreters.default.name";
        }

        public int getVersion() {
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ApplicationUsageCollector", "getMetrics"));
        }
    }

    public static class ProjectUsageCollector
    extends ProjectUsagesCollector {
        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            if (project == null) {
                ProjectUsageCollector.$$$reportNull$$$0(0);
            }
            Set<MetricEvent> set = ourDefaultNameCollector.collectMetrics(project);
            if (set == null) {
                ProjectUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public String getGroupId() {
            return "php.interpreters.default.name";
        }

        public int getVersion() {
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ProjectUsageCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ProjectUsageCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

