/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.config.PhpAnalysisConfiguration;
import com.jetbrains.php.config.PhpCustomFormatFunctionsConfiguration;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/statistics/PhpAnalysisSettingsUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getVersion", "", "intellij.php.impl"})
public final class PhpAnalysisSettingsUsageCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "php.config.analysis";
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PhpAnalysisConfiguration analysisConfiguration = PhpAnalysisConfiguration.getInstance(project);
        PhpCustomFormatFunctionsConfiguration phpCustomFormatFunctionsConfiguration = PhpCustomFormatFunctionsConfiguration.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)phpCustomFormatFunctionsConfiguration, (String)"PhpCustomFormatFunctions\u2026tion.getInstance(project)");
        int customFunctionsCount = phpCustomFormatFunctionsConfiguration.getFunctions().size();
        Object[] objectArray = new MetricEvent[4];
        objectArray[0] = MetricEventFactoryKt.newCounterMetric((String)"custom.format.functions", (int)customFunctionsCount);
        PhpAnalysisConfiguration phpAnalysisConfiguration = analysisConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)phpAnalysisConfiguration, (String)"analysisConfiguration");
        objectArray[1] = MetricEventFactoryKt.newCounterMetric((String)"unchecked.exceptions", (int)phpAnalysisConfiguration.getUncheckedExceptions().size());
        objectArray[2] = MetricEventFactoryKt.newBooleanMetric((String)"skip.constant.params", (boolean)analysisConfiguration.getSkipConstantParams());
        objectArray[3] = MetricEventFactoryKt.newMetric((String)"call.tree.analysis.depth", (int)analysisConfiguration.getCallTreeAnalysisDepth());
        return SetsKt.setOf((Object[])objectArray);
    }
}

