/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.spellchecker;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.PsiIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BinaryOperator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PhpSpellcheckingStrategy
extends SpellcheckingStrategy {
    private static final StringLiteralTokenizer STRING_LITERAL_TOKENIZER = new StringLiteralTokenizer();
    private static final DocCommentTokenizer DOC_COMMENT_TOKENIZER = new DocCommentTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiNameIdentifierOwner && element instanceof PhpDocPsiElement) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                PhpSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element instanceof PhpDocComment) {
            DocCommentTokenizer docCommentTokenizer = DOC_COMMENT_TOKENIZER;
            if (docCommentTokenizer == null) {
                PhpSpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return docCommentTokenizer;
        }
        if (element instanceof PsiComment) {
            Tokenizer tokenizer = this.myCommentTokenizer;
            if (tokenizer == null) {
                PhpSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        if (element instanceof LeafPsiElement && PhpTokenTypes.tsSTRINGS.contains(element.getNode().getElementType()) && (parent = element.getParent()) instanceof StringLiteralExpression) {
            Object object = InjectedLanguageManager.getInstance((Project)parent.getProject()).getInjectedPsiFiles(parent) != null ? EMPTY_TOKENIZER : STRING_LITERAL_TOKENIZER;
            if (object == null) {
                PhpSpellcheckingStrategy.$$$reportNull$$$0(3);
            }
            return object;
        }
        if (element instanceof Variable && !((Variable)element).isDeclaration()) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                PhpSpellcheckingStrategy.$$$reportNull$$$0(4);
            }
            return tokenizer;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            PsiIdentifierOwnerTokenizer psiIdentifierOwnerTokenizer = PsiIdentifierOwnerTokenizer.INSTANCE;
            if (psiIdentifierOwnerTokenizer == null) {
                PhpSpellcheckingStrategy.$$$reportNull$$$0(5);
            }
            return psiIdentifierOwnerTokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            PhpSpellcheckingStrategy.$$$reportNull$$$0(6);
        }
        return tokenizer;
    }

    private static void processTextWithEscapedChars(@NotNull String text, @NotNull PsiElement element, boolean singleQuoted, TokenConsumer consumer) {
        if (text == null) {
            PhpSpellcheckingStrategy.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PhpSpellcheckingStrategy.$$$reportNull$$$0(8);
        }
        if (singleQuoted) {
            consumer.consumeToken(element, (Splitter)PlainTextSplitter.getInstance());
        } else {
            BinaryOperator merger = (i, j) -> Pair.create((Object)((TextRange)i.first).union((TextRange)j.first), (Object)((IElementType)i.second));
            ((StreamEx)StreamEx.of((Spliterator)new PhpStringUtil.StringLiteralSpliterator(text, false)).collapse((pair1, pair2) -> PhpSpellcheckingStrategy.collapsible((Pair<TextRange, IElementType>)pair1, (Pair<TextRange, IElementType>)pair2, text), merger).filter(pair -> !StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains((IElementType)pair.getSecond()))).forEach(pair -> {
                TextRange textRange = (TextRange)pair.first;
                String tokenText = textRange.substring(text);
                consumer.consumeToken(element, tokenText, false, textRange.getStartOffset(), TextRange.allOf((String)tokenText), (Splitter)PlainTextSplitter.getInstance());
            });
        }
    }

    private static boolean collapsible(@NotNull Pair<TextRange, IElementType> pair1, @NotNull Pair<TextRange, IElementType> pair2, @NotNull String text) {
        if (pair1 == null) {
            PhpSpellcheckingStrategy.$$$reportNull$$$0(9);
        }
        if (pair2 == null) {
            PhpSpellcheckingStrategy.$$$reportNull$$$0(10);
        }
        if (text == null) {
            PhpSpellcheckingStrategy.$$$reportNull$$$0(11);
        }
        return !StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains((IElementType)pair1.second) && StringUtil.startsWith((CharSequence)text, (int)((TextRange)pair1.first).getStartOffset(), (CharSequence)"\\") && !StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains((IElementType)pair2.second) && !StringUtil.startsWith((CharSequence)text, (int)((TextRange)pair2.first).getStartOffset(), (CharSequence)"\\");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/spellchecker/PhpSpellcheckingStrategy";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/spellchecker/PhpSpellcheckingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTextWithEscapedChars";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collapsible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringLiteralTokenizer
    extends Tokenizer<PsiElement> {
        private StringLiteralTokenizer() {
        }

        public void tokenize(@NotNull PsiElement element, TokenConsumer consumer) {
            if (element == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(0);
            }
            String text = element.getText();
            if (element.getNode() == null || text.isEmpty()) {
                return;
            }
            StringLiteralExpression literal = (StringLiteralExpression)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
            if (literal == null) {
                return;
            }
            if (StringUtil.contains((CharSequence)text, (CharSequence)"\\")) {
                PhpSpellcheckingStrategy.processTextWithEscapedChars(element.getText(), element, literal.isSingleQuote() || PhpHeredocToStringIntention.isNowdoc((PsiElement)literal), consumer);
            } else {
                consumer.consumeToken(element, (Splitter)PlainTextSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/spellchecker/PhpSpellcheckingStrategy$StringLiteralTokenizer", "tokenize"));
        }
    }

    public static class DocCommentTokenizer
    extends Tokenizer<PhpDocComment> {
        private static final Set<String> excludedTags = ContainerUtil.immutableSet((Object[])new String[]{"@author", "@see", "@link", "@file", "@package", "@subpackage", "@filesource"});
        final TokenSet excludedTypes = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, PhpDocTokenTypes.DOC_URL, PhpDocTokenTypes.DOC_MAIL, PhpDocTokenTypes.DOC_LEADING_ASTERISK, PhpDocTokenTypes.DOC_COMMENT_START, PhpDocTokenTypes.DOC_COMMENT_END, PhpDocTokenTypes.DOC_LPAREN, PhpDocTokenTypes.DOC_RPAREN, PhpDocTokenTypes.DOC_LBRACE, PhpDocTokenTypes.DOC_RBRACE, PhpDocTokenTypes.DOC_LBRACKET, PhpDocTokenTypes.DOC_RBRACKET, PhpDocTokenTypes.DOC_DOT, PhpDocTokenTypes.DOC_COMMA, PhpDocTokenTypes.DOC_PIPE, PhpDocTokenTypes.DOC_TAG_NAME, PhpDocTokenTypes.DOC_HTML_TAG, PhpDocElementTypes.phpDocAttributeList});

        public void tokenize(@NotNull PhpDocComment comment, final TokenConsumer consumer) {
            if (comment == null) {
                DocCommentTokenizer.$$$reportNull$$$0(0);
            }
            IdentifierSplitter splitter = IdentifierSplitter.getInstance();
            comment.accept((PsiElementVisitor)new PhpRecursiveElementVisitor((Splitter)splitter){
                final /* synthetic */ Splitter val$splitter;
                {
                    this.val$splitter = splitter;
                }

                public void visitElement(@NotNull PsiElement el) {
                    IElementType type;
                    if (el == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (excludedTypes.contains(type = el.getNode().getElementType()) || el instanceof PhpDocType || el instanceof PhpDocVariable) {
                        return;
                    }
                    if (el instanceof PhpDocComment || type == PhpDocElementTypes.phpDocTagValue) {
                        super.visitElement(el);
                        return;
                    }
                    if (el instanceof PhpDocTag) {
                        if (!excludedTags.contains(((PhpDocTag)el).getName())) {
                            super.visitElement(el);
                        }
                        return;
                    }
                    if (type == PhpDocTokenTypes.DOC_IDENTIFIER) {
                        consumer.consumeToken(el, this.val$splitter);
                        return;
                    }
                    if (type == PhpDocTokenTypes.DOC_TEXT || type == PhpDocTokenTypes.DOC_STRING || type == PhpDocTokenTypes.DOC_IGNORED) {
                        consumer.consumeToken(el, (Splitter)PlainTextSplitter.getInstance());
                        return;
                    }
                    consumer.consumeToken(el, this.val$splitter);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/jetbrains/php/spellchecker/PhpSpellcheckingStrategy$DocCommentTokenizer$1", "visitElement"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/jetbrains/php/spellchecker/PhpSpellcheckingStrategy$DocCommentTokenizer", "tokenize"));
        }
    }
}

