/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.FontUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.slicer.PhpSliceLeafUsage;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSliceUsageCellRenderer
extends SliceUsageCellRendererBase {
    public void customizeCellRendererFor(@NotNull SliceUsage sliceUsage) {
        PhpClass aClass;
        if (sliceUsage == null) {
            PhpSliceUsageCellRenderer.$$$reportNull$$$0(0);
        }
        TextChunk[] text = sliceUsage.getPresentation().getText();
        boolean isDereferenceUsage = sliceUsage instanceof PhpSliceLeafUsage;
        for (int i = 0; i < text.length; ++i) {
            TextChunk textChunk = text[i];
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            if (isDereferenceUsage) {
                attributes = attributes.derive(attributes.getStyle(), (Color)JBColor.DARK_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            this.append(textChunk.getText(), attributes);
            if (i != 0) continue;
            this.append(FontUtil.spaceAndThinSpace());
        }
        PsiElement element = sliceUsage.getElement();
        Method method = (Method)PsiTreeUtil.getParentOfType((PsiElement)element, Method.class);
        PhpClass phpClass = aClass = method == null ? (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)element, PhpClass.class) : method.getContainingClass();
        String location = method != null ? PhpSliceUsageCellRenderer.formatMethod(method) : (aClass != null ? PhpSliceUsageCellRenderer.formatClass(aClass) : PhpSliceUsageCellRenderer.formatFile(element.getContainingFile()));
        if (location != null) {
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
            this.append(PhpBundle.message("in.0", location), attributes);
        }
    }

    @Nullable
    private static String formatFile(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    @NotNull
    private static String formatMethod(@NotNull Method method) {
        if (method == null) {
            PhpSliceUsageCellRenderer.$$$reportNull$$$0(1);
        }
        StringBuilder buffer = new StringBuilder();
        PhpClass aClass = method.getContainingClass();
        if (aClass != null) {
            String name = PhpSliceUsageCellRenderer.formatClass(aClass);
            buffer.append(name);
            buffer.append("::");
        }
        buffer.append(method.getName());
        String string = buffer.toString();
        if (string == null) {
            PhpSliceUsageCellRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String formatClass(@NotNull PhpClass aClass) {
        if (aClass == null) {
            PhpSliceUsageCellRenderer.$$$reportNull$$$0(3);
        }
        String string = aClass.getName();
        if (string == null) {
            PhpSliceUsageCellRenderer.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sliceUsage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/slicer/PhpSliceUsageCellRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/slicer/PhpSliceUsageCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRendererFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

