/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.settingsSummary.util;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.config.servers.PhpServersWorkspaceStateComponent;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfiguration;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.debug.xdebug.proxy.DBGPProxySettings;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.builtInWebServer.PhpBuiltInWebServerConfiguration;
import com.jetbrains.php.run.httpRequest.PhpHttpRequestRunConfiguration;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.run.remoteDebug.PhpRemoteDebugRunConfiguration;
import com.jetbrains.php.run.script.PhpScriptRunConfiguration;
import com.jetbrains.php.run.webApp.PhpWebAppRunConfiguration;
import com.jetbrains.php.settingsSummary.util.PhpCredentialsContribution;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSettingsCollector {
    public static void collectCurrentPHPInterpreter(@NotNull Project project, final @NotNull StringBuilder output) {
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(0);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(1);
        }
        PhpProjectConfigurationFacade facade = PhpProjectConfigurationFacade.getInstance(project);
        PhpInterpreter interpreter = facade.getInterpreter();
        output.append("=====PHP INTERPRETER=====\n");
        if (interpreter != null) {
            PhpSettingsCollector.appendEntry("Name", interpreter.getName(), output);
            PhpSettingsCollector.appendEntry("Remote", interpreter.isRemote(), output);
            PhpSettingsCollector.appendEntry("Project level", interpreter.isProjectLevel(), output);
            if (interpreter.isRemote()) {
                PhpSdkAdditionalData phpData = interpreter.getPhpSdkAdditionalData();
                RemoteSdkAdditionalData additionalData = (RemoteSdkAdditionalData)phpData;
                PhpSettingsCollector.appendEntry("Connection type", additionalData.getRemoteConnectionType().getName(), output);
                additionalData.switchOnConnectionType(new LanguageCaseCollector<PhpCredentialsContribution>(){

                    protected void processLanguageContribution(PhpCredentialsContribution languageContribution, Object credentials) {
                        languageContribution.collectSettings(credentials, output);
                    }
                }.collectCases(PhpCredentialsContribution.class, new CredentialsCase[0]));
                PhpSettingsCollector.appendEntry("Mappings", "", output);
                PhpRemoteInterpreterManager remoteInterpreterManager = PhpRemoteInterpreterManager.getInstance();
                if (remoteInterpreterManager != null) {
                    PathMappingSettings mappingSettings = remoteInterpreterManager.createPathMappings(project, phpData);
                    for (PathMappingSettings.PathMapping pathMapping : mappingSettings.getPathMappings()) {
                        PhpSettingsCollector.appendEscapedMappingEntry(pathMapping.getLocalRoot(), pathMapping.getRemoteRoot(), output);
                    }
                }
            }
            PhpSettingsCollector.appendEntry("Path to PHP executable", interpreter.getPathToPhpExecutable(), output);
            PhpInfo info = facade.getPhpInfo();
            if (info != null) {
                PhpSettingsCollector.appendEntry("Version", info.getVersion(), output);
                for (PhpDebuggerInfo debuggerInfo : info.getDebuggers()) {
                    PhpSettingsCollector.appendEntry("Debug extension", debuggerInfo.toString(), output);
                    PhpSettingsCollector.appendEscapedEntry("Main php.ini path", info.getConfigurationFile(), output);
                    PhpSettingsCollector.appendEscapedEntry("Additional php.ini path", info.getAdditionalPhpIni(), output);
                }
            }
        }
    }

    public static void collectIsListening(@NotNull Project project, @NotNull StringBuilder output) {
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(2);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(3);
        }
        PhpDebugExternalConnectionsAccepter connectionsAccepter = PhpDebugExternalConnectionsAccepter.getInstance(project);
        PhpSettingsCollector.appendEntry("Debug listening ", connectionsAccepter.isStarted(), output);
    }

    public static void collectDebugSettings(@NotNull Project project, @NotNull StringBuilder output) {
        PhpProjectDebugConfiguration.State mainSettings;
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(4);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(5);
        }
        if ((mainSettings = PhpProjectDebugConfiguration.getInstance(project).getState()) == null) {
            return;
        }
        output.append("=====DEBUG MAIN SETTINGS=====\n");
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.safe.evaluation.mode", new Object[0]), mainSettings.isSafeEvaluationMode(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.import.use.statements", new Object[0]), mainSettings.isImportUseStatementsFromContext(), output);
        PhpSettingsCollector.appendEntry("Ignore external connections", mainSettings.isIgnoreConnectionsThroughUnregisteredServers(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.detect.path.mappings.from.deployment", new Object[0]), mainSettings.isDetectPathMappingsFromDeploymentConfigurations(), output);
        PhpSettingsCollector.appendEntry("Max. simultaneous connections", mainSettings.getMaxSimultaneousConnections(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.notify.session.stopped.without.pause", new Object[0]), mainSettings.isNotifyIfSessionWasFinishedWithoutBeingPaused(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugBreakAtFirstLineToggleAction.text", new Object[0]), mainSettings.isBreakAtFirstLine(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.xdebug.debug.port", new Object[0]), StringUtil.join(mainSettings.getXDebugDebugPorts(), (String)","), output);
        PhpSettingsCollector.appendEntry("Can accept external connections", mainSettings.isXDebugCanAcceptExternalConnections(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.xdebug.force.break.no.path.mapping", new Object[0]), mainSettings.isXdebugForceBreakWhenNoPathMapping(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.xdebug.force.break.when.outside.project", new Object[0]), mainSettings.isXdebugForceBreakWhenOutsideProject(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.zend.debug.port", new Object[0]), mainSettings.getZendDebuggerDebugPort(), output);
        PhpSettingsCollector.appendEntry("Can accept external connections", mainSettings.isZendDebuggerCanAcceptExternalConnections(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugConfigurable.zend.settings.broadcasting.port", new Object[0]), mainSettings.getZendDebuggerSettingsBroadcastingPort(), output);
    }

    public static void collectDebugSkippedPaths(@NotNull Project project, @NotNull StringBuilder output) {
        PhpDebugSkippedPathsConfiguration.State skippedPaths;
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(6);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(7);
        }
        if ((skippedPaths = PhpDebugSkippedPathsConfiguration.getInstance(project).getState()) == null) {
            return;
        }
        output.append("=====SKIPPED PATHS=====\n");
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugSkippedPathsConfigurable.notify.about.skipped.files", new Object[0]), skippedPaths.isNotify(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpDebugSkippedPathsConfigurable.column.title", new Object[0]), "", output);
        for (String path : skippedPaths.getSkippedFiles()) {
            PhpSettingsCollector.appendEntry(path, "", output);
        }
    }

    public static void collectDbgpProxySettings(@NotNull Project project, @NotNull StringBuilder output) {
        DBGPProxySettings.State dbgp;
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(8);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(9);
        }
        if ((dbgp = DBGPProxySettings.getInstance(project).getState()) == null) {
            return;
        }
        output.append("=====DBGP SETTINGS=====\n");
        PhpSettingsCollector.appendEntry(PhpBundle.message("DBGPProxyConfigurable.ide.key", new Object[0]), dbgp.getIdeKey(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("DBGPProxyConfigurable.host", new Object[0]), dbgp.getProxyHost(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("DBGPProxyConfigurable.port", new Object[0]), dbgp.getProxyPort(), output);
    }

    public static void collectDebugStepFilters(@NotNull Project project, @NotNull StringBuilder output) {
        PhpStepFiltersConfiguration.State stepFilter;
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(10);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(11);
        }
        if ((stepFilter = PhpStepFiltersConfiguration.getInstance(project).getState()) == null) {
            return;
        }
        output.append("=====STEP FILTERS=====\n");
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpStepFiltersConfigurable.skip.magic.methods", new Object[0]), stepFilter.isSkipMagicMethods(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpStepFiltersConfigurable.skip.constructors", new Object[0]), stepFilter.isSkipConstructors(), output);
        PhpSettingsCollector.appendEntry(PhpBundle.message("PhpStepFiltersConfigurable.skipped.methods", new Object[0]), "", output);
        stepFilter.getSerializedIgnoredFunctions().forEach(function -> PhpSettingsCollector.appendEntry(function, "", output));
        stepFilter.getSerializedIgnoredFiles().forEach(file -> PhpSettingsCollector.appendEntry(file, "", output));
    }

    public static void collectDebugServers(@NotNull Project project, @NotNull StringBuilder output) {
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(12);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(13);
        }
        output.append("=====DEBUG SERVERS=====\n");
        PhpServersWorkspaceStateComponent debugServers = PhpServersWorkspaceStateComponent.getInstance(project);
        PhpSettingsCollector.appendEntry("Debug Servers", "", output);
        for (PhpServer server : debugServers.getServers()) {
            output.append("------------------------\n");
            PhpSettingsCollector.appendEntry("Server name", server.getName(), output);
            PhpSettingsCollector.appendEntry(PhpBundle.message("PhpServerConfigurable.host", new Object[0]), server.getHost(), output);
            PhpSettingsCollector.appendEntry(PhpBundle.message("PhpServerConfigurable.port", new Object[0]), server.getPort(), output);
            PhpSettingsCollector.appendEntry(PhpBundle.message("PhpInterpreter.php.debugger.label", new Object[0]), server.getDebuggerId(), output);
            PhpSettingsCollector.appendEntry("Use path mappings", server.isUsePathMappings(), output);
            PhpSettingsCollector.appendEntry("Mappings", "", output);
            for (PathMappingSettings.PathMapping mapping : server.getSerializedMappings()) {
                PhpSettingsCollector.appendEscapedMappingEntry(mapping.getLocalRoot(), mapping.getRemoteRoot(), output);
            }
        }
    }

    public static void collectPhpUnitSettings(@NotNull Project project, @NotNull StringBuilder output) {
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(14);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(15);
        }
        output.append("=====PHPUNIT SETTINGS=====\n");
        List<PhpUnitSettings> settingsList = PhpUnitSettingsManager.getInstance(project).getAllSettings();
        for (PhpUnitSettings settings : settingsList) {
            output.append("-----------------------------\n");
            PhpSettingsCollector.appendEntry("Name", settings.getPresentableName(project), output);
            PhpSettingsCollector.appendEntry("Loader type", settings.getLoadMethod().name(), output);
            switch (settings.getLoadMethod()) {
                case CUSTOM_LOADER: {
                    PhpSettingsCollector.appendEscapedEntry("Path to script", settings.getCustomLoaderPath(), output);
                    break;
                }
                case PHPUNIT_PHAR: {
                    PhpSettingsCollector.appendEscapedEntry("Path to phar", settings.getPhpUnitPharPath(), output);
                }
            }
            PhpSettingsCollector.appendEscapedEntry("Default configuration file", settings.getConfigurationFilePath(), output);
            PhpSettingsCollector.appendEscapedEntry("Default bootstrap file", settings.getBootstrapFilePath(), output);
        }
    }

    public static void collectCurrentRunConfiguration(@NotNull Project project, @NotNull StringBuilder output) {
        if (project == null) {
            PhpSettingsCollector.$$$reportNull$$$0(16);
        }
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(17);
        }
        RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project).getSelectedConfiguration();
        output.append("=====RUN CONFIGURATION=====\n");
        if (configuration != null) {
            RunConfiguration runConfiguration = configuration.getConfiguration();
            PhpSettingsCollector.appendEntry("Configuration name", runConfiguration.getName(), output);
            PhpSettingsCollector.appendEntry("Configuration type", runConfiguration.getType().getDisplayName(), output);
            if (runConfiguration instanceof PhpBuiltInWebServerConfiguration) {
                PhpBuiltInWebServerConfiguration.Settings settings = (PhpBuiltInWebServerConfiguration.Settings)((PhpBuiltInWebServerConfiguration)runConfiguration).getSettings();
                PhpSettingsCollector.appendEntry("Host", settings.getHost(), output);
                PhpSettingsCollector.appendEntry("Port", settings.getPort(), output);
                PhpSettingsCollector.appendEscapedEntry("Document Root", settings.getDocumentRoot(), output);
                PhpSettingsCollector.appendEntry("Use router script", settings.isUseRouterScript(), output);
                PhpSettingsCollector.appendEscapedEntry("Router Script", settings.getRouterScript(), output);
                PhpSettingsCollector.appendEntry("Interpreter options", settings.getCommandLineSettings().getParameters(), output);
                PhpSettingsCollector.appendEscapedEntry("Working directory", settings.getWorkingDirectory(), output);
            } else if (runConfiguration instanceof PhpHttpRequestRunConfiguration) {
                PhpHttpRequestRunConfiguration.Settings settings = (PhpHttpRequestRunConfiguration.Settings)((PhpHttpRequestRunConfiguration)runConfiguration).getSettings();
                PhpSettingsCollector.appendEntry("Server", settings.getServerName(), output);
                PhpSettingsCollector.appendEscapedEntry("URL", settings.getUrl(), output);
                PhpSettingsCollector.appendEntry("HTTPS", settings.isHTTPS(), output);
                PhpSettingsCollector.appendEntry("Request method", settings.getHttpRequestSettings().getRequestMethod().name(), output);
                PhpSettingsCollector.appendEntry("Query String", settings.getHttpRequestSettings().getQueryString(), output);
                PhpSettingsCollector.appendEntry("Request body", settings.getHttpRequestSettings().getRequestBody(), output);
            } else if (runConfiguration instanceof PhpRemoteDebugRunConfiguration) {
                PhpRemoteDebugRunConfiguration.Settings settings = (PhpRemoteDebugRunConfiguration.Settings)((PhpRemoteDebugRunConfiguration)runConfiguration).getSettings();
                PhpSettingsCollector.appendEntry("Server", settings.getServerName(), output);
                PhpSettingsCollector.appendEntry("Ide key", settings.getSessionId(), output);
            } else if (runConfiguration instanceof PhpWebAppRunConfiguration) {
                PhpWebAppRunConfiguration.Settings settings = (PhpWebAppRunConfiguration.Settings)((PhpWebAppRunConfiguration)runConfiguration).getSettings();
                PhpSettingsCollector.appendEntry("Server", settings.getServerName(), output);
                PhpSettingsCollector.appendEscapedEntry("Start URL", settings.getStartUrl(), output);
                PhpSettingsCollector.appendEntry("HTTPS", settings.isHTTPS(), output);
                WebBrowser browser = settings.getBrowser();
                if (browser != null) {
                    PhpSettingsCollector.appendEntry("Browser", browser.getName(), output);
                }
            } else if (runConfiguration instanceof PhpUnitLocalRunConfiguration) {
                PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)((PhpUnitLocalRunConfiguration)runConfiguration).getSettings();
                PhpUnitTestRunnerSettings runnerSettings = settings.getTestRunnerSettings();
                PhpCommandLineSettings commandLineSettings = settings.getCommandLineSettings();
                PhpSettingsCollector.appendEntry("Test scope", runnerSettings.getScope().name(), output);
                switch (runnerSettings.getScope()) {
                    case Directory: {
                        PhpSettingsCollector.appendEscapedEntry("Directory", runnerSettings.getDirectoryPath(), output);
                        break;
                    }
                    case Class: {
                        PhpSettingsCollector.appendEntry("Class", runnerSettings.getClassName(), output);
                        PhpSettingsCollector.appendEscapedEntry("File", runnerSettings.getFilePath(), output);
                        break;
                    }
                    case Method: {
                        PhpSettingsCollector.appendEntry("Method", runnerSettings.getMethodName(), output);
                        PhpSettingsCollector.appendEntry("Class", runnerSettings.getClassName(), output);
                        PhpSettingsCollector.appendEscapedEntry("File", runnerSettings.getFilePath(), output);
                        break;
                    }
                }
                PhpSettingsCollector.appendEscapedEntry("Use alternative configuration file", runnerSettings.getConfigurationFilePath(), output);
                PhpSettingsCollector.appendEscapedEntry("Use bootstrap configuration file", runnerSettings.getBootstrapFilePath(), output);
                PhpSettingsCollector.appendEntry("Test Runner options", runnerSettings.getTestRunnerOptions(), output);
                PhpSettingsCollector.appendEntry("Interpreter options", commandLineSettings.getParameters(), output);
                PhpSettingsCollector.appendEscapedEntry("Working directory", commandLineSettings.getWorkingDirectory(), output);
            } else if (runConfiguration instanceof PhpScriptRunConfiguration) {
                PhpScriptRunConfiguration.Settings settings = (PhpScriptRunConfiguration.Settings)((PhpScriptRunConfiguration)runConfiguration).getSettings();
                PhpCommandLineSettings commandLineSettings = settings.getCommandLineSettings();
                PhpSettingsCollector.appendEscapedEntry("File path", settings.getPath(), output);
                PhpSettingsCollector.appendEntry("Script arguments", settings.getScriptParameters(), output);
                PhpSettingsCollector.appendEntry("Interpreter options", commandLineSettings.getParameters(), output);
                PhpSettingsCollector.appendEscapedEntry("Working directory", commandLineSettings.getWorkingDirectory(), output);
            }
        }
    }

    public static void appendEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(18);
        }
        output.append(key).append(" : ").append(value).append("\n");
    }

    private static void appendEntry(@Nullable String key, int value, @NotNull StringBuilder output) {
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(19);
        }
        PhpSettingsCollector.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEntry(@Nullable String key, boolean value, @NotNull StringBuilder output) {
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(20);
        }
        PhpSettingsCollector.appendEntry(key, String.valueOf(value), output);
    }

    public static void appendEscapedEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(21);
        }
        output.append(key).append(" : \"").append(value).append("\"\n");
    }

    private static void appendEscapedMappingEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            PhpSettingsCollector.$$$reportNull$$$0(22);
        }
        output.append("\"").append(key).append("\" : \"").append(value).append("\"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/settingsSummary/util/PhpSettingsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectCurrentPHPInterpreter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectIsListening";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDebugSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDebugSkippedPaths";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDbgpProxySettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDebugStepFilters";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDebugServers";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "collectPhpUnitSettings";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "collectCurrentRunConfiguration";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "appendEntry";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "appendEscapedEntry";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "appendEscapedMappingEntry";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

