/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.webApp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugProcessFactory;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.run.PhpDebugConnectionInitCallback;
import com.jetbrains.php.run.PhpDebugRunner;
import com.jetbrains.php.run.webApp.PhpWebAppRunConfiguration;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import org.jetbrains.annotations.NotNull;

public class PhpWebAppDebugRunner
extends PhpDebugRunner<PhpWebAppRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(PhpWebAppDebugRunner.class);

    @NotNull
    public String getRunnerId() {
        return "PhpWebAppDebugRunner";
    }

    public PhpWebAppDebugRunner() {
        super(PhpWebAppRunConfiguration.class);
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull PhpWebAppRunConfiguration configuration, @NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (configuration == null) {
            PhpWebAppDebugRunner.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PhpWebAppDebugRunner.$$$reportNull$$$0(1);
        }
        if (env == null) {
            PhpWebAppDebugRunner.$$$reportNull$$$0(2);
        }
        Project project = configuration.getProject();
        PhpWebAppRunConfiguration.Settings settings = (PhpWebAppRunConfiguration.Settings)configuration.getSettings();
        PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(settings.getServerName());
        assert (server != null);
        final String serverName = server.getName();
        assert (serverName != null);
        String debuggerId = server.getDebuggerId();
        if (!PhpDebugUtil.isXDebug(debuggerId) && !PhpDebugUtil.isZendDebugger(debuggerId)) {
            throw new ExecutionException(PhpBundle.message("unknown.debugger.type", new Object[0]));
        }
        final PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId(debuggerId);
        final PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        PhpDebugConnectionInitCallback initCallback = new PhpDebugConnectionInitCallback();
        final PhpIncomingDebugConnectionServer debugServer = debugExtension.startDebugServer(project, initCallback);
        final String sessionId = debugServer.registerSessionHandler(true, connectionsManager).getSessionId();
        boolean breakAtFirstLine = PhpProjectDebugConfiguration.getInstance(project).getState().isBreakAtFirstLine();
        try {
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSession(env, new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    session.addSessionListener(new XDebugSessionListener(){

                        public void sessionStopped() {
                            debugServer.unregisterSessionHandler(sessionId);
                        }
                    });
                    PhpDebugProcess phpDebugProcess = PhpDebugProcessFactory.forRemoteDebug(session, sessionId, connectionsManager, serverName, debugExtension.getDebugDriver());
                    if (phpDebugProcess == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return phpDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/run/webApp/PhpWebAppDebugRunner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/run/webApp/PhpWebAppDebugRunner$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                initCallback.waitForInitialization(project, env);
                if (!debugSession.isStopped()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Debug connection initialized. Opening browser.");
                    }
                    configuration.doExecute(debugExtension.getDebugQuery(project, breakAtFirstLine, sessionId));
                }
            });
            return debugSession.getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/run/webApp/PhpWebAppDebugRunner";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

