/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.remoteDebug;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugConfigInstructionsPanel;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.run.remoteDebug.PhpRemoteDebugRunConfiguration;
import com.jetbrains.php.ui.PhpServerComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class PhpRemoteDebugRunConfigurationEditor
extends SettingsEditor<PhpRemoteDebugRunConfiguration> {
    private static final Runnable OPEN_ZERO_CONFIGURATION_TUTORIAL = () -> HelpManager.getInstance().invokeHelp("php.debugging.zero_configuration");
    private JPanel myMainPanel;
    private PhpServerComboBox myServerComboBox;
    private JTextField mySessionIdTextField;
    private HideableTitledPanel myPreConfigHideablePanel;
    private JBLabel myServerLabel;
    private JCheckBox myFilterConnectionCheckBox;
    private JBLabel myIdeKeyLabel;
    private ContextHelpLabel myContextHelpLabel;
    private final Project myProject;

    public PhpRemoteDebugRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            PhpRemoteDebugRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this, (Disposable)this.myServerComboBox);
        this.myProject = project;
        PhpDebugConfigInstructionsPanel instructions = PhpDebugConfigInstructionsPanel.createRemoteDebugInstructions(() -> this.myServerComboBox.getSelectedServer());
        instructions.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBUI.insetsLeft((int)10)));
        this.myPreConfigHideablePanel.setContentComponent((JComponent)instructions);
        this.myPreConfigHideablePanel.setOn(PhpProjectDebugConfiguration.getInstance(project).getState().isShowPreConfigInRemoteDebug());
        this.myServerLabel.setLabelFor((Component)((Object)this.myServerComboBox));
        this.myServerComboBox.setAllowNoServer(true);
        this.myFilterConnectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpRemoteDebugRunConfigurationEditor.this.updateFilterState(PhpRemoteDebugRunConfigurationEditor.this.myFilterConnectionCheckBox.isSelected());
            }
        });
    }

    private void updateFilterState(boolean enable) {
        this.myServerLabel.setEnabled(enable);
        this.mySessionIdTextField.setEnabled(enable);
        this.myServerComboBox.setEnabled(enable);
        this.myIdeKeyLabel.setEnabled(enable);
    }

    protected void resetEditorFrom(@NotNull PhpRemoteDebugRunConfiguration configuration) {
        if (configuration == null) {
            PhpRemoteDebugRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        PhpRemoteDebugRunConfiguration.Settings settings = (PhpRemoteDebugRunConfiguration.Settings)configuration.getSettings();
        this.myServerComboBox.reset(this.myProject, settings.getServerName());
        this.mySessionIdTextField.setText(settings.getSessionId());
        this.myFilterConnectionCheckBox.setSelected(settings.isFilterEnabled());
        this.updateFilterState(this.myFilterConnectionCheckBox.isSelected());
    }

    protected void applyEditorTo(@NotNull PhpRemoteDebugRunConfiguration configuration) {
        if (configuration == null) {
            PhpRemoteDebugRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        PhpRemoteDebugRunConfiguration.Settings settings = (PhpRemoteDebugRunConfiguration.Settings)configuration.getSettings();
        settings.setServerName(this.myServerComboBox.getSelectedServerName());
        settings.setSessionId(this.mySessionIdTextField.getText().trim());
        settings.setFilterState(this.myFilterConnectionCheckBox.isSelected() ? PhpRemoteDebugRunConfiguration.FilterConnections.FILTER : PhpRemoteDebugRunConfiguration.FilterConnections.NOT_FILTER);
        PhpProjectDebugConfiguration.getInstance(this.myProject).getState().setShowPreConfigInRemoteDebug(this.myPreConfigHideablePanel.isExpanded());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpRemoteDebugRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myPreConfigHideablePanel = new HideableTitledPanel(PhpBundle.message("PhpDebugConfigurable.zero.configuration", new Object[0]), false);
        String title = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.filter.connections.help.title", new Object[0]);
        String description = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.filter.connections.help", new Object[0]);
        String link = PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.filter.connections.help.link", new Object[0]);
        this.myContextHelpLabel = ContextHelpLabel.createWithLink((String)title, (String)description, (String)link, (Runnable)OPEN_ZERO_CONFIGURATION_TUTORIAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/remoteDebug/PhpRemoteDebugRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/remoteDebug/PhpRemoteDebugRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JBLabel jBLabel;
        PhpServerComboBox phpServerComboBox;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpRemoteDebugRunConfigurationEditor.class).getString("RunConfigurationEditor.configuration"), (int)0, (int)0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 6, 0, 3, 3, 3, null, null, null));
        this.myServerLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpRemoteDebugRunConfigurationEditor.class).getString("PhpRemoteDebugRunConfigurationEditor.server.label"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(46, 14), null));
        this.myServerComboBox = phpServerComboBox = new PhpServerComboBox();
        jPanel3.add((Component)((Object)phpServerComboBox), new GridConstraints(0, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myIdeKeyLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpRemoteDebugRunConfigurationEditor.class).getString("PhpRemoteDebugRunConfigurationEditor.session.id.label"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySessionIdTextField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 3, 0, 1, 3, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 4, 0, 1, 6, 1, null, null, null));
        this.myFilterConnectionCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpRemoteDebugRunConfigurationEditor.class).getString("PhpRemoteDebugRunConfigurationEditor.auto.config"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ContextHelpLabel contextHelpLabel = this.myContextHelpLabel;
        jPanel2.add((Component)contextHelpLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        HideableTitledPanel hideableTitledPanel = this.myPreConfigHideablePanel;
        jPanel.add((Component)hideableTitledPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

