/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.httpRequest;

import com.intellij.DynamicBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.run.httpRequest.PhpHttpRequestRunConfiguration;
import com.jetbrains.php.run.httpRequest.PhpHttpRequestSettings;
import com.jetbrains.php.ui.PhpServerComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class PhpHttpRequestRunConfigurationEditor
extends SettingsEditor<PhpHttpRequestRunConfiguration> {
    private JPanel myMainPanel;
    private JTextField myUrlTextField;
    private PhpServerComboBox myServerChooser;
    private HoverHyperlinkLabel myResultUrlHyperlink;
    private JComboBox myRequestMethodComboBox;
    private JTextArea myQueryStringTextArea;
    private JPanel myPostRequestPanel;
    private JTextArea myRequestBodyTextArea;
    private JBRadioButton myRequestFormatAsText;
    private JBRadioButton myRequestFormatAsKeyValue;
    private JBCheckBox myHTTPSCheckBox;
    private final Project myProject;

    public PhpHttpRequestRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            PhpHttpRequestRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this, (Disposable)this.myServerChooser);
        this.myRequestFormatAsText.setSelected(true);
        this.myServerChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpHttpRequestRunConfigurationEditor.this.updateResultUrl();
            }
        });
        this.myUrlTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpHttpRequestRunConfigurationEditor.this.updateResultUrl();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/run/httpRequest/PhpHttpRequestRunConfigurationEditor$2", "textChanged"));
            }
        });
        this.myHTTPSCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpHttpRequestRunConfigurationEditor.this.updateResultUrl();
            }
        });
        this.myResultUrlHyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserUtil.browse((String)PhpHttpRequestRunConfigurationEditor.this.myResultUrlHyperlink.getOriginalText());
                }
            }
        });
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(PhpProjectConfigurationFacade.StateChangedListener.TOPIC, (Object)new PhpProjectConfigurationFacade.StateChangedListener(){

            @Override
            public void stateChanged() {
            }
        });
        this.myRequestMethodComboBox.setModel(new EnumComboBoxModel(PhpHttpRequestSettings.RequestMethod.class));
        this.myRequestMethodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = PhpHttpRequestRunConfigurationEditor.this.myRequestMethodComboBox.getSelectedItem();
                if (selectedItem == PhpHttpRequestSettings.RequestMethod.POST) {
                    PhpHttpRequestRunConfigurationEditor.this.myPostRequestPanel.setVisible(true);
                } else {
                    PhpHttpRequestRunConfigurationEditor.this.myPostRequestPanel.setVisible(false);
                }
            }
        });
    }

    protected void resetEditorFrom(@NotNull PhpHttpRequestRunConfiguration configuration) {
        if (configuration == null) {
            PhpHttpRequestRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        PhpHttpRequestRunConfiguration.Settings settings = (PhpHttpRequestRunConfiguration.Settings)configuration.getSettings();
        this.myServerChooser.reset(this.myProject, settings.getServerName());
        this.myUrlTextField.setText(settings.getUrl());
        this.myHTTPSCheckBox.setSelected(settings.isHTTPS());
        this.myRequestMethodComboBox.setSelectedItem((Object)settings.getHttpRequestSettings().getRequestMethod());
        this.myQueryStringTextArea.setText(settings.getHttpRequestSettings().getQueryString());
        this.myRequestBodyTextArea.setText(settings.getHttpRequestSettings().getRequestBody());
        if (settings.getHttpRequestSettings().getRequestBodyFormat() == PhpHttpRequestSettings.RequestBodyFormat.TEXT) {
            this.myRequestFormatAsText.setSelected(true);
        } else {
            this.myRequestFormatAsKeyValue.setSelected(true);
        }
    }

    protected void applyEditorTo(@NotNull PhpHttpRequestRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            PhpHttpRequestRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        PhpHttpRequestRunConfiguration.Settings settings = (PhpHttpRequestRunConfiguration.Settings)configuration.getSettings();
        settings.setServerName(this.myServerChooser.getSelectedServerName());
        settings.setUrl(this.myUrlTextField.getText().trim());
        settings.setHTTPS(this.myHTTPSCheckBox.isSelected());
        settings.getHttpRequestSettings().setRequestMethod((PhpHttpRequestSettings.RequestMethod)((Object)this.myRequestMethodComboBox.getSelectedItem()));
        settings.getHttpRequestSettings().setQueryString(this.myQueryStringTextArea.getText());
        settings.getHttpRequestSettings().setRequestBody(this.myRequestBodyTextArea.getText());
        settings.getHttpRequestSettings().setRequestBodyFormat(this.myRequestFormatAsText.isSelected() ? PhpHttpRequestSettings.RequestBodyFormat.TEXT : PhpHttpRequestSettings.RequestBodyFormat.KEY_VALUE);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpHttpRequestRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myResultUrlHyperlink = new HoverHyperlinkLabel("");
    }

    private void updateResultUrl() {
        String startUrl = this.myUrlTextField.getText();
        PhpServer selectedServer = this.myServerChooser.getSelectedServer();
        if (selectedServer != null) {
            try {
                selectedServer.checkConfiguration(this.myProject);
                String host = selectedServer.getHost();
                this.myResultUrlHyperlink.setVisible(true);
                this.myResultUrlHyperlink.setText(PhpDebugUtil.createUrl(host, selectedServer.getPort(), this.myHTTPSCheckBox.isSelected() ? "https" : "http", startUrl));
                return;
            }
            catch (RuntimeConfigurationException runtimeConfigurationException) {
                // empty catch block
            }
        }
        this.myResultUrlHyperlink.setVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JTextArea jTextArea;
        JPanel jPanel;
        JTextArea jTextArea2;
        JComboBox jComboBox;
        JTextField jTextField;
        PhpServerComboBox phpServerComboBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.http.border.title.configuration"), (int)0, (int)0, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.label.server"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerChooser = phpServerComboBox = new PhpServerComboBox();
        jPanel3.add((Component)((Object)phpServerComboBox), new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.label.url"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUrlTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myResultUrlHyperlink;
        jPanel4.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 1));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.label.request.method"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRequestMethodComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setHorizontalAlignment(2);
        jBLabel4.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.label.query.string"));
        jPanel5.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(150, -1), null));
        this.myQueryStringTextArea = jTextArea2 = new JTextArea();
        jTextArea2.setLineWrap(true);
        jTextArea2.setRows(4);
        jBScrollPane.setViewportView(jTextArea2);
        this.myPostRequestPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.label.request.body"));
        jPanel.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(150, -1), null));
        this.myRequestBodyTextArea = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setRows(5);
        jBScrollPane2.setViewportView(jTextArea);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.label.send.request.body.as"));
        jPanel6.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myRequestFormatAsKeyValue = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.radio.button.key.value"));
        jPanel6.add((Component)jBRadioButton2, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRequestFormatAsText = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.radio.button.text"));
        jPanel6.add((Component)jBRadioButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpHttpRequestRunConfigurationEditor.class).getString("php.run.label.https"));
        jPanel3.add((Component)jBLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHTTPSCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setHorizontalAlignment(2);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel3.setLabelFor(jComboBox);
        jBLabel4.setLabelFor(jTextArea2);
        jBLabel5.setLabelFor(jTextArea);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

