/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.run.filters.PhpFilter;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugCallStackFilter
extends PhpFilter {
    private static final Logger LOG = Logger.getInstance(XdebugCallStackFilter.class);
    protected static final int MAX_LINE_SIZE = 1000;
    private static final String LINE_NUM_PATTERN = "(?:\\d+)";
    private static final Pattern SHORT_PATTERN = Pattern.compile("\\s(((?:\\p{Alpha}:)?(?:/|\\\\)[^:]*[^:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?)[:]((?:\\d+)))\\s?$");
    private static final Pattern PATTERN_1 = Pattern.compile("^\\s*(?:0|(?:[1-9][\\d]*))[.]\\d*\\s*\\d*\\s*(?:[^/\\w]|(?:\\w[^:]))*(((?:\\p{Alpha}:)?(?:/|\\\\)[^:]*[^:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?)[:]((?:\\d+)))\\s?$");
    private static final Pattern PATTERN_2 = Pattern.compile("^PHP\\s\\s\\s(?:[^\\s]+)\\s(?:[^\\s]+)\\s(((?:\\p{Alpha}:)?(?:/|\\\\)[^:]*[^:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?)[:]((?:\\d+)))");
    private static final Pattern[] PATTERNS = new Pattern[]{PATTERN_1, PATTERN_2};

    public XdebugCallStackFilter(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            XdebugCallStackFilter.$$$reportNull$$$0(0);
        }
        if (pathMapper == null) {
            XdebugCallStackFilter.$$$reportNull$$$0(1);
        }
        super(project, pathMapper);
    }

    @Override
    @Nullable
    public PhpFilter.MyResult applyFilter(@NotNull String line) {
        if (line == null) {
            XdebugCallStackFilter.$$$reportNull$$$0(2);
        }
        return XdebugCallStackFilter.apply(line);
    }

    @Nullable
    public static PhpFilter.MyResult apply(@NotNull String line) {
        if (line == null) {
            XdebugCallStackFilter.$$$reportNull$$$0(3);
        }
        if (line.length() > 1000) {
            return XdebugCallStackFilter.applyPatterns(line.substring(line.length() - 1000), SHORT_PATTERN);
        }
        return XdebugCallStackFilter.applyPatterns(line, PATTERNS);
    }

    private static PhpFilter.MyResult applyPatterns(@NotNull String line, Pattern ... patterns) {
        if (line == null) {
            XdebugCallStackFilter.$$$reportNull$$$0(4);
        }
        for (Pattern pattern : patterns) {
            try {
                Matcher matcher = pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
                if (!matcher.find()) continue;
                String fileName = matcher.group(2);
                String lineNumberString = matcher.group(3);
                if (fileName == null || lineNumberString == null) {
                    return null;
                }
                try {
                    int lineNumber = Integer.parseInt(lineNumberString);
                    return new PhpFilter.MyResult(fileName, lineNumber, matcher.start(2), matcher.end(3));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            catch (ProcessCanceledException e) {
                LOG.warn("Matching took too long for line: " + line);
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/run/filters/XdebugCallStackFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyPatterns";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

