/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitFilter
implements Filter {
    private static final Logger LOG = Logger.getInstance(PhpUnitFilter.class);
    private static final int MAX_LINE_LENGTH = 1024;
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    private static final String DISK_PATTERN = "\\p{Alpha}:";
    private static final String FILENAME_PATTERN = "[^<>:\\?/\\\\]+";
    public static final String EXTENSION_PATTERN = "\\.[^<>\"':/\\?\\\\\\(\\)]+";
    private static final String PATTERN = "(?:/|\\\\)[^<>:]*[^<>:\\?/\\\\]+(?:\\.[^<>\"':/\\?\\\\\\(\\)]+)";
    private static final String WHOLE_FILENAME_PATTERN = "(?:\\p{Alpha}:)?(?:/|\\\\)[^<>:]*[^<>:\\?/\\\\]+(?:\\.[^<>\"':/\\?\\\\\\(\\)]+)";
    private static final String LINE_NUM_PATTERN = ":?((\\d+)|\\((\\d+)\\))";
    private static final Pattern PHPUNIT_PATTERN_ERROR = Pattern.compile("^\\s*at\\s(((?:\\p{Alpha}:)?(?:/|\\\\)[^<>:]*[^<>:\\?/\\\\]+(?:\\.[^<>\"':/\\?\\\\\\(\\)]+)):(:?((\\d+)|\\((\\d+)\\))))[^\n]*\n");
    private static final Pattern PHP_REGULAR_PATTERN_ERROR = Pattern.compile("^\\s*[#]:?((\\d+)|\\((\\d+)\\))\\s*(((?:\\p{Alpha}:)?(?:/|\\\\)[^<>:]*[^<>:\\?/\\\\]+(?:\\.[^<>\"':/\\?\\\\\\(\\)]+))[(](:?((\\d+)|\\((\\d+)\\)))[)])[^\n]*\n");
    private static final Pattern PHP_UNIT_FILENAME_URL_LINE_NUM = Pattern.compile("[\\W+](((?:\\p{Alpha}:)?(?:/|\\\\)[^<>:]*[^<>:\\?/\\\\]+(?:\\.[^<>\"':/\\?\\\\\\(\\)]+))(:?((\\d+)|\\((\\d+)\\))|$))");
    private static final List<Pattern> PATTERNS_LIST = new ArrayList<Pattern>();
    private static final int[] fileNameGroups = new int[]{2, 5, 2, 2};
    private static final int[] referenceGroups = new int[]{2, 4, 2, 2};
    private static final int[] lineNumberGroups = new int[]{3, 6, 4};
    @NotNull
    private final Project myProject;
    @NotNull
    private final PhpPathMapper myPathMapper;
    private String filteredFileName;
    private int filteredLineNumber;

    public PhpUnitFilter(@NotNull Project project) {
        if (project == null) {
            PhpUnitFilter.$$$reportNull$$$0(0);
        }
        this(project, PhpPathMapper.createDefaultMapper());
    }

    @NonInjectable
    public PhpUnitFilter(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            PhpUnitFilter.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            PhpUnitFilter.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myPathMapper = pathMapper;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path mapper: " + pathMapper);
        }
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        int lineNumber;
        if (line == null) {
            PhpUnitFilter.$$$reportNull$$$0(3);
        }
        if (line.length() > 1024) {
            return null;
        }
        Matcher m = null;
        boolean wasAppropriatePatternFound = false;
        int index = 0;
        for (Pattern p : PATTERNS_LIST) {
            try {
                m = p.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
                if (m.find()) {
                    wasAppropriatePatternFound = true;
                    break;
                }
                ++index;
            }
            catch (ProcessCanceledException e) {
                LOG.warn("Matching took too long for line: " + line);
                return null;
            }
        }
        if (!wasAppropriatePatternFound) {
            return null;
        }
        int numberOfReferenceGroup = referenceGroups[index];
        String fileName = m.group(fileNameGroups[index]);
        if (fileName.startsWith("//") || fileName.startsWith("\\\\")) {
            return null;
        }
        fileName = fileName.replace("\n", "");
        String lineNumberString = PhpUnitFilter.tryGetLineNumberString(m, lineNumberGroups[index]);
        if (lineNumberString != null && StringUtil.containsAnyChar((String)lineNumberString, (String)"()")) {
            lineNumberString = PhpUnitFilter.tryGetLineNumberString(m, 6);
        }
        fileName = fileName.trim();
        try {
            lineNumber = StringUtil.isEmpty((String)lineNumberString) ? 0 : Integer.parseInt(lineNumberString);
        }
        catch (NumberFormatException e) {
            return null;
        }
        this.filteredFileName = fileName;
        this.filteredLineNumber = lineNumber;
        fileName = this.getPathMapper(this.myProject).getLocalPath(fileName);
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.isFile()) {
            return null;
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            return null;
        }
        int textStartOffset = entireLength - line.length();
        int highlightStartOffset = textStartOffset + m.start(numberOfReferenceGroup);
        int highlightEndOffset = textStartOffset + m.end(numberOfReferenceGroup);
        OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(this.myProject, vFile, Math.max(lineNumber - 1, 0));
        TextAttributes attributes = HYPERLINK_ATTRIBUTES.clone();
        if (!ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(vFile)) {
            Color color = UIUtil.getInactiveTextColor();
            attributes.setForegroundColor(color);
            attributes.setEffectColor(color);
        }
        return new Filter.Result(highlightStartOffset, highlightEndOffset, (HyperlinkInfo)info, attributes);
    }

    @NotNull
    protected PhpPathMapper getPathMapper(@NotNull Project project) {
        if (project == null) {
            PhpUnitFilter.$$$reportNull$$$0(4);
        }
        PhpPathMapper phpPathMapper = this.myPathMapper;
        if (phpPathMapper == null) {
            PhpUnitFilter.$$$reportNull$$$0(5);
        }
        return phpPathMapper;
    }

    @Nullable
    private static String tryGetLineNumberString(Matcher m, int group) {
        try {
            return m.group(group);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int getFilteredLineNumber() {
        return this.filteredLineNumber;
    }

    public String getFilteredFileName() {
        return this.filteredFileName;
    }

    @NotNull
    public static String getTrace(@NotNull String line) {
        List stringList;
        if (line == null) {
            PhpUnitFilter.$$$reportNull$$$0(6);
        }
        if ((stringList = StringUtil.split((String)line, (String)"##traceline##")).size() <= 1) {
            String string = line;
            if (string == null) {
                PhpUnitFilter.$$$reportNull$$$0(7);
            }
            return string;
        }
        Iterator iterator = stringList.iterator();
        StringBuilder result = new StringBuilder();
        result.append((String)iterator.next());
        while (iterator.hasNext()) {
            String traceLine = (String)iterator.next();
            if (!iterator.hasNext()) {
                result.append(traceLine);
                break;
            }
            List lineTokens = StringUtil.split((String)traceLine, (String)"##");
            if (lineTokens.size() != 4) {
                if (lineTokens.size() <= 0) continue;
                result.append("\tat ").append((String)lineTokens.get(0)).append("|n");
                continue;
            }
            String method = (String)lineTokens.get(0);
            String path = (String)lineTokens.get(1);
            String lineNumber = (String)lineTokens.get(2);
            StringBuilder fileNameBuilder = new StringBuilder();
            fileNameBuilder.append(path).append(":").append(lineNumber).append(" ");
            fileNameBuilder.append(method).append("()");
            result.append("\tat ").append((CharSequence)fileNameBuilder).append("|n");
        }
        String string = result.toString();
        if (string == null) {
            PhpUnitFilter.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String pretify(@NotNull String line) {
        if (line == null) {
            PhpUnitFilter.$$$reportNull$$$0(9);
        }
        if (line.startsWith("##teamcity[testFailed") && line.contains("details")) {
            return PhpUnitFilter.getTrace(line);
        }
        if (line.startsWith("##exception")) {
            Pattern exceptionPattern = Pattern.compile("##exception\\Q[\\Emessage='([^']*)'\\strace='([^']*)'[^]]*\\Q]\\E");
            Matcher m = exceptionPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
            if (m.find()) {
                String message = m.group(1);
                String trace = m.group(2);
                String string = message + "\n" + PhpUnitFilter.getTrace(trace);
                if (string == null) {
                    PhpUnitFilter.$$$reportNull$$$0(10);
                }
                return string;
            }
        } else if (line.startsWith("##error")) {
            Pattern exceptionPattern = Pattern.compile("##error\\Q[\\Etype='([^']*)'\\smessage=#([^#]*)#\\sfile='([^']*)'\\sline='([^']*)'[^]]*\\Q]\\E");
            Matcher m = exceptionPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
            if (m.find()) {
                String type = m.group(1);
                String message = m.group(2);
                String file = m.group(3);
                String lineNumber = m.group(4);
                String string = type + ": " + message + "\n\tat " + file + ":" + lineNumber + "\n";
                if (string == null) {
                    PhpUnitFilter.$$$reportNull$$$0(11);
                }
                return string;
            }
            Pattern pattern = Pattern.compile("##error\\Q[\\Emessage=#([^#]*)#\\Q]\\E");
            Matcher matcher = pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
            if (matcher.find()) {
                String string = matcher.group(1);
                if (string == null) {
                    PhpUnitFilter.$$$reportNull$$$0(12);
                }
                return string;
            }
            return "";
        }
        String string = line;
        if (string == null) {
            PhpUnitFilter.$$$reportNull$$$0(13);
        }
        return string;
    }

    static {
        PATTERNS_LIST.add(PHPUNIT_PATTERN_ERROR);
        PATTERNS_LIST.add(PHP_REGULAR_PATTERN_ERROR);
        PATTERNS_LIST.add(PHP_UNIT_FILENAME_URL_LINE_NUM);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/filters/PhpUnitFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/filters/PhpUnitFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrace";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "pretify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathMapper";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTrace";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "pretify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

