/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.builtInWebServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.run.PhpCommandLineRunConfiguration;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.PhpRunConfigurationSettings;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.builtInWebServer.PhpBuiltInWebServerRunConfigurationEditor;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpBuiltInWebServerConfiguration
extends PhpCommandLineRunConfiguration<Settings> {
    public PhpBuiltInWebServerConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @NotNull
    protected Settings createSettings() {
        Settings settings = new Settings();
        settings.setDocumentRoot(this.getProject().getBasePath());
        Settings settings2 = settings;
        if (settings2 == null) {
            PhpBuiltInWebServerConfiguration.$$$reportNull$$$0(0);
        }
        return settings2;
    }

    @Override
    protected void fixSettingsAfterDeserialization(@NotNull Settings settings) {
        if (settings == null) {
            PhpBuiltInWebServerConfiguration.$$$reportNull$$$0(1);
        }
        settings.setDocumentRoot(PhpConfigurationUtil.deserializePath(settings.getDocumentRoot()));
        settings.setRouterScript(PhpConfigurationUtil.deserializePath(settings.getRouterScript()));
    }

    @Override
    protected void fixSettingsBeforeSerialization(@NotNull Settings settings) {
        if (settings == null) {
            PhpBuiltInWebServerConfiguration.$$$reportNull$$$0(2);
        }
        settings.setDocumentRoot(PhpConfigurationUtil.serializePath(settings.getDocumentRoot()));
        settings.setRouterScript(PhpConfigurationUtil.serializePath(settings.getRouterScript()));
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new PhpBuiltInWebServerRunConfigurationEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        PhpLanguageLevel level;
        String routerScript;
        Settings settings = (Settings)this.getSettings();
        String host = settings.getHost();
        if (StringUtil.isEmptyOrSpaces((String)host)) {
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "host"));
        }
        int port = settings.getPort();
        if (port < 0) {
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "port"));
        }
        String documentRoot = settings.getDocumentRoot();
        if (PhpRunUtil.findDirectory(documentRoot) == null) {
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "document root"));
        }
        if (settings.isUseRouterScript() && PhpRunUtil.findFile(routerScript = settings.getRouterScript()) == null) {
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "router script"));
        }
        Project project = this.getProject();
        PhpRunUtil.checkCommandLineSettings(project, settings.getCommandLineSettings());
        PhpInfo phpInfo = PhpProjectConfigurationFacade.getInstance(project).getPhpInfo();
        if (phpInfo != null && (level = PhpLanguageLevel.parse(phpInfo)) != null && !level.hasFeature(PhpLanguageFeature.BUILT_IN_WEB_SERVER)) {
            throw new RuntimeConfigurationError(PhpLanguageFeature.BUILT_IN_WEB_SERVER.getNotSupportedErrorMessage(), PhpProjectConfigurable.createFix(project));
        }
    }

    @Override
    protected void fillCommandSettings(@NotNull Map<String, String> env, @NotNull PhpCommandSettings command) throws ExecutionException {
        if (env == null) {
            PhpBuiltInWebServerConfiguration.$$$reportNull$$$0(3);
        }
        if (command == null) {
            PhpBuiltInWebServerConfiguration.$$$reportNull$$$0(4);
        }
        Settings settings = (Settings)this.getSettings();
        String documentRoot = settings.getDocumentRoot();
        assert (documentRoot != null);
        String host = settings.getHost();
        assert (host != null);
        command.addOption("-S").addOption(host + ":" + settings.getPort());
        PhpCommandLinePathProcessor pathProcessor = command.getPathProcessor();
        command.addOption("-t").addOption(pathProcessor.process(documentRoot));
        if (settings.isUseRouterScript()) {
            String script = settings.getRouterScript();
            assert (script != null);
            command.setScript(pathProcessor.process(script), false);
        }
        command.importCommandLineSettings(settings.getCommandLineSettings(), command.getWorkingDirectory());
        command.addEnvs(env);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/builtInWebServer/PhpBuiltInWebServerConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/builtInWebServer/PhpBuiltInWebServerConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsAfterDeserialization";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsBeforeSerialization";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Settings
    implements PhpRunConfigurationSettings {
        private String myHost = "localhost";
        private int myPort = 80;
        private String myDocumentRoot;
        private boolean myUseRouterScript = false;
        private String myRouterScript;
        private PhpCommandLineSettings myCommandLineSettings = new PhpCommandLineSettings();

        @Attribute(value="host")
        @Nullable
        public String getHost() {
            return this.myHost;
        }

        public void setHost(@Nullable String host) {
            this.myHost = StringUtil.nullize((String)host);
        }

        @Attribute(value="port")
        public int getPort() {
            return this.myPort;
        }

        public void setPort(int port) {
            this.myPort = port;
        }

        @Attribute(value="document_root")
        @Nullable
        @NlsSafe
        public String getDocumentRoot() {
            return this.myDocumentRoot;
        }

        public void setDocumentRoot(@Nullable String documentRoot) {
            this.myDocumentRoot = StringUtil.nullize((String)documentRoot);
        }

        @Attribute(value="use_router_script")
        public boolean isUseRouterScript() {
            return this.myUseRouterScript;
        }

        public void setUseRouterScript(boolean useRouterScript) {
            this.myUseRouterScript = useRouterScript;
        }

        @Attribute(value="router_script")
        @Nullable
        @NlsSafe
        public String getRouterScript() {
            return this.myRouterScript;
        }

        public void setRouterScript(@Nullable String routerScript) {
            this.myRouterScript = StringUtil.nullize((String)routerScript);
        }

        @Property(surroundWithTag=false)
        @NotNull
        public PhpCommandLineSettings getCommandLineSettings() {
            PhpCommandLineSettings phpCommandLineSettings = this.myCommandLineSettings;
            if (phpCommandLineSettings == null) {
                Settings.$$$reportNull$$$0(0);
            }
            return phpCommandLineSettings;
        }

        public void setCommandLineSettings(@NotNull PhpCommandLineSettings commandLineSettings) {
            if (commandLineSettings == null) {
                Settings.$$$reportNull$$$0(1);
            }
            this.myCommandLineSettings = commandLineSettings;
        }

        @Override
        @Nullable
        public String getWorkingDirectory() {
            return this.myCommandLineSettings.getWorkingDirectory();
        }

        @Override
        @Transient
        public void setWorkingDirectory(@Nullable String workingDirectory) {
            this.myCommandLineSettings.setWorkingDirectory(workingDirectory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/run/builtInWebServer/PhpBuiltInWebServerConfiguration$Settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandLineSettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/run/builtInWebServer/PhpBuiltInWebServerConfiguration$Settings";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setCommandLineSettings";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

