/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.ResourceUtil;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.run.filters.PhpErrorMessageFilter;
import com.jetbrains.php.run.filters.PhpUnitFilter;
import com.jetbrains.php.run.filters.XdebugCallStackFilter;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExecutionUtil {
    private static final Logger LOG = Logger.getInstance(PhpExecutionUtil.class);
    public static final String IDE_HELPER_SCRIPT_PREFIX = "ide-";

    private PhpExecutionUtil() {
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@NotNull Project project, @Nullable PhpSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, @NotNull @NlsContexts.ProgressTitle String title, @Nullable JComponent parent, int timeout) throws ExecutionException {
        if (project == null) {
            PhpExecutionUtil.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PhpExecutionUtil.$$$reportNull$$$0(1);
        }
        if (title == null) {
            PhpExecutionUtil.$$$reportNull$$$0(2);
        }
        if (data instanceof RemoteSdkAdditionalData) {
            ProcessOutput processOutput;
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager == null) {
                throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
            }
            try {
                processOutput = manager.getProcessOutput(project, data, commandLine, title, parent);
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
            if (processOutput == null) {
                PhpExecutionUtil.$$$reportNull$$$0(3);
            }
            return processOutput;
        }
        Ref exception2 = new Ref(null);
        Ref outputRef = new Ref(null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    outputRef.set((Object)processHandler.runProcessWithProgressIndicator(indicator));
                } else {
                    outputRef.set((Object)processHandler.runProcess(timeout));
                }
            }
            catch (ExecutionException e) {
                outputRef.set(null);
                exception2.set((Object)e);
            }
        }, title, true, project, parent);
        if (!exception2.isNull()) {
            throw (ExecutionException)((Object)exception2.get());
        }
        ProcessOutput processOutput = (ProcessOutput)outputRef.get();
        if (processOutput == null) {
            PhpExecutionUtil.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    public static Filter[] getConsoleMessageFilters(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            PhpExecutionUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            PhpExecutionUtil.$$$reportNull$$$0(6);
        }
        return new Filter[]{new PhpErrorMessageFilter(project, pathMapper), new PhpUnitFilter(project, pathMapper), new XdebugCallStackFilter(project, pathMapper)};
    }

    public static void addMessageFilters(@NotNull Project project, @NotNull ConsoleView consoleView, @NotNull PhpPathMapper pathMapper) {
        Filter[] filters;
        if (project == null) {
            PhpExecutionUtil.$$$reportNull$$$0(7);
        }
        if (consoleView == null) {
            PhpExecutionUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            PhpExecutionUtil.$$$reportNull$$$0(9);
        }
        for (Filter filter : filters = PhpExecutionUtil.getConsoleMessageFilters(project, pathMapper)) {
            consoleView.addMessageFilter(filter);
        }
    }

    public static String loadHelperScriptAndGetText(@NotNull Project project, @NotNull String scriptName, @Nullable PhpCommandSettings command, @NotNull Class<?> resourceHolder) throws ExecutionException {
        if (project == null) {
            PhpExecutionUtil.$$$reportNull$$$0(10);
        }
        if (scriptName == null) {
            PhpExecutionUtil.$$$reportNull$$$0(11);
        }
        if (resourceHolder == null) {
            PhpExecutionUtil.$$$reportNull$$$0(12);
        }
        if (command != null && command.isRemote()) {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager == null) {
                throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
            }
            try {
                PhpSdkAdditionalData data = command.getAdditionalData();
                assert (data != null);
                return PhpSdkHelpersManager.getHelpersManager(data).getHelperScript(project, scriptName, null, resourceHolder);
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        try {
            String scriptText = ResourceUtil.loadText((InputStream)resourceHolder.getClassLoader().getResourceAsStream("scripts/" + scriptName));
            return PhpExecutionUtil.getScriptFile(PhpExecutionUtil.getHelperScriptFileName(scriptName), scriptText).getPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static VirtualFile getScriptFile(@NotNull String scriptFileName, @NotNull String scriptText) throws ExecutionException {
        if (scriptFileName == null) {
            PhpExecutionUtil.$$$reportNull$$$0(13);
        }
        if (scriptText == null) {
            PhpExecutionUtil.$$$reportNull$$$0(14);
        }
        Ref error = new Ref();
        Ref scriptVirtualFile = new Ref();
        Runnable runnable = () -> {
            VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.getTempDirectory());
            LOG.assertTrue(tempDir != null);
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    VirtualFile file = tempDir.findOrCreateChildData(PhpExecutionUtil.class, scriptFileName);
                    if (file == null) {
                        throw new IOException("Can't create file " + scriptFileName);
                    }
                    VfsUtil.saveText((VirtualFile)file, (String)scriptText);
                    scriptVirtualFile.set((Object)file);
                }
                catch (IOException e) {
                    error.set((Object)e);
                }
            });
        };
        ApplicationManager.getApplication().invokeAndWait(runnable);
        if (!error.isNull()) {
            throw new ExecutionException(((IOException)error.get()).getMessage());
        }
        VirtualFile file = (VirtualFile)scriptVirtualFile.get();
        LOG.assertTrue(file != null);
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            PhpExecutionUtil.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    public static String getHelperScriptText(@NotNull String helperScriptName, @NotNull Class<?> resourceHolder) {
        if (helperScriptName == null) {
            PhpExecutionUtil.$$$reportNull$$$0(16);
        }
        if (resourceHolder == null) {
            PhpExecutionUtil.$$$reportNull$$$0(17);
        }
        try {
            return ResourceUtil.loadText((InputStream)Objects.requireNonNull(resourceHolder.getClassLoader().getResourceAsStream("scripts/" + helperScriptName)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static VirtualFile getHelperScriptFile(@NotNull String helperScriptName) throws ExecutionException {
        if (helperScriptName == null) {
            PhpExecutionUtil.$$$reportNull$$$0(18);
        }
        return PhpExecutionUtil.getHelperScriptFile(helperScriptName, true, PhpExecutionUtil.class);
    }

    @NotNull
    public static VirtualFile getHelperScriptFile(@NotNull String helperScriptName, boolean withPrefix, @NotNull Class<?> resourceHolder) throws ExecutionException {
        String scriptsPath;
        if (helperScriptName == null) {
            PhpExecutionUtil.$$$reportNull$$$0(19);
        }
        if (resourceHolder == null) {
            PhpExecutionUtil.$$$reportNull$$$0(20);
        }
        if ((scriptsPath = System.getProperty("php.scripts.path")) != null) {
            String absoluteScriptsPath = new File(scriptsPath).getAbsolutePath();
            VirtualFile scriptsDirectory = LocalFileSystem.getInstance().findFileByPath(absoluteScriptsPath);
            LOG.assertTrue(scriptsDirectory != null);
            VirtualFile phpunit = scriptsDirectory.findChild(helperScriptName);
            if (phpunit != null) {
                VirtualFile virtualFile = phpunit;
                if (virtualFile == null) {
                    PhpExecutionUtil.$$$reportNull$$$0(21);
                }
                return virtualFile;
            }
        }
        String helperScriptText = PhpExecutionUtil.getHelperScriptText(helperScriptName, resourceHolder);
        return PhpExecutionUtil.getScriptFile(PhpExecutionUtil.getHelperScriptFileName(helperScriptName, withPrefix), helperScriptText);
    }

    @NotNull
    public static String getHelperScriptFileName(@NotNull String helperScriptName) {
        if (helperScriptName == null) {
            PhpExecutionUtil.$$$reportNull$$$0(22);
        }
        return PhpExecutionUtil.getHelperScriptFileName(helperScriptName, true);
    }

    @NotNull
    public static String getHelperScriptFileName(@NotNull String helperScriptName, boolean withPrefix) {
        if (helperScriptName == null) {
            PhpExecutionUtil.$$$reportNull$$$0(23);
        }
        String string = (withPrefix ? IDE_HELPER_SCRIPT_PREFIX : "") + helperScriptName;
        if (string == null) {
            PhpExecutionUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getHelperScriptFilePath(@NotNull String helperScriptName) {
        if (helperScriptName == null) {
            PhpExecutionUtil.$$$reportNull$$$0(25);
        }
        String string = FileUtil.getTempDirectory() + File.separator + PhpExecutionUtil.getHelperScriptFileName(helperScriptName);
        if (string == null) {
            PhpExecutionUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 21: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 21: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/PhpExecutionUtil";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceHolder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptText";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperScriptName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/PhpExecutionUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperScriptFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperScriptFileName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperScriptFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 21: 
            case 24: 
            case 26: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleMessageFilters";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilters";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadHelperScriptAndGetText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHelperScriptText";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getHelperScriptFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getHelperScriptFileName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getHelperScriptFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 21: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

