/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class PhpDebugRunner<T extends PhpRunConfiguration<?>>
implements ProgramRunner<RunnerSettings> {
    private static final int TIMEOUT_SEC = 2;
    private final Class<T> myRunConfigurationClass;

    protected PhpDebugRunner(@NotNull Class<T> runConfigurationClass) {
        if (runConfigurationClass == null) {
            PhpDebugRunner.$$$reportNull$$$0(0);
        }
        this.myRunConfigurationClass = runConfigurationClass;
    }

    protected static void onSessionStart(final @NotNull XDebugSession session, final PhpIncomingDebugConnectionServer debugServer, final String sessionId, final PhpDebugConnectionManager connectionsManager, final Project project, final PhpInterpreter interpreter, final ProcessHandler processHandler) {
        if (session == null) {
            PhpDebugRunner.$$$reportNull$$$0(1);
        }
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                debugServer.unregisterSessionHandler(sessionId);
                connectionsManager.checkTouchedCli(project, interpreter.getName());
                if (!processHandler.isProcessTerminated() && !processHandler.isProcessTerminating()) {
                    JobScheduler.getScheduler().schedule(() -> {
                        if (!processHandler.isProcessTerminated() && !processHandler.isProcessTerminating()) {
                            processHandler.destroyProcess();
                        }
                    }, 2L, TimeUnit.SECONDS);
                }
            }
        });
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!session.isStopped()) {
                    session.stop();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/run/PhpDebugRunner$2", "processTerminated"));
            }
        });
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PhpDebugRunner.$$$reportNull$$$0(2);
        }
        if (profile == null) {
            PhpDebugRunner.$$$reportNull$$$0(3);
        }
        return "Debug".equals(executorId) && this.myRunConfigurationClass.isInstance(profile);
    }

    public final void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (environment == null) {
            PhpDebugRunner.$$$reportNull$$$0(4);
        }
        ExecutionManager.getInstance((Project)environment.getProject()).startRunProfile(environment, state -> this.doExecute((RunProfileState)state, environment));
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            PhpDebugRunner.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            PhpDebugRunner.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.doExecute((PhpRunConfiguration)environment.getRunProfile(), state, environment);
    }

    protected abstract RunContentDescriptor doExecute(@NotNull T var1, @NotNull RunProfileState var2, @NotNull ExecutionEnvironment var3) throws ExecutionException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/run/PhpDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onSessionStart";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

