/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.roots.ui.PhpNamespaceComboBox;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPsrNamespacePanel
extends JPanel
implements Disposable {
    private final Alarm myAlarm;
    private final String myInitialNamespace;
    protected JComponent myNamespacePanel;
    protected JComponent myDirectoryPanel;
    protected PhpNamespaceComboBox myNamespaceField;
    protected PhpPsrDirectoryComboBox myDirectoryField;
    private DocumentListener myTargetDirectoryListener;
    private boolean myDisposed;

    public PhpPsrNamespacePanel(@NotNull Project project, @NotNull String namespace, @NotNull PsiFile file) {
        if (project == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(2);
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)2);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                PhpPsrNamespacePanel.this.myAlarm.cancelAllRequests();
                PhpPsrNamespacePanel.this.myDisposed = true;
            }
        });
        this.myInitialNamespace = StringUtil.trimEnd((String)PhpLangUtil.toPresentableFQN(namespace), (String)"\\");
        this.myNamespacePanel = this.createNamespacePanel(project, this.myInitialNamespace);
        this.add((Component)this.myNamespacePanel, gbConstraints);
        ++gbConstraints.gridy;
        this.myDirectoryPanel = this.createDirectoryPanel(project, file);
        this.add((Component)this.myDirectoryPanel, gbConstraints);
        this.customizePanel();
    }

    @NotNull
    @Nls
    public String getNamespaceLabelText() {
        String string = PhpBundle.message("refactoring.common.ui.target.namespace.label", new Object[0]);
        if (string == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PhpNamespaceComboBox getNamespaceField() {
        return this.myNamespaceField;
    }

    public void customizePanel() {
    }

    @NotNull
    private JComponent createNamespacePanel(@NotNull Project project, @NotNull String namespace) {
        if (project == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(5);
        }
        this.myNamespaceField = new PhpNamespaceComboBox(project, namespace, this);
        this.myNamespaceField.setEditable(true);
        JPanel subPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(this.getNamespaceLabelText());
        label.setLabelFor((Component)((Object)this.myNamespaceField));
        subPanel.add((Component)label, "North");
        subPanel.add((Component)((Object)this.myNamespaceField), "Center");
        JBLabel editKeyLabel = new JBLabel(PhpBundle.message("0.completion.shortcut", "namespace", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        editKeyLabel.setComponentStyle(UIUtil.ComponentStyle.MINI);
        subPanel.add((Component)editKeyLabel, "South");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)subPanel, "Center");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    private JComponent createDirectoryPanel(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(7);
        }
        if (file == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(8);
        }
        PsiDirectory directory = file.getContainingDirectory();
        assert (directory != null);
        this.myDirectoryField = new PhpPsrDirectoryComboBox(project);
        this.myDirectoryField.init(directory.getVirtualFile(), this.myInitialNamespace);
        this.myDirectoryField.updateDirectories(this.getNamespaceName());
        this.myTargetDirectoryListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpPsrNamespacePanel.this.addUpdateRequest(() -> PhpPsrNamespacePanel.this.myDirectoryField.updateDirectories(PhpPsrNamespacePanel.this.getNamespaceName()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/roots/ui/PhpPsrNamespacePanel$2", "documentChanged"));
            }
        };
        this.myNamespaceField.getEditorTextField().addDocumentListener(this.myTargetDirectoryListener);
        JPanel subPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(PhpBundle.message("refactoring.common.ui.target.directory.label", new Object[0]));
        label.setLabelFor((Component)((Object)this.myDirectoryField));
        subPanel.add((Component)label, "North");
        subPanel.add((Component)((Object)this.myDirectoryField), "Center");
        JBLabel completionLabel = new JBLabel(PhpBundle.message("refactoring.common.ui.target.directory.edit", new Object[0]), UIUtil.ComponentStyle.MINI);
        subPanel.add((Component)completionLabel, "South");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)subPanel, "Center");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    private void addUpdateRequest(@NotNull Runnable runnable) {
        if (runnable == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(10);
        }
        SwingUtilities.invokeLater(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(runnable, 100);
        });
    }

    @NotNull
    public String getNamespaceName() {
        String string = PhpLangUtil.toName(this.myNamespaceField.getSelectedNamespace());
        if (string == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getSelectedDirectory() {
        String string = this.myDirectoryField.getSelectedPath();
        if (string == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(12);
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myNamespaceField.getEditor().getEditorComponent();
    }

    public void dispose() {
        if (this.myTargetDirectoryListener != null) {
            this.myNamespaceField.getEditorTextField().removeDocumentListener(this.myTargetDirectoryListener);
        }
        this.myNamespaceField.removeDocumentListeners();
    }

    @Nullable
    public ValidationInfo getValidationInfo() {
        String namespaceName = this.getNamespaceName();
        if (StringUtil.isNotEmpty((String)namespaceName) && !PhpNameUtil.isValidNamespaceFullName(namespaceName)) {
            String message = PhpBundle.message("refactoring.common.validation.namespace.name", namespaceName);
            return new ValidationInfo(message, (JComponent)((Object)this.getNamespaceField()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/ui/PhpPsrNamespacePanel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/ui/PhpPsrNamespacePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceLabelText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespacePanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNamespacePanel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryPanel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

