/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.roots.PhpNamespaceProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNamespaceByPsrProvider
implements PhpNamespaceProvider {
    public static final PhpNamespaceProvider INSTANCE = new PhpNamespaceByPsrProvider();

    private PhpNamespaceByPsrProvider() {
    }

    @Override
    public List<String> suggestNamespaces(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(0);
        }
        Project project = directory.getProject();
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        SmartList namespaces = new SmartList();
        for (Module module : modules) {
            ContentEntry[] contentEntries;
            for (ContentEntry entry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                SourceFolder[] sourceFolders;
                for (SourceFolder folder : sourceFolders = entry.getSourceFolders()) {
                    String namespace = PhpNamespaceByPsrProvider.suggestNamespace(folder, directory.getVirtualFile().getPath());
                    if (namespace == null) continue;
                    namespaces.add(namespace);
                }
            }
        }
        ContainerUtil.sort((List)namespaces);
        return namespaces;
    }

    @Nullable
    private static String suggestNamespace(@NotNull SourceFolder folder, @NotNull String directory) {
        VirtualFile file;
        if (folder == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(2);
        }
        if ((file = folder.getFile()) == null || !FileUtil.startsWith((String)directory, (String)file.getPath())) {
            return null;
        }
        String directoryRelative = PhpNamespaceByPsrProvider.getRelativeDirectory(file, directory);
        if (directoryRelative == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        String prefix = PhpNamespaceByPsrProvider.getFolderPrefix(folder);
        if (StringUtil.isNotEmpty((String)prefix)) {
            path.append(prefix);
            if (StringUtil.isNotEmpty((String)directoryRelative)) {
                path.append("\\");
            }
        }
        path.append(StringUtil.replace((String)directoryRelative, (String)"/", (String)"\\"));
        return path.toString();
    }

    @NotNull
    protected static String getFolderPrefix(@NotNull SourceFolder folder) {
        if (folder == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(3);
        }
        String prefix = StringUtil.replace((String)folder.getPackagePrefix(), (String)"/", (String)"\\");
        String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)prefix, (String)"\\"), (String)"\\");
        if (string == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static String getRelativeDirectory(@NotNull VirtualFile file, @NotNull String directory) {
        String directoryRelative;
        if (file == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            PhpNamespaceByPsrProvider.$$$reportNull$$$0(6);
        }
        if ((directoryRelative = FileUtil.getRelativePath((String)file.getPath(), (String)directory, (char)'/')) == null || directoryRelative.startsWith("..")) {
            return null;
        }
        return directoryRelative.equals(".") ? "" : directoryRelative;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/PhpNamespaceByPsrProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/PhpNamespaceByPsrProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamespaces";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamespace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFolderPrefix";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

