/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient.guzzle.extractors;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestObligatoryParameters;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestOptions;
import com.jetbrains.php.restClient.guzzle.RestClientRequestBuilder;
import com.jetbrains.php.restClient.guzzle.extractors.GuzzleRequestExtractor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.http.client.utils.URIUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GuzzleBaseRequestExtractor
implements GuzzleRequestExtractor {
    private static final String GUZZLE_HTTP_CLIENT_CONSTRUCTOR_FQN = "\\GuzzleHttp\\Client.__construct";
    private static final Set<String> HTTP_METHODS = ContainerUtil.set((Object[])new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "CONNECT", "PATCH", "OPTIONS", "TRACE"});

    GuzzleBaseRequestExtractor() {
    }

    @Override
    @Nullable
    public RestClientRequest extractRequest(@NotNull MethodReference methodReference) {
        GuzzleRequestObligatoryParameters obligatoryParameters;
        if (methodReference == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(0);
        }
        if ((obligatoryParameters = this.extractObligatoryParameters(methodReference)) == null) {
            return null;
        }
        return RestClientRequestBuilder.build(obligatoryParameters, this.getRequestOptions(methodReference), GuzzleBaseRequestExtractor.extractRequestOptions(GuzzleBaseRequestExtractor.getClientOptionExpression(methodReference.getClassReference())));
    }

    @Nullable
    abstract GuzzleRequestOptions getRequestOptions(@NotNull MethodReference var1);

    @Nullable
    private static PsiElement getClientOptionExpression(@Nullable PhpExpression clientReference) {
        NewExpression initialisationExpression = GuzzleBaseRequestExtractor.findInitialisationExpression((PsiElement)clientReference, GUZZLE_HTTP_CLIENT_CONSTRUCTOR_FQN);
        if (initialisationExpression == null) {
            return null;
        }
        return initialisationExpression.getParameter(0);
    }

    @Nullable
    protected static String extractHttpMethod(@Nullable PsiElement expression) {
        String httpMethod = GuzzleBaseRequestExtractor.getContent(expression);
        if (!HTTP_METHODS.contains(StringUtil.toUpperCase((String)httpMethod))) {
            return null;
        }
        return httpMethod;
    }

    @Nullable
    protected static URL extractUrl(@Nullable PsiElement relativeUriExpression, @Nullable PhpExpression clientReference, @Nullable PsiElement options) {
        URI relativeUri = GuzzleBaseRequestExtractor.extractRelativeUri(relativeUriExpression);
        if (relativeUri == null) {
            return null;
        }
        if (relativeUri.getScheme() != null) {
            return GuzzleBaseRequestExtractor.toUrl(relativeUri);
        }
        URI baseUri = GuzzleBaseRequestExtractor.toUri(GuzzleBaseRequestExtractor.extractBaseUri(options, clientReference));
        if (baseUri == null) {
            return null;
        }
        URI uri = relativeUri.toString().isEmpty() ? baseUri : URIUtils.resolve((URI)baseUri, (URI)relativeUri);
        return GuzzleBaseRequestExtractor.toUrl(uri);
    }

    @Nullable
    private static URI extractRelativeUri(@Nullable PsiElement relativeUrlExpression) {
        if (relativeUrlExpression == null) {
            return GuzzleBaseRequestExtractor.toUri("");
        }
        return GuzzleBaseRequestExtractor.toUri(GuzzleBaseRequestExtractor.getContent(relativeUrlExpression));
    }

    @Nullable
    private static String extractBaseUri(@Nullable PsiElement requestOptions, @Nullable PhpExpression clientReference) {
        String baseUri = GuzzleBaseRequestExtractor.extractBaseUriFromOptions(requestOptions);
        if (baseUri != null) {
            return baseUri;
        }
        PsiElement optionExpression = GuzzleBaseRequestExtractor.getClientOptionExpression(clientReference);
        if (optionExpression != null) {
            return GuzzleBaseRequestExtractor.extractBaseUriFromOptions(optionExpression);
        }
        return null;
    }

    @Nullable
    protected static NewExpression findInitialisationExpression(@Nullable PsiElement element, @NotNull String fqn) {
        if (fqn == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(1);
        }
        NewExpression newExpression = null;
        PsiElement reference = PhpPsiUtil.unparenthesize(element);
        if (reference instanceof Variable) {
            newExpression = GuzzleBaseRequestExtractor.findVariableInitialisation((Variable)reference);
        } else if (reference instanceof NewExpression) {
            newExpression = (NewExpression)reference;
        }
        if (GuzzleBaseRequestExtractor.matches(newExpression, fqn)) {
            return newExpression;
        }
        return null;
    }

    @Nullable
    private static NewExpression findVariableInitialisation(@NotNull Variable variable) {
        if (variable == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(2);
        }
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations((PsiElement)variable, false, variable.getName());
        for (PhpNamedElement phpNamedElement : declarations) {
            NewExpression newExpression;
            AssignmentExpression assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)phpNamedElement.getParent(), AssignmentExpression.class);
            if (assignmentExpression == null || assignmentExpression.getVariable() != phpNamedElement || (newExpression = (NewExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize((PsiElement)assignmentExpression.getValue()), NewExpression.class)) == null) continue;
            return newExpression;
        }
        return null;
    }

    private static boolean matches(@Nullable NewExpression newExpression, @NotNull String fqn) {
        ResolveResult[] results;
        if (fqn == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(3);
        }
        if (newExpression == null) {
            return false;
        }
        ClassReference classReference = newExpression.getClassReference();
        if (classReference == null) {
            return false;
        }
        for (ResolveResult result : results = classReference.multiResolve(false)) {
            PhpNamedElement namedElement = (PhpNamedElement)ObjectUtils.tryCast((Object)result.getElement(), PhpNamedElement.class);
            if (namedElement == null || !StringUtil.equalsIgnoreCase((CharSequence)fqn, (CharSequence)namedElement.getFQN())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String extractBaseUriFromOptions(@Nullable PsiElement options) {
        if (options == null) {
            return null;
        }
        ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize(options), ArrayCreationExpression.class);
        if (arrayCreationExpression == null) {
            return null;
        }
        for (ArrayHashElement element : arrayCreationExpression.getHashElements()) {
            String key = GuzzleBaseRequestExtractor.getContent((PsiElement)element.getKey());
            if (!"base_uri".equals(key)) continue;
            return GuzzleBaseRequestExtractor.getContent((PsiElement)element.getValue());
        }
        return null;
    }

    @Nullable
    protected static GuzzleRequestOptions extractRequestOptions(@Nullable PsiElement options) {
        if (options == null) {
            return null;
        }
        ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize(options), ArrayCreationExpression.class);
        if (arrayCreationExpression == null) {
            return null;
        }
        GuzzleRequestOptions.AuthOptions authOptions = null;
        GuzzleRequestOptions.HeadersOptions headers = GuzzleRequestOptions.HeadersOptions.EMPTY;
        List<Pair.NonNull<String, String>> query = Collections.emptyList();
        String body = null;
        String jsonBody = null;
        for (ArrayHashElement element : arrayCreationExpression.getHashElements()) {
            String key = GuzzleBaseRequestExtractor.getContent((PsiElement)element.getKey());
            PhpPsiElement valueElement = element.getValue();
            if (key == null || valueElement == null) continue;
            switch (key) {
                case "auth": {
                    authOptions = GuzzleBaseRequestExtractor.extractAuthOptions((PsiElement)valueElement);
                    break;
                }
                case "headers": {
                    headers = GuzzleBaseRequestExtractor.extractHeaders((PsiElement)valueElement);
                    break;
                }
                case "query": {
                    query = GuzzleBaseRequestExtractor.extractQuery((PsiElement)valueElement);
                    break;
                }
                case "body": {
                    body = GuzzleBaseRequestExtractor.getContent((PsiElement)valueElement);
                    break;
                }
                case "json": {
                    jsonBody = GuzzleBaseRequestExtractor.extractJsonBody((PsiElement)valueElement);
                }
            }
        }
        return new GuzzleRequestOptions(authOptions, headers, query, body, jsonBody);
    }

    @Nullable
    private static String extractJsonBody(@NotNull PsiElement element) {
        JsonElement jsonElement;
        PsiElement unwrapped;
        if (element == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(4);
        }
        if ((unwrapped = PhpPsiUtil.unparenthesize(element)) instanceof StringLiteralExpression) {
            return GuzzleBaseRequestExtractor.getContent(element);
        }
        if (unwrapped instanceof ArrayCreationExpression && (jsonElement = GuzzleBaseRequestExtractor.buildJsonElement(unwrapped)) != null) {
            return new GsonBuilder().setPrettyPrinting().create().toJson(jsonElement);
        }
        return null;
    }

    @Nullable
    private static JsonElement buildJsonElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement unwrapped = PhpPsiUtil.unparenthesize(element);
        if (unwrapped instanceof ArrayCreationExpression) {
            JsonObject root = new JsonObject();
            for (ArrayHashElement arrayHashElement : ((ArrayCreationExpression)unwrapped).getHashElements()) {
                String key = GuzzleBaseRequestExtractor.getContent((PsiElement)arrayHashElement.getKey());
                if (key == null) {
                    return null;
                }
                JsonElement value = GuzzleBaseRequestExtractor.buildJsonElement((PsiElement)arrayHashElement.getValue());
                if (value == null) {
                    return null;
                }
                root.add(key, value);
            }
            return root;
        }
        return GuzzleBaseRequestExtractor.buildPrimitiveJsonElement(unwrapped);
    }

    @Nullable
    private static JsonElement buildPrimitiveJsonElement(@NotNull PsiElement unwrapped) {
        if (unwrapped == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(5);
        }
        if (unwrapped instanceof StringLiteralExpression) {
            String content = PhpCodeInsightUtil.toString((StringLiteralExpression)unwrapped);
            if (content != null) {
                return new JsonPrimitive(content);
            }
        } else {
            if (PhpLangUtil.isFalse(unwrapped)) {
                return new JsonPrimitive(Boolean.valueOf(false));
            }
            if (PhpLangUtil.isTrue(unwrapped)) {
                return new JsonPrimitive(Boolean.valueOf(true));
            }
            if (PhpLangUtil.isNull(unwrapped)) {
                return JsonNull.INSTANCE;
            }
            Number number = GuzzleBaseRequestExtractor.tryParseNumber(unwrapped);
            if (number != null) {
                return new JsonPrimitive(number);
            }
        }
        return null;
    }

    @Nullable
    private static Number tryParseNumber(@NotNull PsiElement element) {
        ASTNode elementNode;
        if (element == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(6);
        }
        if ((elementNode = element.getNode()).getElementType() != PhpElementTypes.NUMBER) {
            return null;
        }
        ASTNode childNode = elementNode.getFirstChildNode();
        if (childNode == null) {
            return null;
        }
        IElementType childNodeType = childNode.getElementType();
        if (PhpTokenTypes.DECIMAL_INTEGER.equals(childNodeType)) {
            return GuzzleBaseRequestExtractor.tryParseInteger(childNode);
        }
        if (PhpTokenTypes.FLOAT_LITERAL.equals(childNodeType)) {
            return GuzzleBaseRequestExtractor.tryParseFloat(childNode);
        }
        return null;
    }

    @Nullable
    private static Float tryParseFloat(ASTNode childNode) {
        try {
            return Float.valueOf(Float.parseFloat(PhpPsiUtil.getLiteralText(childNode.getPsi())));
        }
        catch (NumberFormatException exception2) {
            return null;
        }
    }

    @Nullable
    private static Integer tryParseInteger(ASTNode childNode) {
        try {
            return Integer.parseInt(PhpPsiUtil.getLiteralText(childNode.getPsi()));
        }
        catch (NumberFormatException exception2) {
            return null;
        }
    }

    @NotNull
    private static List<Pair.NonNull<String, String>> extractQuery(@NotNull PsiElement element) {
        if (element == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(7);
        }
        ArrayList<Pair.NonNull<String, String>> query = new ArrayList<Pair.NonNull<String, String>>();
        PsiElement unwrapped = PhpPsiUtil.unparenthesize(element);
        if (unwrapped instanceof StringLiteralExpression) {
            String value = PhpCodeInsightUtil.toString((StringLiteralExpression)unwrapped);
            query.addAll(RestClientRequestBuilder.parseQueryString(value));
        } else if (unwrapped instanceof ArrayCreationExpression) {
            for (ArrayHashElement arrayHashElement : ((ArrayCreationExpression)unwrapped).getHashElements()) {
                String value;
                String key = GuzzleBaseRequestExtractor.getContent((PsiElement)arrayHashElement.getKey());
                if (key == null || (value = GuzzleBaseRequestExtractor.getContent((PsiElement)arrayHashElement.getValue())) == null) continue;
                query.add((Pair.NonNull<String, String>)Pair.createNonNull((Object)key, (Object)value));
            }
        }
        ArrayList<Pair.NonNull<String, String>> arrayList = query;
        if (arrayList == null) {
            GuzzleBaseRequestExtractor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    protected static GuzzleRequestOptions.HeadersOptions extractHeaders(@Nullable PsiElement element) {
        if (element == null) {
            GuzzleRequestOptions.HeadersOptions headersOptions = GuzzleRequestOptions.HeadersOptions.EMPTY;
            if (headersOptions == null) {
                GuzzleBaseRequestExtractor.$$$reportNull$$$0(9);
            }
            return headersOptions;
        }
        if (PhpLangUtil.isNull(element)) {
            return new GuzzleRequestOptions.HeadersOptions((MultiMap<String, String>)MultiMap.empty(), true);
        }
        ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize(element), ArrayCreationExpression.class);
        if (arrayCreationExpression == null) {
            GuzzleRequestOptions.HeadersOptions headersOptions = GuzzleRequestOptions.HeadersOptions.EMPTY;
            if (headersOptions == null) {
                GuzzleBaseRequestExtractor.$$$reportNull$$$0(10);
            }
            return headersOptions;
        }
        MultiMap headers = MultiMap.createLinked();
        for (ArrayHashElement arrayHashElement : arrayCreationExpression.getHashElements()) {
            String key = GuzzleBaseRequestExtractor.getContent((PsiElement)arrayHashElement.getKey());
            PsiElement valueElement = PhpPsiUtil.unparenthesize((PsiElement)arrayHashElement.getValue());
            if (key == null || valueElement == null) continue;
            if (valueElement instanceof StringLiteralExpression) {
                String value = PhpCodeInsightUtil.toString((StringLiteralExpression)valueElement);
                if (value == null) continue;
                headers.putValue((Object)key, (Object)value);
                continue;
            }
            if (!(valueElement instanceof ArrayCreationExpression)) continue;
            List arguments = ContainerUtil.map(ArrayCreationExpressionImpl.children((ArrayCreationExpression)valueElement), PhpPsiElement::getFirstPsiChild);
            for (PhpPsiElement argument : arguments) {
                String value = GuzzleBaseRequestExtractor.getContent((PsiElement)argument);
                if (value == null) continue;
                headers.putValue((Object)key, (Object)value);
            }
        }
        return new GuzzleRequestOptions.HeadersOptions((MultiMap<String, String>)headers, false);
    }

    @Nullable
    private static GuzzleRequestOptions.AuthOptions extractAuthOptions(@Nullable PsiElement element) {
        ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize(element), ArrayCreationExpression.class);
        if (arrayCreationExpression == null) {
            return null;
        }
        List arguments = ContainerUtil.map(ArrayCreationExpressionImpl.children(arrayCreationExpression), PhpPsiElement::getFirstPsiChild);
        int argumentsNumber = arguments.size();
        if (argumentsNumber != 2 && argumentsNumber != 3) {
            return null;
        }
        String username = GuzzleBaseRequestExtractor.getContent((PsiElement)arguments.get(0));
        if (username == null) {
            return null;
        }
        String password = GuzzleBaseRequestExtractor.getContent((PsiElement)arguments.get(1));
        if (password == null) {
            return null;
        }
        String scheme = "Basic";
        if (argumentsNumber == 3) {
            scheme = GuzzleBaseRequestExtractor.extractScheme((PsiElement)arguments.get(2));
        }
        if (scheme == null) {
            return null;
        }
        return new GuzzleRequestOptions.AuthOptions(username, password, scheme);
    }

    @Nullable
    protected static String getContent(@Nullable PsiElement psiElement) {
        PsiElement element = PhpPsiUtil.unparenthesize(psiElement);
        if (element == null) {
            return null;
        }
        return PhpCodeInsightUtil.toString(element);
    }

    @Nullable
    private static String extractScheme(@Nullable PsiElement schemeParameter) {
        String schemeArgument = GuzzleBaseRequestExtractor.getContent(schemeParameter);
        if (schemeArgument == null) {
            return null;
        }
        switch (schemeArgument) {
            case "basic": {
                return "Basic";
            }
            case "digest": {
                return "Digest";
            }
            case "ntlm": {
                return "NTLM";
            }
        }
        return null;
    }

    @Nullable
    private static URI toUri(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Nullable
    private static URL toUrl(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unwrapped";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/restClient/guzzle/extractors/GuzzleBaseRequestExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/restClient/guzzle/extractors/GuzzleBaseRequestExtractor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractQuery";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractRequest";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findInitialisationExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findVariableInitialisation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractJsonBody";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildPrimitiveJsonElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryParseNumber";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractQuery";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

