/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient.guzzle;

import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.restClient.guzzle.GuzzleGenerateHttpRequestAction;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestMatchers;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestObligatoryParameters;
import com.jetbrains.php.restClient.guzzle.extractors.GuzzleRequestExtractor;
import icons.PhpIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuzzleRunRequestLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nullable(value="null means disabled")
    @GutterName
    public @Nullable(value="null means disabled") @GutterName String getName() {
        return PhpBundle.message("guzzle.http.request.gutter.name", new Object[0]);
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            GuzzleRunRequestLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            GuzzleRunRequestLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            GuzzleRunRequestLineMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement psiElement : elements) {
            GuzzleRequestLineMarkerInfo lineMarkerInfo;
            if (!PhpPsiUtil.isOfType(psiElement, PhpTokenTypes.IDENTIFIER) || (lineMarkerInfo = GuzzleRunRequestLineMarkerProvider.createLineMarkerInfo(psiElement)) == null) continue;
            result.add(lineMarkerInfo);
        }
    }

    @Nullable
    private static GuzzleRequestLineMarkerInfo createLineMarkerInfo(@NotNull PsiElement element) {
        MethodReference methodReference;
        if (element == null) {
            GuzzleRunRequestLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((methodReference = (MethodReference)ObjectUtils.tryCast((Object)element.getParent(), MethodReference.class)) == null) {
            return null;
        }
        GuzzleRequestExtractor requestExtractor = GuzzleRequestMatchers.findRequestExtractor(methodReference);
        if (requestExtractor == null) {
            return null;
        }
        GuzzleRequestObligatoryParameters parameters = requestExtractor.extractObligatoryParameters(methodReference);
        if (parameters != null) {
            return new GuzzleRequestLineMarkerInfo(element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/restClient/guzzle/GuzzleRunRequestLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineMarkerInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GuzzleRequestLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final AnAction myAction;

        GuzzleRequestLineMarkerInfo(@NotNull PsiElement element) {
            if (element == null) {
                GuzzleRequestLineMarkerInfo.$$$reportNull$$$0(0);
            }
            super(element, element.getTextRange(), PhpIcons.HttpRequestsFiletype, psiElement -> PhpBundle.message("guzzle.open.http.request", new Object[0]), null, GutterIconRenderer.Alignment.CENTER);
            this.myAction = new GuzzleGenerateHttpRequestAction(element);
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return myAction;
                }

                public boolean isNavigateAction() {
                    return true;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/restClient/guzzle/GuzzleRunRequestLineMarkerProvider$GuzzleRequestLineMarkerInfo", "<init>"));
        }
    }
}

