/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient.guzzle;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestMatchers;
import com.jetbrains.php.restClient.guzzle.extractors.GuzzleRequestExtractor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class GuzzleGenerateHttpRequestAction
extends AnAction {
    private static final NotificationGroup GUZZLE_NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Guzzle", (String)PhpBundle.message("guzzle.name", new Object[0]));
    @NotNull
    private final SmartPsiElementPointer<PsiElement> myElement;
    @Nullable
    private String myFileName;

    GuzzleGenerateHttpRequestAction(@NotNull PsiElement element) {
        if (element == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(0);
        }
        this.myElement = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
    }

    @TestOnly
    GuzzleGenerateHttpRequestAction(@NotNull PsiElement element, @NotNull String fileName) {
        if (element == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(2);
        }
        this.myElement = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        this.myFileName = fileName;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(3);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ReadAction.run(() -> {
            PsiElement element = this.myElement.getElement();
            if (element == null) {
                GuzzleGenerateHttpRequestAction.showNotification(project, PhpBundle.message("guzzle.unable.to.extract.request.parameters", new Object[0]));
                return;
            }
            RestClientRequest restClientRequest = GuzzleGenerateHttpRequestAction.extractRequest(element);
            if (restClientRequest == null) {
                GuzzleGenerateHttpRequestAction.showNotification(project, PhpBundle.message("guzzle.unable.to.extract.request.parameters", new Object[0]));
                return;
            }
            String fileName = this.myFileName != null ? this.myFileName : PhpNameUtil.getNameWithoutExtension(element.getContainingFile().getName());
            HttpRequest request = GuzzleGenerateHttpRequestAction.createOrFindHttpRequest(project, fileName, restClientRequest);
            if (request != null) {
                request.navigate(true);
            }
        });
    }

    private static void showNotification(@NotNull Project project, @NotNull @NlsContexts.NotificationContent String message) {
        if (project == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(4);
        }
        if (message == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(5);
        }
        Notifications.Bus.notify((Notification)GUZZLE_NOTIFICATION_GROUP.createNotification(message, NotificationType.ERROR), (Project)project);
    }

    @Nullable
    private static RestClientRequest extractRequest(@NotNull PsiElement element) {
        MethodReference methodReference;
        if (element == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(6);
        }
        if ((methodReference = (MethodReference)ObjectUtils.tryCast((Object)element.getParent(), MethodReference.class)) == null) {
            return null;
        }
        GuzzleRequestExtractor requestExtractor = GuzzleRequestMatchers.findRequestExtractor(methodReference);
        if (requestExtractor == null) {
            return null;
        }
        return requestExtractor.extractRequest(methodReference);
    }

    @Nullable
    private static HttpRequest createOrFindHttpRequest(@NotNull Project project, @NotNull String fileName, @NotNull RestClientRequest restClientRequest) {
        if (project == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(8);
        }
        if (restClientRequest == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(9);
        }
        String scratchFileName = PathUtil.makeFileName((String)fileName, (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
        return (HttpRequest)WriteCommandAction.writeCommandAction((Project)project).withName(PhpBundle.message("guzzle.open.http.request", new Object[0])).withGlobalUndo().withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).shouldRecordActionForActiveDocument(false).compute(() -> {
            VirtualFile file = GuzzleGenerateHttpRequestAction.createOrFindScratchFile(scratchFileName);
            if (file == null) {
                GuzzleGenerateHttpRequestAction.showNotification(project, UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{scratchFileName}));
                return null;
            }
            if (!file.isWritable()) {
                GuzzleGenerateHttpRequestAction.showNotification(project, PhpBundle.message("guzzle.unable.to.add.new.request.to.file", scratchFileName));
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof HttpRequestPsiFile)) {
                GuzzleGenerateHttpRequestAction.showNotification(project, PhpBundle.message("guzzle.invalid.http.request.file", scratchFileName));
                return null;
            }
            HttpRequestBlock[] requestBlocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)psiFile);
            HttpRequest existingRequest = GuzzleGenerateHttpRequestAction.findRequest(project, restClientRequest, requestBlocks);
            if (existingRequest != null) {
                return existingRequest;
            }
            HttpRequest newRequest = GuzzleGenerateHttpRequestAction.addRequestToFile(project, restClientRequest, psiFile, requestBlocks);
            if (newRequest == null) {
                GuzzleGenerateHttpRequestAction.showNotification(project, PhpBundle.message("guzzle.unable.to.add.new.request.to.file", scratchFileName));
                return null;
            }
            return newRequest;
        });
    }

    @Nullable
    private static HttpRequest addRequestToFile(@NotNull Project project, @NotNull RestClientRequest restClientRequest, @NotNull PsiFile psiFile, HttpRequestBlock @NotNull [] requestBlocks) {
        int endOffset;
        HttpRequestBlock block;
        int offset;
        PsiDocumentManager manager;
        Document document;
        if (project == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(10);
        }
        if (restClientRequest == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(11);
        }
        if (psiFile == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(12);
        }
        if (requestBlocks == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(13);
        }
        if ((document = (manager = PsiDocumentManager.getInstance((Project)project)).getDocument(psiFile)) == null) {
            return null;
        }
        if (requestBlocks.length > 0 && (offset = HttpRequestPsiUtils.getNextSeparatorStartOffset((HttpRequestBlock)(block = requestBlocks[requestBlocks.length - 1]))) < 0) {
            int endOffset2 = block.getTextRange().getEndOffset();
            document.insertString(endOffset2, (CharSequence)("\n\n" + HttpRequestPsiConverter.getSeparator() + "\n\n"));
        }
        if ((endOffset = document.getTextLength()) > 0 && !document.getText(new TextRange(endOffset - 1, endOffset)).equals("\n")) {
            document.insertString(endOffset, (CharSequence)"\n\n");
        }
        document.insertString(document.getTextLength(), (CharSequence)HttpRequestPsiConverter.toPsiHttpRequest((RestClientRequest)restClientRequest));
        manager.commitDocument(document);
        HttpRequestBlock[] updatedBlocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)psiFile);
        if (updatedBlocks.length == 0) {
            return null;
        }
        return updatedBlocks[updatedBlocks.length - 1].getRequest();
    }

    @Nullable
    private static VirtualFile createOrFindScratchFile(@NotNull String scratchFileName) {
        if (scratchFileName == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(14);
        }
        try {
            ScratchFileService fileService = ScratchFileService.getInstance();
            VirtualFile file = fileService.findFile((RootType)ScratchRootType.getInstance(), scratchFileName, ScratchFileService.Option.create_if_missing);
            fileService.getScratchesMapping().setMapping(file, (Object)HttpRequestLanguage.INSTANCE);
            return file;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Nullable
    private static HttpRequest findRequest(@NotNull Project project, @NotNull RestClientRequest requestToFind, HttpRequestBlock @NotNull [] requestBlocks) {
        if (project == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(15);
        }
        if (requestToFind == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(16);
        }
        if (requestBlocks == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(17);
        }
        for (HttpRequestBlock block : requestBlocks) {
            HttpRequest request = block.getRequest();
            try {
                RestClientRequest clientRequest = HttpRequestPsiConverter.toRestClientRequest((HttpRequest)request, (HttpRequestVariableSubstitutor)HttpRequestVariableSubstitutor.getDefault((Project)project));
                if (!GuzzleGenerateHttpRequestAction.isEquals(requestToFind, clientRequest)) continue;
                return request;
            }
            catch (HttpRequestValidationException httpRequestValidationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isEquals(@NotNull RestClientRequest requestToFind, @NotNull RestClientRequest clientRequest) {
        if (requestToFind == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(18);
        }
        if (clientRequest == null) {
            GuzzleGenerateHttpRequestAction.$$$reportNull$$$0(19);
        }
        if (!Objects.equals(requestToFind.httpMethod, clientRequest.httpMethod)) {
            return false;
        }
        if (!Objects.equals(requestToFind.getURL(), clientRequest.getURL())) {
            return false;
        }
        if (!Objects.equals(requestToFind.authData, clientRequest.authData)) {
            return false;
        }
        if (!new HashSet(requestToFind.headers).equals(new HashSet(clientRequest.headers))) {
            return false;
        }
        if (!Objects.equals(requestToFind.createQueryString(), clientRequest.createQueryString())) {
            return false;
        }
        return Objects.equals(StringUtil.nullize((String)requestToFind.textToSend), StringUtil.nullize((String)clientRequest.textToSend));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restClientRequest";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestBlocks";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scratchFileName";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestToFind";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientRequest";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/restClient/guzzle/GuzzleGenerateHttpRequestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extractRequest";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrFindHttpRequest";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addRequestToFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrFindScratchFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "findRequest";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isEquals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

