/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.debug.common.PhpIdeDebugProcess;
import com.jetbrains.php.debug.common.PhpRemoteServerDebugStrategy;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.debug.connection.PhpDebugPathExtractor;
import com.jetbrains.php.debug.connection.PhpDebugServerEvaluator;
import com.jetbrains.php.ui.PhpUiUtil;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHttpRequestDebugProcess<S extends PhpDebugConnection>
extends PhpIdeDebugProcess<S> {
    private static final String TROUBLESHOOTING_HELP_ID = "php.debugging.troubleshoot";
    private final String myDebuggerId;
    private final PhpDebugPathExtractor myPathExtractor;

    public PhpHttpRequestDebugProcess(@NotNull XDebugSession session, @NotNull String sessionId, @NotNull PhpDebugConnectionManager<S> debugConnectionsManager, @NotNull PhpDebugDriver<S> driver, @NotNull PhpDebugStrategy debugStrategy, @NotNull PhpDebugPathExtractor pathExtractor, @NotNull String debuggerId) {
        if (session == null) {
            PhpHttpRequestDebugProcess.$$$reportNull$$$0(0);
        }
        if (sessionId == null) {
            PhpHttpRequestDebugProcess.$$$reportNull$$$0(1);
        }
        if (debugConnectionsManager == null) {
            PhpHttpRequestDebugProcess.$$$reportNull$$$0(2);
        }
        if (driver == null) {
            PhpHttpRequestDebugProcess.$$$reportNull$$$0(3);
        }
        if (debugStrategy == null) {
            PhpHttpRequestDebugProcess.$$$reportNull$$$0(4);
        }
        if (pathExtractor == null) {
            PhpHttpRequestDebugProcess.$$$reportNull$$$0(5);
        }
        if (debuggerId == null) {
            PhpHttpRequestDebugProcess.$$$reportNull$$$0(6);
        }
        super(session, sessionId, debugConnectionsManager, driver, debugStrategy, null, false);
        this.myDebuggerId = debuggerId;
        this.myPathExtractor = pathExtractor;
    }

    @Override
    protected void onConnect() {
        this.registerHandlers();
        Object connection = this.getConnection();
        assert (connection != null);
        Project project = this.getSession().getProject();
        PhpDebugServerEvaluator evaluator = new PhpDebugServerEvaluator<S>(project, (PhpDebugConnection)connection, this.myPathExtractor, this.myDebuggerId){

            @Override
            protected void handleConnection(@NotNull S updatedConnection, @NotNull Project project, @Nullable String serverName) {
                if (updatedConnection == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (StringUtil.isNotEmpty((String)serverName)) {
                    PhpRemoteServerDebugStrategy debugStrategy = new PhpRemoteServerDebugStrategy(project, serverName);
                    PhpHttpRequestDebugProcess.this.setStrategy(debugStrategy);
                } else {
                    String title = PhpBundle.message("debug.rest.client.error.cannot.evaluate.server.name.title", new Object[0]);
                    String message = PhpBundle.message("debug.rest.client.error.cannot.evaluate.server.name", new Object[0]);
                    NotificationListener listener = new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                            if (notification2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (event == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                HelpManager.getInstance().invokeHelp(PhpHttpRequestDebugProcess.TROUBLESHOOTING_HELP_ID);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/php/restClient/PhpHttpRequestDebugProcess$1$1";
                            objectArray[2] = "hyperlinkUpdate";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    PhpDebugUtil.showWarningNotification(project, title, PhpUiUtil.surroundWithHtml(message), listener);
                }
                PhpHttpRequestDebugProcess.this.initialize(updatedConnection);
            }

            @Override
            protected void onErrorOccurred(@NotNull @Nls String errorTitle, @NotNull @Nls String errorMessage, @Nullable NotificationListener listener) {
                if (errorTitle == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(3);
                }
                PhpDebugUtil.showWarningNotification(PhpHttpRequestDebugProcess.this.getSession().getProject(), errorTitle, errorMessage);
                PhpHttpRequestDebugProcess.this.getSession().stop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updatedConnection";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorTitle";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/restClient/PhpHttpRequestDebugProcess$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleConnection";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        evaluator.statusChanged(connection, ConnectionStatus.CONNECTED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sessionId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "debugConnectionsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "driver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "debugStrategy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "pathExtractor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "debuggerId";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/restClient/PhpHttpRequestDebugProcess";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

