/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.run.HttpRequestNotifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.util.connection.PhpProgressAwareInitCallback;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHttpRequestDebugInitCallback
extends PhpProgressAwareInitCallback {
    private static final Logger LOG = Logger.getInstance(PhpHttpRequestDebugInitCallback.class);
    private static final int TIMEOUT = 30000;
    private final Semaphore mySemaphore = new Semaphore(1);
    @Nls
    private String myError = null;

    public PhpHttpRequestDebugInitCallback() {
        super(false);
    }

    @Nls
    public void waitForInitialization(@NotNull Project project) {
        if (project == null) {
            PhpHttpRequestDebugInitCallback.$$$reportNull$$$0(0);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initializing debug connection");
            }
            this.mySemaphore.waitFor(30000L);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initialized debug connection: " + StringUtil.notNullize((String)this.myError, (String)"Succeed"));
            }
            if (StringUtil.isNotEmpty((String)this.myError)) {
                this.showErrorMessage(project, this.myError);
            }
        }
        catch (ProcessCanceledException e) {
            this.showErrorMessage(project, PhpBundle.message("xdebug.cloud.cannot.register.cloud.id", new Object[0]));
        }
    }

    protected void showErrorMessage(@NotNull Project project, @NotNull @Nls String message) {
        if (project == null) {
            PhpHttpRequestDebugInitCallback.$$$reportNull$$$0(1);
        }
        if (message == null) {
            PhpHttpRequestDebugInitCallback.$$$reportNull$$$0(2);
        }
        String title = RestClientBundle.message((String)"rest.client.request.execute.notification", (Object[])new Object[0]);
        HttpRequestNotifications.showErrorBalloon((Project)project, (String)title, (String)message);
    }

    @Override
    public void onInit(@Nullable @Nls String error) {
        this.myError = error;
        this.mySemaphore.up();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/restClient/PhpHttpRequestDebugInitCallback";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForInitialization";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

