/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.validation;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpFunctionDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.validation.PhpNameConflictDetector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpFunctionConflictDetectorBase
implements PhpNameConflictDetector {
    @Nullable
    @NlsContexts.DialogMessage
    protected static String validate(@NotNull PhpScopeHolder scopeHolder, @NotNull String newName, final @NotNull Condition<? super PhpFunctionDeclarationInstruction> functionExistCondition) {
        String result;
        if (scopeHolder == null) {
            PhpFunctionConflictDetectorBase.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            PhpFunctionConflictDetectorBase.$$$reportNull$$$0(1);
        }
        if (functionExistCondition == null) {
            PhpFunctionConflictDetectorBase.$$$reportNull$$$0(2);
        }
        if ((result = PhpFunctionConflictDetectorBase.validateFunctionNameIdentifier(newName)) != null) {
            return result;
        }
        final Ref functionExistRef = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)scopeHolder.getControlFlow().getExitPoint(), false, new PhpInstructionProcessor(){

            public boolean processFunctionDeclarationInstruction(PhpFunctionDeclarationInstruction instruction) {
                if (functionExistCondition.value((Object)instruction)) {
                    functionExistRef.set((Object)true);
                    return false;
                }
                return true;
            }
        });
        if (((Boolean)functionExistRef.get()).booleanValue()) {
            return PhpBundle.message("validation.function.already.exists", new Object[0]);
        }
        return null;
    }

    @Nullable
    @NlsContexts.DialogMessage
    private static String validateFunctionNameIdentifier(@NotNull String newName) {
        if (newName == null) {
            PhpFunctionConflictDetectorBase.$$$reportNull$$$0(3);
        }
        if (!PhpNameUtil.isValidFunctionName(newName)) {
            return PhpBundle.message("validation.invalid.identifier", newName);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExistCondition";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/validation/PhpFunctionConflictDetectorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "validateFunctionNameIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

