/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUnwrapper
extends AbstractUnwrapper<Context> {
    public PhpUnwrapper(@Nls String description) {
        super(description);
    }

    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (editor == null) {
            PhpUnwrapper.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpUnwrapper.$$$reportNull$$$0(1);
        }
        List res = super.unwrap(editor, element);
        for (PsiElement e : res) {
            CodeEditUtil.markToReformat((ASTNode)e.getNode(), (boolean)true);
        }
        List list = res;
        if (list == null) {
            PhpUnwrapper.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected Context createContext() {
        return new Context(false);
    }

    protected void doUnwrap(PsiElement element, Context context) throws IncorrectOperationException {
        this.unwrapElement(element, context);
    }

    public void unwrapElement(PsiElement element, Context context) {
        GroupStatement gs = (GroupStatement)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (gs != null) {
            context.extractGroupStatement(this, gs, element);
        } else {
            Statement st = (Statement)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            context.extractSingleStatement(st, element);
        }
        context.delete(element);
    }

    @Nullable
    public IElementType getClosingElementType() {
        return null;
    }

    public boolean isClosingElement(PsiElement element) {
        IElementType closingElementType = this.getClosingElementType();
        if (closingElementType != null) {
            return PhpPsiUtil.isOfType(element, closingElementType);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/unwrap/PhpUnwrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/unwrap/PhpUnwrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Context
    extends AbstractUnwrapper.AbstractContext {
        public Context(boolean effective) {
            this.myIsEffective = effective;
        }

        public void setNotEffective() {
            this.myIsEffective = false;
        }

        public boolean isAcceptableGroupStatement(PhpUnwrapper unwrapper, GroupStatement gs) {
            if (gs == null) {
                return false;
            }
            PsiElement colon = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)gs, true);
            PsiElement closingElementSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)gs, true);
            PsiElement closingElementUncle = PhpPsiUtil.getNextSiblingIgnoreWhitespace(gs.getParent(), true);
            if (colon != null && PhpPsiUtil.isOfType(colon, PhpTokenTypes.opCOLON)) {
                return unwrapper.isClosingElement(closingElementSibling) || unwrapper.isClosingElement(closingElementUncle);
            }
            return false;
        }

        public void extractGroupStatementAlternativeSyntax(PhpUnwrapper unwrapper, GroupStatement gs, PsiElement from) {
            if (this.isAcceptableGroupStatement(unwrapper, gs)) {
                this.extract(gs.getFirstChild(), gs.getLastChild(), from);
            }
        }

        public void extractGroupStatement(PhpUnwrapper unwrapper, GroupStatement gs, PsiElement from) {
            PsiElement child = gs.getFirstChild();
            if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.chLBRACE) && unwrapper.getClosingElementType() != null) {
                this.extractGroupStatementAlternativeSyntax(unwrapper, gs, from);
            } else {
                this.extractGroupStatementBraceSyntax(gs, from);
            }
        }

        public void extractGroupStatementBraceSyntax(GroupStatement gs, PsiElement from) {
            if (gs == null) {
                return;
            }
            PsiElement lbrace = gs.getFirstChild();
            PsiElement rbrace = gs.getLastChild();
            if (lbrace != null && rbrace != null && PhpPsiUtil.isOfType(lbrace, PhpTokenTypes.chLBRACE) && PhpPsiUtil.isOfType(rbrace, PhpTokenTypes.chRBRACE)) {
                this.extract(lbrace.getNextSibling(), rbrace.getPrevSibling(), from);
            }
        }

        public void extractSingleStatement(Statement singleStatement, PsiElement from) {
            this.extract((PsiElement)singleStatement, (PsiElement)singleStatement, from);
        }

        protected boolean isWhiteSpace(PsiElement element) {
            return element instanceof PsiWhiteSpace;
        }

        public List<PsiElement> getElementsToExtract() {
            return this.myElementsToExtract;
        }
    }
}

