/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.unwrap;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.unwrap.PhpIfBaseUnwrapper;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpElseUnwrapper
extends PhpIfBaseUnwrapper {
    public PhpElseUnwrapper() {
        super(PhpBundle.message("unwrap.else", new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (e == null) {
            PhpElseUnwrapper.$$$reportNull$$$0(0);
        }
        return e instanceof Else;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        if (e == null) {
            PhpElseUnwrapper.$$$reportNull$$$0(1);
        }
        if (toExtract == null) {
            PhpElseUnwrapper.$$$reportNull$$$0(2);
        }
        super.collectAffectedElements(e, toExtract);
        return PhpPsiUtil.getParentByCondition(e, (Condition<? super PsiElement>)If.INSTANCEOF);
    }

    @Override
    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (editor == null) {
            PhpElseUnwrapper.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpElseUnwrapper.$$$reportNull$$$0(4);
        }
        List<PsiElement> elementsToExtract = super.unwrap(editor, element);
        return PhpElseUnwrapper.doUnwrap(element, elementsToExtract);
    }

    @NotNull
    public List<PsiElement> unwrap(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PhpElseUnwrapper.$$$reportNull$$$0(5);
        }
        PhpUnwrapper.Context context = new PhpUnwrapper.Context(false);
        this.doUnwrap(element, context);
        return PhpElseUnwrapper.doUnwrap(element, context.getElementsToExtract());
    }

    @NotNull
    private static List<PsiElement> doUnwrap(@NotNull PsiElement element, List<PsiElement> elementsToExtract) {
        if (element == null) {
            PhpElseUnwrapper.$$$reportNull$$$0(6);
        }
        PsiElement ifStatement = element.getParent();
        ArrayList<PsiElement> res = new ArrayList<PsiElement>();
        PsiElement anchor = ifStatement;
        for (PsiElement e : elementsToExtract) {
            anchor = anchor.getParent().addAfter(e, anchor);
            CodeEditUtil.markToReformat((ASTNode)anchor.getNode(), (boolean)true);
            res.add(anchor);
        }
        element.delete();
        ArrayList<PsiElement> arrayList = res;
        if (arrayList == null) {
            PhpElseUnwrapper.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    protected void doUnwrap(PsiElement element, PhpUnwrapper.Context context) throws IncorrectOperationException {
        context.setNotEffective();
        GroupStatement gs = (GroupStatement)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        PsiElement ifStatement = element.getParent();
        if (ifStatement != null) {
            if (gs != null) {
                context.extractGroupStatement(this, gs, ifStatement);
            } else {
                Statement statement = (Statement)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                context.extractSingleStatement(statement, ifStatement);
            }
        }
    }

    @Override
    @Nullable
    public IElementType getClosingElementType() {
        return PhpTokenTypes.kwENDIF;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExtract";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/unwrap/PhpElseUnwrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/unwrap/PhpElseUnwrapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doUnwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doUnwrap";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

