/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.unwrap;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import org.jetbrains.annotations.NotNull;

public class PhpCallArgumentUnwrapper
extends PhpUnwrapper {
    private static final Condition<PsiElement> IS_APPLICABLE_EXPRESSION = e -> e instanceof FunctionReference || e instanceof NewExpression;

    public PhpCallArgumentUnwrapper() {
        super("");
    }

    @NotNull
    private static PsiElement adjustElementToTheLeft(PsiElement element) {
        Object argumentRootElement;
        PsiElement argument;
        PsiElement prevSibling;
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN) && IS_APPLICABLE_EXPRESSION.value((Object)element.getParent()) && (prevSibling = element.getPrevSibling()) != null && (argument = prevSibling.getContainingFile().findElementAt(element.getTextOffset() - 1)) != null && (argumentRootElement = PhpPsiUtil.getParentByCondition(argument, (Condition<? super PsiElement>)((Condition)e -> e.getParent() instanceof ParameterList))) != null) {
            Object t = argumentRootElement;
            if (t == null) {
                PhpCallArgumentUnwrapper.$$$reportNull$$$0(0);
            }
            return t;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PhpCallArgumentUnwrapper.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    public boolean isApplicableTo(@NotNull PsiElement element) {
        ParameterList parameterList;
        PsiElement parent;
        if (element == null) {
            PhpCallArgumentUnwrapper.$$$reportNull$$$0(2);
        }
        return (parent = (element = PhpCallArgumentUnwrapper.adjustElementToTheLeft(element)).getParent()) instanceof ParameterList && (parameterList = (ParameterList)parent).getParameters().length == 1 && IS_APPLICABLE_EXPRESSION.value((Object)parameterList.getParent());
    }

    @NotNull
    public String getDescription(@NotNull PsiElement element) {
        Object text;
        if (element == null) {
            PhpCallArgumentUnwrapper.$$$reportNull$$$0(3);
        }
        if (((String)(text = PhpCallArgumentUnwrapper.adjustElementToTheLeft(element).getText())).length() > 20) {
            text = ((String)text).substring(0, 17) + "...";
        }
        String string = PhpBundle.message("unwrap.method", text);
        if (string == null) {
            PhpCallArgumentUnwrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected void doUnwrap(PsiElement element, PhpUnwrapper.Context context) throws IncorrectOperationException {
        element = PhpCallArgumentUnwrapper.adjustElementToTheLeft(element);
        Object functionReference = PhpPsiUtil.getParentByCondition(element, IS_APPLICABLE_EXPRESSION);
        context.extractElement(element, (PsiElement)functionReference);
        context.delete((PsiElement)functionReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/unwrap/PhpCallArgumentUnwrapper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustElementToTheLeft";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/unwrap/PhpCallArgumentUnwrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

