/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.inplace;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableInplaceRenamer
extends VariableInplaceRenamer {
    @Nls
    private static final String CLOSEST_SCOPE = PhpBundle.message("closest.scope", new Object[0]);
    @Nls
    private static final String VALUES = PhpBundle.message("all.values", new Object[0]);
    private Set<CharSequence> myUsedVariableNames;

    public PhpVariableInplaceRenamer(PsiNamedElement rename, Editor editor) {
        super(rename, editor);
        this.collectVariables(rename);
    }

    public PhpVariableInplaceRenamer(PsiNamedElement elementToRename, Editor editor, Project project, String initialName, String oldName) {
        super(elementToRename, editor, project, initialName, oldName);
        this.collectVariables(elementToRename);
    }

    protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
        PsiReference referenceAtCaret = PhpRefactoringUtil.getReferenceAtCaret(scope, this.myEditor);
        if (referenceAtCaret != null) {
            PsiElement element = referenceAtCaret.getElement();
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(this.myEditor, element, referenceAtCaret.getRangeInElement());
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Collection<PsiReference> refsInClosestScope;
                if (StartMarkAction.canStart((Editor)this.myEditor) == null && element instanceof Variable && !(refsInClosestScope = PhpVariableInplaceRenamer.filterRefsInNearestScope((Variable)element, refs)).isEmpty() && refsInClosestScope.size() != refs.size()) {
                    this.chooseScope(refs, stringUsages, scope, containingFile, refsInClosestScope);
                    return true;
                }
            } else if (PhpRefactoringSettings.getInstance().RENAME_SEARCH_VARIABLE_IN_CLOSEST_SCOPE) {
                Collection<PsiReference> refsInClosestScope = PhpVariableInplaceRenamer.filterRefsInNearestScope((Variable)element, refs);
                return super.buildTemplateAndStart(refsInClosestScope, stringUsages, scope, containingFile);
            }
        }
        return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
    }

    private void chooseScope(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile, Collection<PsiReference> refsInNearestScope) {
        final HashSet rangeHighlighters = new HashSet();
        JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(CLOSEST_SCOPE, VALUES)).setItemSelectedCallback(selectedValue -> {
            if (selectedValue == null) {
                return;
            }
            PhpVariableInplaceRenamer.dropHighlighters(rangeHighlighters);
            for (PsiReference reference : selectedValue.equals(CLOSEST_SCOPE) ? refsInNearestScope : refs) {
                TextRange textRange = reference.getAbsoluteRange();
                RangeHighlighter rangeHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
                rangeHighlighters.add(rangeHighlighter);
            }
        }).setTitle(PhpBundle.message("popup.title.multiple.write.scopes.found", new Object[0])).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", key -> key)).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(selectedValue -> {
            if (selectedValue.equals(CLOSEST_SCOPE)) {
                this.setElementToRename((PsiNamedElement)((Variable)ContainerUtil.getFirstItem((Collection)refsInNearestScope)));
                super.buildTemplateAndStart(refsInNearestScope, stringUsages, scope, containingFile);
            } else {
                super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
            }
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpVariableInplaceRenamer.dropHighlighters(rangeHighlighters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/refactoring/rename/inplace/PhpVariableInplaceRenamer$1", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    @NotNull
    public static Collection<PsiReference> filterRefsInNearestScope(Variable variableAtCaret, Collection<PsiReference> references) {
        PsiElement nearestScope = PhpVariableInplaceRenamer.findNearestScopeWithDefiningVariable(variableAtCaret);
        if (nearestScope != null) {
            List list = ContainerUtil.filter(references, r -> PsiTreeUtil.isAncestor((PsiElement)nearestScope, (PsiElement)r.getElement(), (boolean)false));
            if (list == null) {
                PhpVariableInplaceRenamer.$$$reportNull$$$0(0);
            }
            return list;
        }
        Collection<PsiReference> collection = references;
        if (collection == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public static PsiElement findNearestScopeWithDefiningVariable(Variable variable) {
        ForeachStatement statement = (ForeachStatement)PhpPsiUtil.getParentByCondition((PsiElement)variable, true, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF);
        if (statement != null && (PhpVariableInplaceRenamer.isSameVariable((PsiElement)statement.getKey(), variable) || PhpVariableInplaceRenamer.isSameVariable((PsiElement)statement.getValue(), variable))) {
            return statement;
        }
        Catch phpCatch = (Catch)PhpPsiUtil.getParentByCondition((PsiElement)variable, true, (Condition<? super PsiElement>)Catch.INSTANCEOF);
        if (phpCatch != null && PhpVariableInplaceRenamer.isSameVariable((PsiElement)phpCatch.getException(), variable)) {
            return phpCatch;
        }
        For phpFor = (For)PhpPsiUtil.getParentByCondition((PsiElement)variable, true, (Condition<? super PsiElement>)For.INSTANCEOF);
        if (phpFor != null && ContainerUtil.exists((Object[])phpFor.getInitialExpressions(), i -> i instanceof AssignmentExpression && PhpVariableInplaceRenamer.isSameVariable((PsiElement)((AssignmentExpression)i).getVariable(), variable))) {
            return phpFor;
        }
        return null;
    }

    private static boolean isSameVariable(@Nullable PsiElement candidate, @NotNull Variable variable) {
        if (variable == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(2);
        }
        return candidate instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)candidate).getName(), variable.getName());
    }

    private static void dropHighlighters(Collection<RangeHighlighter> rangeHighlighters) {
        for (RangeHighlighter highlight : rangeHighlighters) {
            highlight.dispose();
        }
    }

    private void collectVariables(PsiNamedElement elementToRename) {
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations((PsiElement)elementToRename, true, null);
        this.myUsedVariableNames = new THashSet();
        for (PhpNamedElement phpNamedElement : declarations) {
            this.myUsedVariableNames.add(phpNamedElement.getNameCS());
        }
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(3);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(5);
        }
        PsiElement element = reference.getElement();
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), element);
        if (textRange == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    protected boolean performRefactoring() {
        if (!PhpLangUtil.equalsVariableNames(this.myOldName, this.myInsertedName) && this.myUsedVariableNames.contains(this.myInsertedName)) {
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)PhpBundle.message("conflict.variable.with.same.name.already.exists", new Object[0]), (String)"", null);
        }
        return super.performRefactoring();
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new PhpVariableInplaceRenamer(variable, editor, this.myProject, initialName, this.myOldName);
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        if (this.myElementToRename instanceof Parameter) {
            Object clazz = PhpPsiUtil.getParentByCondition((PsiElement)this.myElementToRename, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            return clazz == null ? this.myElementToRename.getContainingFile() : null;
        }
        if (this.myElementToRename instanceof PhpGotoLabel) {
            Object function = PhpPsiUtil.getParentByCondition((PsiElement)this.myElementToRename, (Condition<? super PsiElement>)Function.INSTANCEOF);
            if (function != null) {
                return function;
            }
            return this.myElementToRename.getContainingFile();
        }
        return super.checkLocalScope();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/inplace/PhpVariableInplaceRenamer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRefsInNearestScope";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/inplace/PhpVariableInplaceRenamer";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSameVariable";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

