/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.inplace;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpFieldInplaceRenamer
extends MemberInplaceRenamer {
    public PhpFieldInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor) {
        if (elementToRename == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(0);
        }
        super(elementToRename, substituted, editor);
    }

    public PhpFieldInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor, String initialName, String oldName) {
        if (elementToRename == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(1);
        }
        super(elementToRename, substituted, editor, initialName, oldName);
    }

    protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
        int offset = this.myEditor.getCaretModel().getOffset();
        PsiFile myEditorFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiFile file = myEditorFile != null ? myEditorFile : containingFile;
        PsiElement elementAt = file.findElementAt(offset);
        PsiReference referenceAtCaret = PhpRefactoringUtil.getReferenceAtCaret((PsiElement)file, this.myEditor);
        if (referenceAtCaret != null) {
            PsiElement refElement = referenceAtCaret.getElement();
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(this.myEditor, refElement, PhpRefactoringUtil.getVariableIdentifierRange(referenceAtCaret.getRangeInElement(), refElement));
        } else if (elementAt != null) {
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(this.myEditor, elementAt, new TextRange(0, elementAt.getTextLength()));
        }
        return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(2);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(4);
        }
        PsiElement element = reference.getElement();
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), element);
        if (textRange == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    protected boolean acceptReference(PsiReference reference) {
        PsiElement element = reference.getElement();
        TextRange textRange = this.getRangeToRename(reference);
        String referenceText = textRange.substring(element.getText());
        return Comparing.strEqual((String)referenceText, (String)this.myElementToRename.getName());
    }

    protected boolean isIdentifier(String newName, Language language) {
        if (this.myElementToRename instanceof Field) {
            return PhpNameUtil.isValidFieldName(newName);
        }
        return PhpLangUtil.isPhpIdentifier(newName) && !PhpLangUtil.isPhpReservedKeyword(newName);
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new PhpFieldInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/inplace/PhpFieldInplaceRenamer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/inplace/PhpFieldInplaceRenamer";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

