/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class PhpNameSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> _result) {
        String oldName;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (element instanceof PhpNamedElement && StringUtil.isNotEmpty((String)(oldName = ((PhpNamedElement)element).getName()))) {
            result.add(oldName);
        }
        Project project = element.getProject();
        if (element instanceof Variable || element instanceof PhpDocVariable) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null) {
                Collection references = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)containingFile)).findAll();
                for (PsiReference reference : references) {
                    if (!(reference instanceof PsiElement)) continue;
                    result.addAll(PhpNameSuggestionUtil.variableNameByPlace((PsiElement)reference));
                }
            }
            result.addAll(PhpNameSuggestionUtil.variableNameByType((PhpTypedElement)element, project, true));
        } else if (element instanceof Constant) {
            PsiElement value = ((Constant)element).getValue();
            if (value instanceof StringLiteralExpression) {
                result.addAll(PhpNameSuggestionUtil.constantNameByString((StringLiteralExpression)value));
            }
        } else if (element instanceof Field) {
            if (((Field)element).isConstant()) {
                PsiElement value = ((Field)element).getDefaultValue();
                if (value instanceof StringLiteralExpression) {
                    result.addAll(PhpNameSuggestionUtil.constantNameByString((StringLiteralExpression)value));
                }
            } else {
                PsiFile containingFile;
                PsiElement defaultValue = ((Field)element).getDefaultValue();
                if (defaultValue != null) {
                    result.addAll(PhpNameSuggestionUtil.variableNameByValue(defaultValue));
                }
                if ((containingFile = element.getContainingFile()) != null) {
                    Collection references = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)containingFile)).findAll();
                    for (PsiReference reference : references) {
                        if (!(reference instanceof FieldReference)) continue;
                        result.addAll(PhpNameSuggestionUtil.variableNameByPlace((PsiElement)((FieldReference)reference)));
                    }
                }
                result.addAll(PhpNameSuggestionUtil.variableNameByType((PhpTypedElement)((Field)element), project, false));
            }
        } else if (element instanceof Parameter) {
            Function containingFunction = (Function)PsiTreeUtil.getParentOfType((PsiElement)element, Function.class, (boolean)true);
            if (containingFunction != null) {
                Collection references = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)containingFunction)).findAll();
                for (PsiReference reference : references) {
                    if (!(reference instanceof Variable)) continue;
                    result.addAll(PhpNameSuggestionUtil.variableNameByPlace((PsiElement)((Variable)reference)));
                }
            }
            result.addAll(PhpNameSuggestionUtil.variableNameByType((PhpTypedElement)((Parameter)element), project, false));
        } else if (element instanceof PhpFile) {
            result.addAll(PhpNameSuggestionUtil.fileNameByContent((PhpFile)element));
        }
        _result.addAll(result);
        return null;
    }
}

