/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.PhpRenamePsiElementProcessor;
import com.jetbrains.php.refactoring.validation.PhpFunctionConflictDetector;
import org.jetbrains.annotations.NotNull;

public class PhpFunctionRenameProcessor
extends PhpRenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpFunctionRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof Function && !(element instanceof Method) && !((Function)element).isClosure();
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            PhpFunctionRenameProcessor.$$$reportNull$$$0(1);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpFunctionRenameProcessor.$$$reportNull$$$0(2);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpFunctionRenameProcessor.$$$reportNull$$$0(3);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION = enabled;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpFunctionRenameProcessor.$$$reportNull$$$0(4);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION = enabled;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        String message;
        if (element == null) {
            PhpFunctionRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            PhpFunctionRenameProcessor.$$$reportNull$$$0(6);
        }
        if (conflicts == null) {
            PhpFunctionRenameProcessor.$$$reportNull$$$0(7);
        }
        if (StringUtil.isNotEmpty((String)(message = new PhpFunctionConflictDetector((Function)element).findConflicts(newName)))) {
            conflicts.putValue((Object)element, (Object)message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpFunctionRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNameConflicts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

