/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush.pushDown;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.memberPushDown.PushDownUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.pullPush.PhpPullPushBaseProcessor;
import com.jetbrains.php.refactoring.pullPush.pushDown.PhpPushDownConflicts;
import com.jetbrains.php.refactoring.pullPush.pushDown.PhpPushDownHandler;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpPushDownProcessor
extends PhpPullPushBaseProcessor {
    private static final Logger LOG = Logger.getInstance(PhpPushDownProcessor.class);

    public PhpPushDownProcessor(Project project, PhpClass clazz, Collection<PhpMemberInfo> selectedMemberInfos) {
        super(project, clazz, selectedMemberInfos);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpPushDownProcessor.$$$reportNull$$$0(0);
        }
        return new PushDownUsageViewDescriptor((PsiElement)this.myClass);
    }

    protected UsageInfo @NotNull [] findUsages() {
        Collection subClasses = PhpClassHierarchyUtils.getDirectSubclasses((PhpClass)this.myClass);
        if (this.myClass.isInterface()) {
            subClasses = ContainerUtil.filter((Collection)subClasses, aClass -> aClass.isInterface());
        }
        Object[] result = new UsageInfo[subClasses.size()];
        ContainerUtil.map2Array((Collection)subClasses, (Object[])result, phpClass -> new UsageInfo((PsiElement)phpClass));
        if (result == null) {
            PhpPushDownProcessor.$$$reportNull$$$0(1);
        }
        return result;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> ref) {
        if (ref == null) {
            PhpPushDownProcessor.$$$reportNull$$$0(2);
        }
        UsageInfo[] usages = (UsageInfo[])ref.get();
        PhpPushDownConflicts conflicts = new PhpPushDownConflicts(this.myClass, this.mySelectedMemberInfos);
        conflicts.checkSourceClassConflicts();
        if (usages.length == 0) {
            String message = PhpBundle.message("0.pushing.members.down.will.result.in.them.being.deleted", RefactoringBundle.message((String)"class.0.does.not.have.inheritors", (Object[])new Object[]{this.myClass.getName()}));
            if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)PhpPushDownHandler.getRefactoringNameText(), (String)message).asWarning()).ask(this.myProject)) {
                return false;
            }
        }
        for (UsageInfo usage : usages) {
            PhpClass clazz = (PhpClass)usage.getElement();
            LOG.assertTrue(clazz != null);
            conflicts.checkTargetClassConflicts(clazz);
        }
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpPushDownProcessor.$$$reportNull$$$0(3);
        }
        List<PhpClassMember> members = this.getSelectedMembers();
        for (UsageInfo usage : usages) {
            PhpClass targetClass = (PhpClass)usage.getElement();
            LOG.assertTrue(targetClass != null);
            PhpMoveClassMemberBase.getInstance(targetClass, false).move(members);
        }
        PhpMoveClassMemberBase.removeMembers(members, true);
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpPushDownHandler.getRefactoringNameText();
        if (string == null) {
            PhpPushDownProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/pullPush/pushDown/PhpPushDownProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/pushDown/PhpPushDownProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

