/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.namespace;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpFileCreator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveNamespaceUsage
extends UsageInfo {
    protected final String myNewReferenceText;
    private final PhpFileCreationInfo myMovedFileConfiguration;

    public PhpMoveNamespaceUsage(@NotNull PsiReference reference, @NotNull String newReferenceText, @Nullable PhpFileCreationInfo movedFileConfiguration, boolean fqnExpected) {
        if (reference == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(0);
        }
        if (newReferenceText == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(1);
        }
        super(reference);
        this.myNewReferenceText = fqnExpected ? PhpLangUtil.toFQN(newReferenceText) : newReferenceText;
        this.myMovedFileConfiguration = movedFileConfiguration;
    }

    public PhpMoveNamespaceUsage(@NotNull PsiElement element, @NotNull String newReferenceText, @Nullable PhpFileCreationInfo movedFileConfiguration) {
        if (element == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(2);
        }
        if (newReferenceText == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(3);
        }
        super(element);
        this.myNewReferenceText = newReferenceText;
        this.myMovedFileConfiguration = movedFileConfiguration;
    }

    public static PhpMoveNamespaceUsage createDeclarationUsage(@NotNull PhpNamespace namespace, @NotNull String newNamespaceName, @Nullable PhpFileCreationInfo newRelativePath) {
        if (namespace == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(4);
        }
        if (newNamespaceName == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(5);
        }
        return new PhpMoveNamespaceDeclaration((PsiElement)namespace, newNamespaceName, newRelativePath);
    }

    @Nullable
    public static PhpMoveNamespaceUsage createUsage(@NotNull PsiReference namespace, @NotNull String oldNamespaceName, @NotNull String newNamespaceName, @NotNull String newReferenceText, @Nullable PhpFileCreationInfo newFileConfiguration) {
        if (namespace == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(6);
        }
        if (oldNamespaceName == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(7);
        }
        if (newNamespaceName == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(8);
        }
        if (newReferenceText == null) {
            PhpMoveNamespaceUsage.$$$reportNull$$$0(9);
        }
        PsiElement element = namespace.getElement();
        if (namespace instanceof ClassReference) {
            return new PhpMoveNamespaceReferenceInUse(namespace, newNamespaceName, newFileConfiguration, false);
        }
        boolean isInsideUse = PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpUse.INSTANCEOF) != null;
        boolean fqnExpected = element.getText().startsWith("\\") && !StringUtil.isEmpty((String)newReferenceText);
        PsiElement parent = element.getParent();
        if (!(parent instanceof PhpNamespace)) {
            String alias;
            Map<String, String> aliases;
            PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
            if (StringUtil.isEmpty((String)newNamespaceName) && scope instanceof PhpNamespace && !StringUtil.isEmpty((String)((PhpNamespace)scope).getName()) && !StringUtil.isEmpty((String)newReferenceText)) {
                fqnExpected = true;
            }
            if (scope != null && (aliases = PhpCodeInsightUtil.getAliasesInScope(scope)).containsKey(alias = PhpLangUtil.toAliasName(element.getText()))) {
                String importedName = PhpLangUtil.toName(aliases.get(alias));
                if (StringUtil.startsWith((CharSequence)oldNamespaceName, (CharSequence)importedName)) {
                    String qualifiedName;
                    String newFqn = PhpLangUtil.toFQN(PhpLangUtil.equalsClassNames(importedName, oldNamespaceName) ? newNamespaceName : importedName);
                    String newReferenceFqn = PhpLangUtil.toFQN(newReferenceText);
                    String shortOldNamespaceName = PhpLangUtil.toShortName(oldNamespaceName);
                    if (PhpLangUtil.equalsClassNames(shortOldNamespaceName, alias)) {
                        alias = PhpLangUtil.toShortName(newNamespaceName);
                    }
                    if ((qualifiedName = PhpCodeInsightUtil.createQualifiedName(newReferenceFqn, newFqn, alias, true)) != null) {
                        return new PhpMoveNamespaceReference(namespace, qualifiedName, newFileConfiguration, !isInsideUse && fqnExpected);
                    }
                }
                String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scope, PhpLangUtil.toFQN(newReferenceText));
                return new PhpMoveNamespaceReference(namespace, qualifiedName, newFileConfiguration, !isInsideUse && fqnExpected);
            }
        }
        return new PhpMoveNamespaceReference(namespace, newReferenceText, newFileConfiguration, !isInsideUse && fqnExpected);
    }

    public void performRefactoring() {
        PsiFile file;
        this.moveNamespace();
        if (this.myMovedFileConfiguration != null && (file = this.getFile()) != null && file.isValid()) {
            List path = StringUtil.split((String)FileUtil.toSystemIndependentName((String)this.myMovedFileConfiguration.getRelativePath()), (String)"/");
            PsiDirectory parentDir = PhpFileCreator.createDirectory(path, this.myMovedFileConfiguration.getBaseDirectory());
            MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)parentDir);
        }
    }

    public abstract void moveNamespace();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newReferenceText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNamespaceName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceUsage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createDeclarationUsage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpMoveNamespaceReference
    extends PhpMoveNamespaceUsage {
        PhpMoveNamespaceReference(@NotNull PsiReference reference, @NotNull String newReferenceText, @Nullable PhpFileCreationInfo fileConfiguration, boolean fqnExpected) {
            if (reference == null) {
                PhpMoveNamespaceReference.$$$reportNull$$$0(0);
            }
            if (newReferenceText == null) {
                PhpMoveNamespaceReference.$$$reportNull$$$0(1);
            }
            super(reference, newReferenceText, fileConfiguration, fqnExpected);
        }

        @Override
        public void moveNamespace() {
            PsiElement element = this.getElement();
            if (element instanceof PhpNamespaceReference) {
                PsiElement parent = element.getParent();
                PhpCodeEditUtil.replaceNamespaceReference((PhpPsiElement)parent, this.myNewReferenceText, (PhpNamespaceReference)element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newReferenceText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceUsage$PhpMoveNamespaceReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpMoveNamespaceReferenceInUse
    extends PhpMoveNamespaceUsage {
        PhpMoveNamespaceReferenceInUse(@NotNull PsiReference reference, @NotNull String newReferenceText, @Nullable PhpFileCreationInfo fileConfiguration, boolean fqnExpected) {
            if (reference == null) {
                PhpMoveNamespaceReferenceInUse.$$$reportNull$$$0(0);
            }
            if (newReferenceText == null) {
                PhpMoveNamespaceReferenceInUse.$$$reportNull$$$0(1);
            }
            super(reference, newReferenceText, fileConfiguration, fqnExpected);
        }

        @Override
        public void moveNamespace() {
            ClassReference reference = this.getClassReference();
            PhpUseList useList = (PhpUseList)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            assert (useList != null);
            if (StringUtil.isEmpty((String)this.myNewReferenceText)) {
                Object[] declarations = useList.getDeclarations();
                assert (!ArrayUtil.isEmpty((Object[])declarations));
                if (declarations.length == 1) {
                    useList.getParent().deleteChildRange((PsiElement)useList, (PsiElement)useList);
                } else {
                    PsiElement parent = reference.getParent();
                    useList.deleteChildRange(parent, parent);
                }
            } else {
                ClassReference newReference = PhpPsiElementFactory.createClassReference(reference.getProject(), this.myNewReferenceText);
                reference.replace((PsiElement)newReference);
            }
        }

        @NotNull
        private ClassReference getClassReference() {
            PsiElement element = this.getElement();
            assert (element instanceof ClassReference);
            ClassReference classReference = (ClassReference)element;
            if (classReference == null) {
                PhpMoveNamespaceReferenceInUse.$$$reportNull$$$0(2);
            }
            return classReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newReferenceText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceUsage$PhpMoveNamespaceReferenceInUse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceUsage$PhpMoveNamespaceReferenceInUse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpMoveNamespaceDeclaration
    extends PhpMoveNamespaceUsage {
        PhpMoveNamespaceDeclaration(@NotNull PsiElement element, @NotNull String newReferenceText, @Nullable PhpFileCreationInfo baseDirectory) {
            if (element == null) {
                PhpMoveNamespaceDeclaration.$$$reportNull$$$0(0);
            }
            if (newReferenceText == null) {
                PhpMoveNamespaceDeclaration.$$$reportNull$$$0(1);
            }
            super(element, newReferenceText, baseDirectory);
        }

        private static void deleteNamespaceDeclaration(@NotNull PhpNamespace namespace, @NotNull PsiElement identifier, @Nullable PsiElement namespaceReference) {
            if (namespace == null) {
                PhpMoveNamespaceDeclaration.$$$reportNull$$$0(2);
            }
            if (identifier == null) {
                PhpMoveNamespaceDeclaration.$$$reportNull$$$0(3);
            }
            PsiElement kwNamespace = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpTokenTypes.kwNAMESPACE);
            boolean braced = namespace.isBraced();
            if (braced) {
                PsiElement firstElementToDelete = kwNamespace == null ? (namespaceReference == null ? identifier : namespaceReference) : kwNamespace.getNextSibling();
                namespace.deleteChildRange(firstElementToDelete, identifier);
            } else {
                PsiElement semicolon = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpTokenTypes.opSEMICOLON);
                namespace.deleteChildRange(kwNamespace, semicolon == null ? identifier : semicolon);
            }
        }

        @Override
        public void moveNamespace() {
            String newName;
            String name;
            PhpNamespace namespace = this.getNamespace();
            PsiElement identifier = namespace.getNameIdentifier();
            PsiElement namespaceReference = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpElementTypes.NS_REFERENCE);
            if (StringUtil.isEmpty((String)this.myNewReferenceText)) {
                assert (identifier != null);
                PhpMoveNamespaceDeclaration.deleteNamespaceDeclaration(namespace, identifier, namespaceReference);
                return;
            }
            String newParentName = PhpLangUtil.toName(PhpLangUtil.getParentNamespaceFQN(PhpLangUtil.toFQN(this.myNewReferenceText)));
            String parentNamespaceName = PhpLangUtil.toName(namespace.getParentNamespaceName());
            if (StringUtil.isEmpty((String)newParentName)) {
                if (namespaceReference != null) {
                    namespaceReference.getParent().deleteChildRange(namespaceReference, namespaceReference);
                }
            } else if (!PhpLangUtil.equalsClassNames(parentNamespaceName, newParentName)) {
                PhpNamespaceReference newNamespaceReference = PhpPsiElementFactory.createNamespaceReference(namespace.getProject(), newParentName, false);
                if (namespaceReference != null) {
                    namespaceReference.replace((PsiElement)newNamespaceReference);
                } else if (identifier != null) {
                    identifier.getParent().addBefore((PsiElement)newNamespaceReference, identifier);
                }
            }
            if (!PhpLangUtil.equalsClassNames(name = namespace.getName(), newName = PhpLangUtil.toShortName(this.myNewReferenceText)) && identifier != null) {
                PsiElement newIdentifier = PhpPsiElementFactory.createFromText(namespace.getProject(), PhpTokenTypes.IDENTIFIER, newName);
                identifier.replace(newIdentifier);
            }
        }

        @NotNull
        private PhpNamespace getNamespace() {
            PsiElement element = this.getElement();
            assert (element instanceof PhpNamespace);
            PhpNamespace phpNamespace = (PhpNamespace)element;
            if (phpNamespace == null) {
                PhpMoveNamespaceDeclaration.$$$reportNull$$$0(4);
            }
            return phpNamespace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newReferenceText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceUsage$PhpMoveNamespaceDeclaration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceUsage$PhpMoveNamespaceDeclaration";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteNamespaceDeclaration";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

