/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.namespace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceData;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceProcessor;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceSettings;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceUsageSearcher;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveRelatedNamespacesDialog;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveNamespaceDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(PhpMoveNamespaceDialog.class);
    private static final String HELP_ID = "refactoring.move.namespace";
    private static final String DIMENSION_SERVICE_KEY = "#com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceDialog#";
    private JPanel myMainPanel;
    private final PhpPsrNamespacePanel myDirectoryChoosePanel;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurrences;
    private final PhpNamespace myNamespace;
    private PhpMoveNamespaceSettings mySettings;

    protected PhpMoveNamespaceDialog(@NotNull Project project, @NotNull PhpNamespace namespace, boolean canBeParent) {
        if (project == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(1);
        }
        super(project, canBeParent);
        this.mySettings = null;
        this.myNamespace = namespace;
        this.myDirectoryChoosePanel = new PhpPsrNamespacePanel(this.myProject, this.getNamespaceFullName(), this.myNamespace.getContainingFile()){

            @Override
            @NotNull
            @Nls
            public String getNamespaceLabelText() {
                String string = PhpBundle.message("refactoring.move.namespace.new.namespace", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceDialog$1", "getNamespaceLabelText"));
            }
        };
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myDirectoryChoosePanel);
        this.setTitle(PhpBundle.message("refactoring.move.namespace.title", this.myNamespace.getName()));
        this.init();
    }

    private String getNamespaceFullName() {
        return PhpLangUtil.toName(this.myNamespace.getFQN());
    }

    protected void doAction() {
        ValidationInfo error;
        this.rememberSettings();
        String newNamespaceName = this.myDirectoryChoosePanel.getNamespaceName();
        String oldNamespaceFqn = this.myNamespace.getFQN();
        if (PhpLangUtil.equalsNamespaceNames(newNamespaceName, PhpLangUtil.toPresentableFQN(oldNamespaceFqn))) {
            this.doCancelAction();
            return;
        }
        if (this.isSearchInComments() || this.isSearchInTextOccurrences()) {
            this.setPreviewResults(true);
        }
        if ((error = this.findValidationError()) != null) {
            this.showErrorMessage(error.message);
        }
        try {
            Collection declarations = PhpIndex.getInstance((Project)this.myProject).getNamespacesByName(this.myNamespace.getFQN());
            VirtualFile oldFile = this.myNamespace.getContainingFile().getVirtualFile();
            String newDirectory = this.myDirectoryChoosePanel.getSelectedDirectory();
            Map<String, PhpFileCreationInfo> pathMappings = this.createMoveFilePathMappings(oldFile, newDirectory, newNamespaceName, declarations);
            if (pathMappings != null) {
                this.mySettings = new PhpMoveNamespaceSettings(newNamespaceName, declarations, pathMappings);
                this.close(0);
            }
        }
        catch (PhpFilePathValidationException e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    @Nullable
    public BaseRefactoringProcessor createMoveProcessor() {
        if (this.mySettings != null) {
            return new PhpMoveNamespaceProcessor(this.myProject, this.mySettings.getDeclarations(), this.mySettings.getNewNamespace(), this.mySettings.getPathMappings(), this.isSearchInComments(), this.isSearchInTextOccurrences());
        }
        return null;
    }

    @Nullable
    protected Map<String, PhpFileCreationInfo> createMoveFilePathMappings(@NotNull VirtualFile oldFile, @NotNull String newDirectory, @NotNull String newNamespaceName, @NotNull Collection<PhpNamespace> namespaces) throws PhpFilePathValidationException {
        Map<String, PhpFileCreationInfo> moveData;
        if (oldFile == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(2);
        }
        if (newDirectory == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(3);
        }
        if (newNamespaceName == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(4);
        }
        if (namespaces == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(5);
        }
        String oldDirectory = PathUtil.getParentPath((String)oldFile.getPath());
        THashMap pathMapper = new THashMap();
        if (!FileUtil.namesEqual((String)oldDirectory, (String)newDirectory)) {
            PhpFileCreationInfo fileConfiguration = PhpFileCreationInfo.generateConfiguration(this.myProject, newDirectory, oldFile.getName());
            pathMapper.put((Object)oldFile.getPath(), (Object)fileConfiguration);
        }
        if ((moveData = this.collectMoveRelatedNamespaceData(newNamespaceName, newDirectory, namespaces)) == null) {
            return null;
        }
        pathMapper.putAll(moveData);
        return pathMapper;
    }

    private void rememberSettings() {
        PhpRefactoringSettings.getInstance().MOVE_NAMESPACE_SEARCH_IN_COMMENTS_AND_STRINGS = this.isSearchInComments();
        PhpRefactoringSettings.getInstance().MOVE_NAMESPACE_SEARCH_IN_TEXT_OCCURRENCES = this.isSearchInTextOccurrences();
    }

    @Nullable
    protected Map<String, PhpFileCreationInfo> collectMoveRelatedNamespaceData(@NotNull String newNamespaceName, @NotNull String newMainDirectory, @NotNull Collection<PhpNamespace> declarations) {
        if (newNamespaceName == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(6);
        }
        if (newMainDirectory == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(7);
        }
        if (declarations == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(8);
        }
        ArrayList childNamespaces = new ArrayList();
        Runnable runnable = () -> ApplicationManager.getApplication().runReadAction(() -> childNamespaces.addAll(PhpMoveNamespaceUsageSearcher.getInstance(this.myProject).findChildNamespaceDeclarations(this.myNamespace)));
        String title = PhpBundle.message("refactoring.move.related.namespace.collect.title", new Object[0]);
        boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, title, true, null, (JComponent)this.myMainPanel);
        if (!complete) {
            throw new ProcessCanceledException();
        }
        List<PhpMoveNamespaceData> moveData = PhpMoveNamespaceDialog.suggestRelatedDirectories(this.myNamespace, newNamespaceName, newMainDirectory, declarations, childNamespaces);
        if (!moveData.isEmpty()) {
            PhpMoveRelatedNamespacesDialog dialog = new PhpMoveRelatedNamespacesDialog(this.myProject, moveData);
            return dialog.showAndGet() ? dialog.getFileMoveData() : null;
        }
        return new HashMap<String, PhpFileCreationInfo>();
    }

    @NotNull
    protected static List<PhpMoveNamespaceData> suggestRelatedDirectories(@NotNull PhpNamespace namespace, @NotNull String newNamespaceName, @NotNull String newMainDirectory, @NotNull Collection<? extends PhpNamespace> declarations, @NotNull Collection<? extends PhpNamespace> childNamespaces) {
        if (namespace == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(9);
        }
        if (newNamespaceName == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(10);
        }
        if (newMainDirectory == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(11);
        }
        if (declarations == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(12);
        }
        if (childNamespaces == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(13);
        }
        if (declarations.size() == 1 && childNamespaces.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpMoveNamespaceDialog.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<PhpMoveNamespaceData> moveData = new ArrayList<PhpMoveNamespaceData>();
        PsiDirectory directory = namespace.getContainingFile().getContainingDirectory();
        assert (directory != null) : "Can not find namespace directory";
        VirtualFile oldMainDirectory = directory.getVirtualFile();
        for (PhpNamespace phpNamespace : declarations) {
            PsiDirectory psiDirectory;
            if (namespace == phpNamespace || (psiDirectory = phpNamespace.getContainingFile().getContainingDirectory()) == null) continue;
            VirtualFile namespaceDirFile = psiDirectory.getVirtualFile();
            String suggestedDir = FileUtil.namesEqual((String)oldMainDirectory.getPath(), (String)namespaceDirFile.getPath()) ? newMainDirectory : namespaceDirFile.getPath();
            moveData.add(new PhpMoveNamespaceData(phpNamespace, newNamespaceName, suggestedDir));
        }
        String originFqn = namespace.getFQN();
        for (PhpNamespace phpNamespace : childNamespaces) {
            String fqn = phpNamespace.getFQN();
            String error = PhpMoveNamespaceDialog.validateChildFqn(originFqn, fqn);
            if (StringUtil.isNotEmpty((String)error)) {
                LOG.warn(error);
                continue;
            }
            String newFqn = PhpLangUtil.toFQN(newNamespaceName + StringUtil.trimStart((String)fqn, (String)originFqn));
            if (!phpNamespace.isValid()) continue;
            VirtualFile dir = phpNamespace.getContainingFile().getContainingDirectory().getVirtualFile();
            String relativePath = PhpMoveNamespaceDialog.getRelativePath(oldMainDirectory, dir.getPath());
            if (relativePath != null) {
                String suggestedDir = newMainDirectory + (String)(StringUtil.isEmpty((String)relativePath) ? "" : "/" + relativePath);
                moveData.add(new PhpMoveNamespaceData(phpNamespace, newFqn, suggestedDir));
                continue;
            }
            moveData.add(new PhpMoveNamespaceData(phpNamespace, newFqn, dir.getPath()));
        }
        ArrayList<PhpMoveNamespaceData> arrayList = moveData;
        if (arrayList == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    private static String validateChildFqn(@NotNull String originFqn, @Nullable String childFqn) {
        if (originFqn == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmpty((String)childFqn)) {
            return "Can not evaluate updated child namespace name: fqn is empty";
        }
        if (originFqn.length() > childFqn.length() || !childFqn.startsWith(originFqn)) {
            return "Can not evaluate updated child namespace name: '" + originFqn + "' -> '" + childFqn + "'";
        }
        return null;
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile baseDir, @NotNull String filePath) {
        String relativeDirPath;
        if (baseDir == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(17);
        }
        if (filePath == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(18);
        }
        if ((relativeDirPath = FileUtil.getRelativePath((String)baseDir.getPath(), (String)filePath, (char)'/')) == null || StringUtil.startsWith((CharSequence)relativeDirPath, (CharSequence)"..")) {
            return null;
        }
        return StringUtil.equals((CharSequence)relativeDirPath, (CharSequence)".") ? "" : relativeDirPath;
    }

    private ValidationInfo findValidationError() {
        String namespaceName = this.myDirectoryChoosePanel.getNamespaceName();
        if (StringUtil.isNotEmpty((String)namespaceName) && !PhpNameUtil.isValidNamespaceFullName(namespaceName)) {
            String message = PhpBundle.message("refactoring.common.validation.namespace.name", namespaceName);
            return new ValidationInfo(message, (JComponent)((Object)this.myDirectoryChoosePanel.getNamespaceField()));
        }
        return null;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo error = this.findValidationError();
        if (error != null) {
            return error;
        }
        return super.doValidate();
    }

    protected boolean postponeValidation() {
        return false;
    }

    private void showErrorMessage(@NotNull @NlsContexts.DialogMessage String message) {
        if (message == null) {
            PhpMoveNamespaceDialog.$$$reportNull$$$0(19);
        }
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(0, 0, 8, 0);
        gbConstraints.gridwidth = 2;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        this.myMainPanel.add((Component)this.myDirectoryChoosePanel, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 2;
        this.myCbSearchInComments = new NonFocusableCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        this.myCbSearchInComments.setSelected(PhpRefactoringSettings.getInstance().MOVE_NAMESPACE_SEARCH_IN_COMMENTS_AND_STRINGS);
        this.myMainPanel.add((Component)this.myCbSearchInComments, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.gridwidth = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 2;
        this.myCbSearchTextOccurrences = new NonFocusableCheckBox();
        this.myCbSearchTextOccurrences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
        this.myCbSearchTextOccurrences.setSelected(PhpRefactoringSettings.getInstance().MOVE_NAMESPACE_SEARCH_IN_TEXT_OCCURRENCES);
        this.myMainPanel.add((Component)this.myCbSearchTextOccurrences, gbConstraints);
        return this.myMainPanel;
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchInTextOccurrences() {
        return this.myCbSearchTextOccurrences.isSelected();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDirectoryChoosePanel.getPreferredFocusedComponent();
    }

    @Nullable
    protected String getHelpId() {
        return HELP_ID;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDirectory";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMainDirectory";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNamespaces";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceDialog";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originFqn";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceDialog";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestRelatedDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMoveFilePathMappings";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectMoveRelatedNamespaceData";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestRelatedDirectories";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "validateChildFqn";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

