/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.namespace;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.move.MoveCallback;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.move.PhpMoveDelegateBase;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceDialog;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class PhpMoveNamespaceDelegate
extends PhpMoveDelegateBase {
    static final String MOVE_NAMESPACE_ID = "move.namespace";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (elements.length == 1 && elements[0] instanceof PhpNamespace) {
            return targetContainer == null || super.canMove(elements, targetContainer, reference);
        }
        return false;
    }

    @Override
    public String getRefactoringName() {
        return PhpMoveNamespaceDelegate.getRefactoringNameText();
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 1 && elements[0] instanceof PhpNamespace) {
            PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(project, MOVE_NAMESPACE_ID);
            PhpMoveNamespaceDialog dialog = new PhpMoveNamespaceDialog(project, (PhpNamespace)elements[0], false);
            if (!dialog.showAndGet()) {
                PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(project, MOVE_NAMESPACE_ID);
                return;
            }
            BaseRefactoringProcessor processor = dialog.createMoveProcessor();
            if (processor != null) {
                boolean previewUsages = dialog.isPreviewUsages();
                processor.setPreviewUsages(previewUsages);
                processor.run();
            }
        }
    }

    @Nls
    protected static String getRefactoringNameText() {
        return PhpBundle.message("refactoring.move.namespace.name", new Object[0]);
    }
}

