/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member.instance;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.inspections.phpdoc.PhpFunctionDocCommentUpdater;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceConflicts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveInstanceMethodProcessor
extends PhpBaseRefactoringProcessor {
    private final Method myMethod;
    private final PhpClass myFromClass;
    private final PhpClass myTargetClass;
    @Nullable
    private final PhpNamedElement myTargetVariable;
    @NotNull
    private final String myNewVisibility;
    @Nullable
    private final String myParameterName;
    @NotNull
    protected Set<PsiFile> myAffectedFiles;

    public PhpMoveInstanceMethodProcessor(@NotNull Project project, Method method, @Nullable PhpNamedElement targetVariable, PhpClass targetClass, @NotNull String newVisibility, @Nullable String parameterName) {
        if (project == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(0);
        }
        if (newVisibility == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(1);
        }
        super(project);
        this.myMethod = method;
        this.myTargetVariable = targetVariable;
        this.myFromClass = this.myMethod.getContainingClass();
        this.myTargetClass = targetClass;
        this.myNewVisibility = newVisibility;
        this.myParameterName = parameterName;
        this.myAffectedFiles = new HashSet<PsiFile>();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(2);
        }
        return PhpMoveInstanceMethodProcessor.createMoveInstanceMethodUsageViewDescriptor(this.myMethod);
    }

    @NotNull
    public static UsageViewDescriptor createMoveInstanceMethodUsageViewDescriptor(final @NotNull Method method) {
        if (method == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(3);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{method};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.move.instance.method.preview.header", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/move/member/instance/PhpMoveInstanceMethodProcessor$1", "getElements"));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        Collection<PsiReference> references = PhpMoveMemberProcessor.findReferences((PsiElement)this.myMethod);
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            result.add(new UsageInfo(element));
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(4);
        }
        return usageInfoArray;
    }

    @Override
    protected void performMainRefactoring(UsageInfo @NotNull [] usages) {
        PhpDocComment updated;
        Method method;
        if (usages == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(5);
        }
        PhpClassReferenceResolver resolver = new PhpClassReferenceResolver();
        resolver.processElement((PsiElement)this.myMethod);
        this.refactorInternalReferences(this.myMethod);
        int toDeleteParameterIndex = this.removeParameterFromDeclaration(this.myMethod, this.myTargetVariable);
        for (UsageInfo usage : usages) {
            PhpPsiElement usageElement = (PhpPsiElement)usage.getElement();
            if (usageElement == null) continue;
            if (usageElement instanceof MethodReference) {
                MethodReference methodReference = (MethodReference)usageElement;
                PsiElement parameterExpression = null;
                PhpExpression classReference = methodReference.getClassReference();
                PsiElement parameter = methodReference.getParameter(toDeleteParameterIndex);
                if (parameter != null) {
                    parameterExpression = parameter;
                }
                assert (classReference != null);
                PsiElement parameterExpressionCopy = parameterExpression != null ? parameterExpression.copy() : null;
                this.fixArgumentList(methodReference, parameterExpression, classReference);
                if (parameterExpressionCopy != null) {
                    if (parameterExpressionCopy instanceof NewExpression) {
                        parameterExpressionCopy = PhpPsiElementFactory.createFromText(this.myProject, ParenthesizedExpression.class, "(" + parameterExpressionCopy.getText() + ")");
                    }
                    if (parameterExpressionCopy != null) {
                        classReference.replace(parameterExpressionCopy);
                    }
                }
                if (this.myTargetVariable instanceof Parameter) continue;
                this.processMoveToField(classReference);
                continue;
            }
            if (!(usageElement instanceof PhpDocRef)) continue;
            PhpMoveMemberProcessor.replaceDocReference((PhpDocRef)usageElement, this.myTargetClass.getName());
        }
        PhpMoveClassMemberBase instance = PhpMoveClassMemberBase.getInstance(this.myTargetClass, false);
        if (this.myNewVisibility.equals("AS_IS")) {
            method = (Method)instance.move(Collections.singletonList(this.myMethod), true).iterator().next();
        } else {
            PhpModifier.Access access = PhpMoveInstanceMethodProcessor.getAccess(this.myNewVisibility);
            method = (Method)instance.move(Collections.singletonList(this.myMethod), access, true).iterator().next();
        }
        PhpDocComment newDocComment = method.getDocComment();
        if (newDocComment != null && (updated = new PhpFunctionDocCommentUpdater(this.myProject, newDocComment, false).constructUpdatedComment()) != null) {
            newDocComment.replace((PsiElement)updated);
        }
        method = this.replaceModifiers(method);
        PhpCodeUtil.openRelatedFile(this.myProject, (PsiElement)method);
        this.optimizeImports(this.myAffectedFiles);
    }

    private static PhpModifier.Access getAccess(String visibility) {
        switch (visibility) {
            case "private": {
                return PhpModifier.Access.PRIVATE;
            }
            case "protected": {
                return PhpModifier.Access.PROTECTED;
            }
            case "public": {
                return PhpModifier.Access.PUBLIC;
            }
        }
        return PhpModifier.Access.PUBLIC;
    }

    private void processMoveToField(@NotNull PhpExpression classReference) {
        if (classReference == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(6);
        }
        if (this.myTargetVariable == null) {
            return;
        }
        FieldReference fieldReference = PhpPsiElementFactory.createFromText(this.myProject, FieldReference.class, classReference.getText() + "->" + this.myTargetVariable.getName() + ";");
        if (fieldReference != null) {
            classReference.replace((PsiElement)fieldReference);
        }
    }

    private Method replaceModifiers(@NotNull Method copy) {
        if (copy == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(7);
        }
        if (!this.myNewVisibility.equals("AS_IS")) {
            Object firstChild = PhpPsiUtil.getChildByCondition((PsiElement)copy, (Condition<? super PsiElement>)((Condition)PhpModifierList.class::isInstance));
            if (firstChild instanceof PhpModifierList) {
                PhpModifier modifier = this.myMethod.getModifier();
                String newModifiers = modifier.toString().replace(this.myMethod.getAccess().toString(), this.myNewVisibility);
                Method fixedMethod = PhpPsiElementFactory.createMethod(this.myProject, "class A {\n" + newModifiers + " " + copy.getText().substring(copy.getFirstPsiChild().getTextLength()) + "}");
                return (Method)copy.replace((PsiElement)fixedMethod);
            }
        }
        return copy;
    }

    private void refactorInternalReferences(Method method) {
        final HashMap variableReplacementMap = new HashMap();
        final Ref hasThisUsage = new Ref((Object)Boolean.FALSE);
        method.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                MemberReference memberReference = (MemberReference)PhpPsiUtil.getParentByCondition((PsiElement)variable, (Condition<? super PsiElement>)MemberReference.INSTANCEOF);
                if (PhpMoveInstanceMethodProcessor.this.myTargetVariable != null && variable.getName().equalsIgnoreCase(PhpMoveInstanceMethodProcessor.this.myTargetVariable.getName()) && variable.resolve() == PhpMoveInstanceMethodProcessor.this.myTargetVariable) {
                    variableReplacementMap.put(variable, PhpPsiElementFactory.createVariable(PhpMoveInstanceMethodProcessor.this.myProject, "this", true));
                }
                if (variable.getName().equalsIgnoreCase("this") && (memberReference == null || memberReference.resolve() != PhpMoveInstanceMethodProcessor.this.myMethod) && PhpMoveInstanceMethodProcessor.this.myParameterName != null) {
                    hasThisUsage.set((Object)Boolean.TRUE);
                    variableReplacementMap.put(variable, PhpPsiElementFactory.createVariable(PhpMoveInstanceMethodProcessor.this.myProject, PhpMoveInstanceMethodProcessor.this.myParameterName.substring(1), true));
                }
                super.visitPhpVariable(variable);
            }
        });
        if (((Boolean)hasThisUsage.get()).booleanValue()) {
            Parameter newParameter = PhpPsiElementFactory.createComplexParameter(this.myProject, this.myFromClass.getName() + " " + this.myParameterName);
            PhpChangeSignatureProcessor.appendParameterToParameterList((Function)method, newParameter);
        }
        for (Map.Entry entry : variableReplacementMap.entrySet()) {
            ((Variable)entry.getKey()).replace((PsiElement)entry.getValue());
        }
    }

    private void fixArgumentList(MethodReference reference, @Nullable PsiElement parameterExpression, PhpExpression classReference) {
        StringBuilder newParameterListText = new StringBuilder();
        boolean isFirst = true;
        for (PsiElement it : reference.getParameters()) {
            if (it.equals(parameterExpression)) continue;
            if (!isFirst) {
                newParameterListText.append(",");
            }
            newParameterListText.append(it.getText());
            isFirst = false;
        }
        if (this.myParameterName != null) {
            if (!isFirst) {
                newParameterListText.append(",");
            }
            newParameterListText.append(classReference.getText());
        }
        ParameterList newArgumentList = PhpPsiElementFactory.createArgumentList(this.myProject, newParameterListText.toString());
        ParameterList parameterList = reference.getParameterList();
        assert (parameterList != null);
        parameterList.replace((PsiElement)newArgumentList);
    }

    private int removeParameterFromDeclaration(@NotNull Method method, @Nullable PhpNamedElement parameterToRemove) {
        if (method == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(8);
        }
        if (parameterToRemove == null) {
            return -1;
        }
        Parameter[] parameters = method.getParameters();
        StringJoiner newParameterListText = new StringJoiner(",");
        int removedParameterIndex = -1;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].equals(parameterToRemove)) {
                removedParameterIndex = i;
                continue;
            }
            newParameterListText.add(parameters[i].getText());
        }
        if (removedParameterIndex == -1) {
            return removedParameterIndex;
        }
        ParameterList newParameterList = PhpPsiElementFactory.createParameterList(this.myProject, newParameterListText.toString());
        Object oldParameterList = PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        assert (oldParameterList != null);
        oldParameterList.replace((PsiElement)newParameterList);
        return removedParameterIndex;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages;
        if (refUsages == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(9);
        }
        this.myAffectedFiles.add(this.myFromClass.getContainingFile());
        this.myAffectedFiles.add(this.myTargetClass.getContainingFile());
        for (UsageInfo usageInfo : usages = (UsageInfo[])refUsages.get()) {
            this.myAffectedFiles.add(usageInfo.getFile());
        }
        PhpMoveInstanceConflicts conflicts = new PhpMoveInstanceConflicts(this.myMethod, this.myFromClass, this.myTargetClass, this.myNewVisibility.equals("AS_IS") ? this.myMethod.getAccess().toString() : this.myNewVisibility);
        conflicts.checkAlreadyDefinedMembers(this.myTargetClass);
        conflicts.checkFinalMethods(this.myTargetClass);
        conflicts.checkUsagesForConflicts(usages);
        conflicts.checkInternalReferences(this.myMethod);
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"move.instance.method.command");
        if (string == null) {
            PhpMoveInstanceMethodProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVisibility";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/member/instance/PhpMoveInstanceMethodProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/instance/PhpMoveInstanceMethodProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMoveInstanceMethodUsageViewDescriptor";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performMainRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processMoveToField";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceModifiers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeParameterFromDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

