/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpDocRefReferenceContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.intentions.PhpReplaceWithAliasIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberConflicts;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDelegate;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveMemberProcessor
extends PhpBaseRefactoringProcessor {
    @NotNull
    protected final Collection<PhpClassMember> mySelectedMembers;
    @NotNull
    protected PhpClass myFromClass;
    @NotNull
    protected PhpClass myTargetClass;
    @NotNull
    protected Set<PsiFile> affectedFiles;

    protected PhpMoveMemberProcessor(@NotNull Project project, @NotNull PhpClass fromClazz, @NotNull PhpClass targetClazz, @NotNull Collection<PhpClassMember> selectedMemberInfos) {
        if (project == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(0);
        }
        if (fromClazz == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(1);
        }
        if (targetClazz == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(2);
        }
        if (selectedMemberInfos == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(3);
        }
        super(project);
        this.myFromClass = fromClazz;
        this.myTargetClass = targetClazz;
        this.mySelectedMembers = selectedMemberInfos;
        this.affectedFiles = new THashSet();
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> ref) {
        if (ref == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(4);
        }
        UsageInfo[] usages = (UsageInfo[])ref.get();
        PhpMoveMemberConflicts conflicts = new PhpMoveMemberConflicts(this.mySelectedMembers, this.myFromClass, this.myTargetClass);
        conflicts.checkAlreadyDefinedMembers(this.myTargetClass);
        conflicts.checkFinalMethods(this.myTargetClass);
        conflicts.checkUsagesForConflicts(usages);
        for (UsageInfo usageInfo : usages) {
            this.affectedFiles.add(usageInfo.getFile());
        }
        this.affectedFiles.add(this.myFromClass.getContainingFile());
        this.affectedFiles.add(this.myTargetClass.getContainingFile());
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, this.affectedFiles, (boolean)true)) {
            return false;
        }
        for (PhpClassMember member : this.mySelectedMembers) {
            if (!(member instanceof Method)) continue;
            conflicts.checkInternalReferences((Method)member);
        }
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(5);
        }
        return new UsageViewDescriptor(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(PhpMoveMemberProcessor.this.mySelectedMembers);
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.move.members.preview.header", new Object[0]);
            }

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                String string = PhpBundle.message("refactoring.make.method.static.references.to.be.changed", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElements";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCodeReferencesText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static Collection<PsiReference> findReferences(PsiElement element) {
        Collection references = ReferencesSearch.search((PsiElement)element).findAll();
        ArrayList<PsiReference> referenceCollection = new ArrayList<PsiReference>(references.size());
        for (PsiReference reference : references) {
            if (!(reference instanceof MemberReference) && !(reference instanceof PhpDocRefReferenceContributor.PhpDocElementReference) && !(reference instanceof PhpCallbackReferenceBase)) continue;
            referenceCollection.add(reference);
        }
        return referenceCollection;
    }

    protected UsageInfo @NotNull [] findUsages() {
        return PhpMoveMemberProcessor.findUsages(this.mySelectedMembers);
    }

    public static UsageInfo @NotNull [] findUsages(Collection<PhpClassMember> members) {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PhpClassMember it : members) {
            Collection<PsiReference> references = PhpMoveMemberProcessor.findReferences((PsiElement)it);
            for (PsiReference reference : references) {
                PsiElement element = reference.getElement();
                result.add(new UsageInfo(element));
            }
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(6);
        }
        return usageInfoArray;
    }

    public static PhpClass getClass(PsiElement element) {
        return (PhpClass)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
    }

    private static void processTraitMembers(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            PhpNamedElement namedElement;
            PhpPsiElement element = (PhpPsiElement)usage.getElement();
            if (!(element instanceof MethodReference) || !((namedElement = (PhpNamedElement)PhpPsiUtil.getParentByCondition((PsiElement)element, false, (Condition<? super PsiElement>)PhpNamedElement.INSTANCEOF)) instanceof PhpTraitUseRule)) continue;
            PhpTraitUseRule rule = (PhpTraitUseRule)namedElement;
            PhpUseList traitUseList = (PhpUseList)PhpPsiUtil.getParentByCondition((PsiElement)namedElement, false, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (traitUseList == null) continue;
            traitUseList.getNode().removeChild(rule.getNode());
        }
    }

    @Override
    protected void performMainRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(7);
        }
        PhpMoveMemberProcessor.performRefactoring(this.myProject, usages, new ArrayList<PhpClassMember>(this.mySelectedMembers), this.myTargetClass, this.myFromClass);
        this.optimizeImports(this.affectedFiles);
        PhpMoveRefactoringUsageCollector.triggerMoveRefactoringFinished(this.myProject, "move.static.members");
    }

    @NotNull
    public static Collection<PsiElement> performRefactoring(Project project, UsageInfo @NotNull [] usages, List<PhpClassMember> members, PhpClass targetClass, PhpClass fromClass) {
        if (usages == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(8);
        }
        return PhpMoveMemberProcessor.performRefactoring(project, usages, members, targetClass, fromClass, true);
    }

    @NotNull
    public static Collection<PsiElement> performRefactoring(Project project, UsageInfo @NotNull [] usages, List<PhpClassMember> members, PhpClass targetClass, PhpClass fromClass, boolean shouldRemoveMethods) {
        if (usages == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(9);
        }
        PhpMoveMemberProcessor.processUsages(project, usages, fromClass, members, targetClass);
        List<PsiElement> list = PhpMoveClassMemberBase.getInstance(targetClass, false).move(members, PhpModifier.Access.PUBLIC, shouldRemoveMethods);
        if (list == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static void processUsages(Project project, UsageInfo @NotNull [] usages, PhpClass fromClass, List<PhpClassMember> members, PhpClass targetClass) {
        if (usages == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(11);
        }
        for (UsageInfo usage : usages) {
            PhpPsiElement arg;
            PsiElement firstChild;
            PsiElement sibling;
            PhpPsiElement usageElement = (PhpPsiElement)usage.getElement();
            if (usageElement == null) continue;
            String name = PhpMoveMemberProcessor.importClassAndGetName(usageElement, members, targetClass.getFQN());
            if (usageElement instanceof PhpDocRef) {
                PhpMoveMemberProcessor.replaceDocReference((PhpDocRef)usageElement, name);
                continue;
            }
            if (!(usageElement instanceof MemberReference) || (sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild = usageElement.getFirstChild(), true)) == null) continue;
            if (firstChild instanceof ParenthesizedExpression && (arg = ((ParenthesizedExpression)firstChild).getArgument()) instanceof NewExpression) {
                ClassReference classReference = ((NewExpression)arg).getClassReference();
                assert (classReference != null);
                Statement newClassStatement = PhpPsiElementFactory.createStatement(project, "new " + classReference.getName() + "();");
                Object elementStatement = PhpPsiUtil.getParentByCondition((PsiElement)usageElement, true, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                if (elementStatement != null) {
                    PsiElement prevStatement = elementStatement.getPrevSibling();
                    elementStatement.getParent().addAfter((PsiElement)newClassStatement, prevStatement);
                }
            }
            if (!PhpPsiUtil.isOfType(sibling, PhpTokenTypes.ARROW) && !PhpPsiUtil.isOfType(sibling, PhpTokenTypes.SCOPE_RESOLUTION)) continue;
            String elementText = usageElement.getText();
            int restTextOffset = sibling.getTextRange().getEndOffset();
            int startOffset = firstChild.getTextRange().getStartOffset();
            String restText = elementText.substring(restTextOffset - startOffset);
            String newReferenceText = elementText.substring(0, restTextOffset - startOffset).replace(firstChild.getText(), name);
            if (PhpPsiUtil.isOfType(sibling, PhpTokenTypes.ARROW)) {
                newReferenceText = newReferenceText.replaceFirst("->", "::");
            }
            usageElement.replace((PsiElement)PhpPsiElementFactory.createFirstFromText(project, MemberReference.class, "<?php " + newReferenceText + restText));
        }
        if (fromClass.isTrait()) {
            PhpMoveMemberProcessor.processTraitMembers(usages);
        }
    }

    @NotNull
    public static String importClassAndGetName(PhpPsiElement usageElement, List<PhpClassMember> members, @NotNull @NlsSafe String targetClassFQN) {
        String importedClassName;
        if (targetClassFQN == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(12);
        }
        if (PhpMoveMemberProcessor.targetCanBeReferencedAsSelf(usageElement, members, targetClassFQN)) {
            return "self";
        }
        if (usageElement instanceof MemberReference && (importedClassName = PhpMoveMemberProcessor.importTargetClassInsteadOfOwnAndGetName((MemberReference)usageElement, targetClassFQN)) != null) {
            String string = importedClassName;
            if (string == null) {
                PhpMoveMemberProcessor.$$$reportNull$$$0(13);
            }
            return string;
        }
        return PhpMoveMemberProcessor.addImportStatementAndGetName(usageElement, PhpGroupUseElement.PhpUseKeyword.CLASS, targetClassFQN);
    }

    public static boolean targetCanBeReferencedAsSelf(PhpPsiElement usageElement, List<PhpClassMember> members, @NotNull @NlsSafe String targetClassFQN) {
        PhpClass containingClass;
        if (targetClassFQN == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(14);
        }
        if ((containingClass = PhpMoveMemberProcessor.getClass((PsiElement)usageElement)) != null && PhpLangUtil.equalsClassNames(containingClass.getFQN(), targetClassFQN)) {
            return true;
        }
        if (usageElement instanceof MemberReference) {
            Method containingMethod = (Method)PhpPsiUtil.getParentByCondition((PsiElement)usageElement, (Condition<? super PsiElement>)Method.INSTANCEOF);
            if (containingClass != null && members.contains(containingMethod) && ((MemberReference)usageElement).getClassReference().getName().equalsIgnoreCase("self")) {
                return true;
            }
        }
        return false;
    }

    public static void replaceDocReference(@NotNull PhpDocRef usageElement, @NotNull String className) {
        PsiElement firstChild;
        PsiElement sibling;
        if (usageElement == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(15);
        }
        if (className == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(16);
        }
        if ((sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild = usageElement.getFirstChild(), true)) == null) {
            return;
        }
        if (PhpPsiUtil.isOfType(firstChild, PhpDocTokenTypes.DOC_IDENTIFIER) && PhpPsiUtil.isOfType(sibling, PhpDocTokenTypes.DOC_STATIC)) {
            PhpMoveMemberProcessor.replaceDocReferenceToOffset(usageElement.getProject(), usageElement, className, firstChild.getTextRange().getLength());
        }
    }

    public static void replaceDocReferenceToOffset(Project project, PhpDocRef ref, String name, int endOffset) {
        String referenceString = ref.getText();
        referenceString = ref.getText().replace(referenceString.substring(0, endOffset), name);
        ref.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocRef.class, "/** @see " + referenceString + "  */\n"));
    }

    @Nullable
    private static String importTargetClassInsteadOfOwnAndGetName(@NotNull MemberReference reference, @NotNull @NlsSafe String targetClassFQN) {
        ClassReference classReference;
        PhpUse targetAliasUse;
        if (reference == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(17);
        }
        if (targetClassFQN == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(18);
        }
        PhpUse phpUse = targetAliasUse = (classReference = (ClassReference)ObjectUtils.tryCast((Object)reference.getClassReference(), ClassReference.class)) != null ? PhpTargetElementEvaluator.getElementByReference((PsiReference)classReference) : null;
        if (targetAliasUse != null) {
            String referenceName = reference.getName();
            boolean aliasReferencedOnlyToMovedMember = PhpCodeInsightUtil.collectReferencesToAlias(targetAliasUse).stream().map(r -> r.getElement().getParent()).allMatch(r -> r instanceof MemberReference && StringUtil.equalsIgnoreCase((CharSequence)((MemberReference)r).getName(), (CharSequence)referenceName));
            if (aliasReferencedOnlyToMovedMember) {
                PhpMoveMemberProcessor.replaceTargetReference(targetAliasUse, PhpLangUtil.toPresentableFQN(targetClassFQN));
                return targetAliasUse.getName();
            }
        }
        return null;
    }

    @NotNull
    public static String addImportStatementAndGetName(@NotNull PhpPsiElement usage, @NotNull PhpGroupUseElement.PhpUseKeyword keyword, String targetFQN) {
        String qualifiedName;
        PhpPsiElement scopeForUseOperator;
        if (usage == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(19);
        }
        if (keyword == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(20);
        }
        if ((scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)usage)) != null && !PhpLangUtil.isFqn(qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, targetFQN))) {
            String string = qualifiedName;
            if (string == null) {
                PhpMoveMemberProcessor.$$$reportNull$$$0(21);
            }
            return string;
        }
        List declarations = PhpCodeInsightUtil.collectImports(scopeForUseOperator).stream().flatMap(use -> StreamEx.of((Object[])use.getDeclarations())).collect(Collectors.toList());
        PhpUse targetUse = (PhpUse)ContainerUtil.find(declarations, d -> PhpLangUtil.equalsClassNames(d.getFQN(), targetFQN) && StringUtil.equals((CharSequence)PhpGroupUseElement.getKeyword(d, null), (CharSequence)keyword.getValue()));
        if (targetUse != null) {
            String string = targetUse.getName();
            if (string == null) {
                PhpMoveMemberProcessor.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (PhpCodeInsightUtil.canImport(scopeForUseOperator, targetFQN, keyword)) {
            PhpAliasImporter.insertUseStatementWithKeyword(StringUtil.nullize((String)keyword.getValue()), targetFQN, null, scopeForUseOperator);
            String string = PhpLangUtil.toShortName(targetFQN);
            if (string == null) {
                PhpMoveMemberProcessor.$$$reportNull$$$0(23);
            }
            return string;
        }
        String nameAlias = PhpReplaceWithAliasIntention.createUniqueClassAliasName(scopeForUseOperator, PhpLangUtil.toShortName(targetFQN), keyword);
        PhpAliasImporter.insertUseStatementWithKeyword(StringUtil.nullize((String)keyword.getValue()), targetFQN, nameAlias, scopeForUseOperator);
        String string = nameAlias;
        if (string == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static void replaceTargetReference(@NotNull PhpUse use, @NotNull String presentableFQN) {
        PhpReference targetReference;
        if (use == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(25);
        }
        if (presentableFQN == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(26);
        }
        if ((targetReference = use.getTargetReference()) != null) {
            targetReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(use.getProject(), presentableFQN));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpMoveMemberDelegate.getRefactoringName();
        if (string == null) {
            PhpMoveMemberProcessor.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedMemberInfos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberProcessor";
                break;
            }
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassFQN";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "performRefactoring";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "importClassAndGetName";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "addImportStatementAndGetName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performMainRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "importClassAndGetName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "targetCanBeReferencedAsSelf";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceDocReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "importTargetClassInsteadOfOwnAndGetName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addImportStatementAndGetName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceTargetReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

