/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Alarm;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpDependencyMemberInfoModel;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.move.MoveToClassChooser;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberConflicts;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDelegate;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveMemberDialog
extends RefactoringDialog {
    public static final String HELP_ID = "refactoring.moveStaticMember";
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.move.member.PhpMoveMemberDialog#";
    private final MoveToClassChooser myMoveToClassChooser;
    protected List<PhpMemberInfo> myMemberInfos;
    protected DependencyMemberInfoModel<PhpClassMember, PhpMemberInfo> myMemberInfoModel;
    @Nullable
    protected PhpMemberSelectionPanel memberSelectionPanel;
    protected PhpClass myFromClass;
    private final Alarm myAlarm;

    public PhpMoveMemberDialog(@NotNull Project project, @NotNull PhpClass fromClazz, @NotNull PhpMemberInfoStorage storage) {
        if (project == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(0);
        }
        if (fromClazz == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(1);
        }
        if (storage == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                PhpMoveMemberDialog.this.myAlarm.cancelAllRequests();
            }
        });
        this.myFromClass = fromClazz;
        List infoList = storage.getClassMemberInfos((PsiElement)fromClazz);
        this.myMemberInfos = new ArrayList<PhpMemberInfo>();
        for (PhpMemberInfo it : infoList) {
            PhpClassMember element = (PhpClassMember)it.getMember();
            if (!element.getModifier().isStatic()) continue;
            this.myMemberInfos.add(it);
        }
        this.myMoveToClassChooser = new MoveToClassChooser(this.getProject(), this.getDisposable(), (Condition<? super PhpClass>)((Condition)aClass -> !aClass.isInterface() || PhpMoveMemberDialog.constantsOnly(this.getSelectedMembers())), PhpBundle.message("refactoring.move.method.label.text.field", new Object[0]));
        this.setTitle(PhpBundle.message("refactoring.move.member.title", new Object[0]));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myAlarm);
        this.init();
    }

    public static boolean constantsOnly(@NotNull Collection<? extends PhpClassMember> members) {
        if (members == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(3);
        }
        return members.stream().allMatch(e -> e instanceof Field && ((Field)e).isConstant());
    }

    public String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY_BASE;
    }

    public String getHelpId() {
        return HELP_ID;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getInfo(this.getProject(), this.myMoveToClassChooser.getClassText());
    }

    @Nullable
    private ValidationInfo getInfo(@NotNull Project project, @NotNull String destClass) {
        Collection<PhpClass> classes;
        String message;
        if (project == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(4);
        }
        if (destClass == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(5);
        }
        if ((message = this.validateAllInfo(classes = PhpMoveMemberDialog.getClasses(project, destClass), true)) != null) {
            return new ValidationInfo(message);
        }
        return super.doValidate();
    }

    @Nullable
    @NlsContexts.DialogMessage
    protected String validateAllInfo(@NotNull Collection<PhpClass> classes, boolean inTimeValidation) {
        if (classes == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(6);
        }
        return PhpMoveMemberConflicts.getValidationResult(classes, this.myMoveToClassChooser.getClassText(), this.myFromClass, this.getSelectedMembers(), inTimeValidation);
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String validateClassNames(@NotNull PhpClass fromClass, @NotNull String destClassText, @NotNull Collection<? extends PhpClass> classes) {
        if (fromClass == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(7);
        }
        if (destClassText == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(8);
        }
        if (classes == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(9);
        }
        if (classes.size() > 1) {
            return PhpBundle.message("refactoring.move.members.there.are.several.classes.with.specified.name", destClassText);
        }
        if (classes.size() == 0) {
            if (destClassText.length() != 0) {
                return PhpBundle.message("refactoring.move.members.cannot.find.target.class", destClassText);
            }
            return null;
        }
        if (PhpLangUtil.equalsClassNames(classes.iterator().next().getFQN(), fromClass.getFQN())) {
            return RefactoringBundle.message((String)"source.and.destination.classes.should.be.different");
        }
        return null;
    }

    protected void doAction() {
        Collection<PhpClass> classesForFQN = PhpMoveMemberDialog.getClasses(this.getProject(), this.myMoveToClassChooser.getClassText());
        String message = this.validateAllInfo(classesForFQN, false);
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.getRefactoringName(), (String)message, (String)HELP_ID, (Project)this.myProject);
            return;
        }
        if (this.myMoveToClassChooser.getClassText().isEmpty()) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.getRefactoringName(), (String)PhpBundle.message("refactoring.move.members.is.not.a.valid.class.name", ""), (String)HELP_ID, (Project)this.myProject);
            return;
        }
        PhpClass targetClass = classesForFQN.iterator().next();
        assert (targetClass != null);
        PhpMoveMemberProcessor processor = new PhpMoveMemberProcessor(this.getProject(), this.myFromClass, targetClass, this.getSelectedMembers());
        this.invokeRefactoring(processor);
    }

    public void doCancelAction() {
        PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(this.myProject, "move.static.members");
        super.doCancelAction();
    }

    @NotNull
    public Collection<PhpClassMember> getSelectedMembers() {
        ArrayList<PhpClassMember> list = new ArrayList<PhpClassMember>(this.myMemberInfos.size());
        for (PhpMemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled((MemberInfoBase)info)) continue;
            list.add((PhpClassMember)info.getMember());
        }
        ArrayList<PhpClassMember> arrayList = list;
        if (arrayList == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    protected DependencyMemberInfoModel<PhpClassMember, PhpMemberInfo> createMemberInfoModel() {
        return new PhpDependencyMemberInfoModel(this.myFromClass);
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myMoveToClassChooser.createPanel();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.memberSelectionPanel = new PhpMemberSelectionPanel(this.getMembersBorderTitle(), this.myMemberInfos, null);
        this.myMemberInfoModel = this.createMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        panel2.add((Component)this.memberSelectionPanel, "Center");
        return panel2;
    }

    @NotNull
    private static Collection<PhpClass> getClasses(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(11);
        }
        if (text == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(12);
        }
        PhpIndex instance = PhpIndex.getInstance((Project)project);
        ArrayList<PhpClass> classesByFQN = new ArrayList<PhpClass>();
        classesByFQN.addAll(instance.getClassesByFQN(text));
        classesByFQN.addAll(instance.getInterfacesByFQN(text));
        ArrayList<PhpClass> arrayList = classesByFQN;
        if (arrayList == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myMoveToClassChooser.getPreferredFocusedComponent();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NlsContexts.Separator
    protected String getMembersBorderTitle() {
        return PhpBundle.message("refactoring.move.members.to.be.moved", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destClass";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destClassText";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMembers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "constantsOnly";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateAllInfo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateClassNames";
                break;
            }
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

