/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.core.CoreBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDialog;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveMemberDelegate
extends MoveHandlerDelegate {
    static final String MOVE_STATIC_MEMBERS_ID = "move.static.members";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            PhpClassMember member = PhpMoveMemberDelegate.extractMemberToMove(element);
            if (member != null && PhpMoveMemberDelegate.available((PsiElement)member)) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return targetElement instanceof PhpClass && !((PhpClass)targetElement).isAnonymous();
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        Set preselectedMembers = StreamEx.of((Object[])elements).select(PhpClassMember.class).toSet();
        if (preselectedMembers.isEmpty() || elements.length != preselectedMembers.size()) {
            return;
        }
        PhpMoveMemberDelegate.doMoveInner(project, preselectedMembers);
    }

    private static void doMoveInner(@NotNull Project project, @NotNull Set<PhpClassMember> preselectedMembers) {
        PhpClass fromClass;
        if (project == null) {
            PhpMoveMemberDelegate.$$$reportNull$$$0(0);
        }
        if (preselectedMembers == null) {
            PhpMoveMemberDelegate.$$$reportNull$$$0(1);
        }
        if ((fromClass = ((PhpClassMember)ContainerUtil.getFirstItem(preselectedMembers)).getContainingClass()) != null) {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)fromClass)) {
                return;
            }
            PhpMemberInfoStorage memberInfoStorage = new PhpMemberInfoStorage(fromClass);
            for (PhpMemberInfo memberIt : memberInfoStorage.getClassMemberInfos((PsiElement)fromClass)) {
                if (!preselectedMembers.contains(memberIt.getMember())) continue;
                memberIt.setChecked(true);
            }
            PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(project, MOVE_STATIC_MEMBERS_ID);
            new PhpMoveMemberDialog(project, fromClass, memberInfoStorage).show();
        }
    }

    protected static boolean available(PsiElement element) {
        if (!(element instanceof PhpClassMember)) {
            return false;
        }
        PhpClassMember member = (PhpClassMember)element;
        return member.getModifier().isStatic() && !PhpMoveMemberDelegate.isAbstractAndStatic(member);
    }

    private static boolean isAbstractAndStatic(PhpClassMember member) {
        return member instanceof Method && ((Method)member).isStatic() && ((Method)member).isAbstract();
    }

    @Nullable
    private static PhpClassMember extractMemberToMove(@NotNull PsiElement element) {
        if (element == null) {
            PhpMoveMemberDelegate.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiFileSystemItem || element.getLanguage() != PhpLanguage.INSTANCE) {
            return null;
        }
        PhpClassMember member = (PhpClassMember)ObjectUtils.tryCast((Object)element, PhpClassMember.class);
        if (member != null) {
            return member;
        }
        Field field = (Field)ObjectUtils.tryCast((Object)element.getPrevSibling(), Field.class);
        if (field != null) {
            return field;
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS)) {
            return (PhpClassMember)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)Field.INSTANCEOF);
        }
        return null;
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiFile file = element.getContainingFile();
        PhpClassMember method = PhpMoveMemberDelegate.extractMemberToMove(element);
        if (method != null && PhpMoveMemberDelegate.available((PsiElement)method)) {
            if (!file.isWritable()) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)PhpMoveMemberDelegate.getRefactoringName(), null);
                return true;
            }
            PhpMoveMemberDelegate.doMoveInner(project, ContainerUtil.set((Object[])new PhpClassMember[]{method}));
            return true;
        }
        return false;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpMoveMemberDelegate.$$$reportNull$$$0(3);
        }
        return PhpBundle.message("refactoring.move.member.action.name", new Object[0]);
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            PhpMoveMemberDelegate.$$$reportNull$$$0(4);
        }
        return language == PhpLanguage.INSTANCE;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return PhpBundle.message("refactoring.move.member.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectedMembers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doMoveInner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractMemberToMove";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

