/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.function;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticProcessor;
import com.jetbrains.php.refactoring.move.function.PhpMoveFunctionDelegate;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveFunctionProcessor
extends PhpBaseRefactoringProcessor {
    private static final String ARRAY = "array(\"%s\", \"%s\")";
    @NotNull
    private final Collection<Function> myFunctions;
    private final PhpClass myTargetClass;

    public PhpMoveFunctionProcessor(@NotNull Collection<Function> functions, PhpClass targetClass) {
        if (functions == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(0);
        }
        super(targetClass.getProject());
        this.myFunctions = functions;
        this.myTargetClass = targetClass;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(1);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.move.function.title", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/move/function/PhpMoveFunctionProcessor$1", "getElements"));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = (UsageInfo[])this.usages((SearchScope)GlobalSearchScope.allScope((Project)this.myTargetClass.getProject())).toArray(UsageInfo.class);
        if (usageInfoArray == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @NotNull
    private StreamEx<UsageInfo> usages(SearchScope scope) {
        StreamEx streamEx = StreamEx.of(this.myFunctions).flatMap(f -> ReferencesSearch.search((PsiElement)f, (SearchScope)scope).findAll().stream()).map(UsageInfo::new);
        if (streamEx == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(3);
        }
        return streamEx;
    }

    @Override
    protected void performMainRefactoring(UsageInfo[] usages) {
        this.moveFunctionsAsMethodsToClass(usages);
    }

    public void moveFunctionsAsMethodsToClass(UsageInfo[] usages) {
        HashSet usagesCollection = ContainerUtil.newHashSet((Object[])usages);
        THashSet affectedFiles = new THashSet();
        for (UsageInfo usageInfo : usages) {
            affectedFiles.add(usageInfo.getFile());
            PsiElement usageInfoElement = usageInfo.getElement();
            this.qualifyFunctionReferencesWithFqn(usageInfoElement);
        }
        for (Function function : this.myFunctions) {
            this.copyFunctionToTargetClassAsMethod(function);
        }
        SmartList possibleReferencesToMovedFunctions = new SmartList();
        this.usages((SearchScope)new LocalSearchScope((PsiElement)this.myTargetClass.getContainingFile())).forEach(((Collection)possibleReferencesToMovedFunctions)::add);
        usagesCollection.addAll(possibleReferencesToMovedFunctions);
        for (Function function : this.myFunctions) {
            this.replaceUsagesWithMethodReference(usagesCollection, function);
            PhpMoveClassMemberBase.removeFunctionWithPhpDoc(function);
        }
        this.optimizeImports((Collection<PsiFile>)affectedFiles);
    }

    private void qualifyFunctionReferencesWithFqn(PsiElement usageInfoElement) {
        FunctionReference newFunctionReference;
        PhpUse use;
        FunctionReference functionReference;
        PsiElement function;
        if (usageInfoElement instanceof FunctionReference && (function = (functionReference = (FunctionReference)usageInfoElement).resolve()) instanceof Function && (use = (PhpUse)PhpPsiUtil.getParentByCondition((PsiElement)functionReference, (Condition<? super PsiElement>)PhpUse.INSTANCEOF)) == null && this.myFunctions.contains(function) && functionReference.getFQN() != null && (newFunctionReference = PhpMoveFunctionProcessor.createFunctionCall(this.myProject, functionReference.getFQN(), functionReference, true)) != null) {
            functionReference.replace((PsiElement)newFunctionReference);
        }
    }

    private void copyFunctionToTargetClassAsMethod(Function function) {
        Method method = PhpMoveClassMemberBase.PhpMoveClassMember.copyAsMethodToTargetClass(function, null, null, this.myTargetClass, Collections.emptyList());
        this.importClassReferences(function, method);
        method = (Method)method.replace((PsiElement)PhpMakeStaticProcessor.makeStaticMethod(this.myProject, method));
        PhpChangeSignatureUsageProcessor.updateMethodVisibility(method, PhpModifier.Access.PUBLIC.toString());
    }

    private void importClassReferences(Function movedFunction, Method copiedMethod) {
        PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();
        referenceResolver.processElement((PsiElement)movedFunction);
        PhpPsiElement operator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myTargetClass);
        if (operator != null) {
            referenceResolver.importReferences(operator, Collections.singletonList(copiedMethod));
        }
    }

    private void replaceUsagesWithMethodReference(@NotNull Collection<UsageInfo> usages, Function function) {
        if (usages == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(4);
        }
        String functionName = function.getName();
        SmartList usesToDelete = new SmartList();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (!PhpMoveFunctionProcessor.isReferenceToFunction(element, function)) continue;
            PhpUse use = (PhpUse)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpUse.INSTANCEOF);
            if (use != null) {
                usesToDelete.add(use);
                continue;
            }
            String className = PhpMoveMemberProcessor.importClassAndGetName((PhpPsiElement)element, Collections.emptyList(), this.myTargetClass.getFQN());
            if (element instanceof PhpDocRef) {
                PsiElement identifier = PhpPsiUtil.getChildOfType(element, PhpDocTokenTypes.DOC_IDENTIFIER);
                if (identifier == null) continue;
                String functionReferenceName = (className.equals("self") ? this.myTargetClass.getName() : className) + "::" + functionName;
                PhpMoveMemberProcessor.replaceDocReferenceToOffset(this.myProject, (PhpDocRef)element, functionReferenceName, identifier.getStartOffsetInParent() + identifier.getTextLength());
                continue;
            }
            if (element instanceof FunctionReference) {
                FunctionReference newFunctionReference = PhpMoveFunctionProcessor.createFunctionCall(this.myProject, className + "::" + functionName, (FunctionReference)element, false);
                if (newFunctionReference == null) continue;
                element.replace((PsiElement)newFunctionReference);
                continue;
            }
            if (!(element instanceof StringLiteralExpression)) continue;
            this.refactorCallbackReference(function, (StringLiteralExpression)element);
        }
        usesToDelete.forEach(PhpCodeEditUtil::deleteUse);
    }

    private void refactorCallbackReference(Function function, StringLiteralExpression callbackReference) {
        callbackReference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(this.myProject, ArrayCreationExpression.class, String.format(ARRAY, this.myTargetClass.getFQN(), function.getName())));
    }

    private static boolean isReferenceToFunction(PsiElement element, Function function) {
        if (element instanceof PhpDocRef || element instanceof StringLiteralExpression) {
            return ContainerUtil.exists((Object[])element.getReferences(), r -> r.isReferenceTo((PsiElement)function));
        }
        return element instanceof PhpReference && ((PhpReference)element).isReferenceTo((PsiElement)function);
    }

    @Nullable
    public static FunctionReference createFunctionCall(@NotNull Project project, @NotNull String replacingIdentifierText, @NotNull FunctionReference functionCall, boolean createFunctionCall) {
        ASTNode nameNode;
        if (project == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(5);
        }
        if (replacingIdentifierText == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(6);
        }
        if (functionCall == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(7);
        }
        if ((nameNode = functionCall.getNameNode()) == null) {
            return null;
        }
        int endOffset = nameNode.getTextRange().getEndOffset();
        String newReferenceText = replacingIdentifierText + functionCall.getText().substring(endOffset - functionCall.getTextRange().getStartOffset());
        if (createFunctionCall) {
            return PhpPsiElementFactory.createFunctionReference(project, newReferenceText);
        }
        return PhpPsiElementFactory.createMethodReference(project, newReferenceText);
    }

    @Override
    protected boolean forceOptimizeImports() {
        return true;
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpMoveFunctionDelegate.getRefactoringNameText();
        if (string == null) {
            PhpMoveFunctionProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/function/PhpMoveFunctionProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacingIdentifierText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/function/PhpMoveFunctionProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "usages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceUsagesWithMethodReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

