/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.function;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.PhpMoveDelegateBase;
import com.jetbrains.php.refactoring.move.function.PhpMoveFunctionProcessor;
import com.jetbrains.php.refactoring.move.function.PhpMoveFunctionToClassDialog;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import java.util.Collection;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class PhpMoveFunctionDelegate
extends PhpMoveDelegateBase {
    private static final String MOVE_FUNCTION_ID = "move.function";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (PhpMoveFunctionDelegate.canMoveElement(element)) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    @Override
    public String getRefactoringName() {
        return PhpMoveFunctionDelegate.getRefactoringNameText();
    }

    public boolean isValidTarget(@Nullable PsiElement targetElement, PsiElement[] sources) {
        return targetElement instanceof PhpClass && !((PhpClass)targetElement).isAnonymous();
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 0 || !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)elements[0])) {
            return;
        }
        Collection functions = (Collection)StreamEx.of((Object[])elements).select(Function.class).collect(Collectors.toList());
        if (!functions.isEmpty() && functions.size() == elements.length) {
            PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(project, MOVE_FUNCTION_ID);
            PhpMoveFunctionToClassDialog dialog = new PhpMoveFunctionToClassDialog(functions);
            if (dialog.showAndGet()) {
                PhpClass targetClass = dialog.getTargetClass();
                if (targetClass != null) {
                    new PhpMoveFunctionProcessor(functions, targetClass).run();
                    PhpMoveRefactoringUsageCollector.triggerMoveRefactoringFinished(project, MOVE_FUNCTION_ID);
                }
            } else {
                PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(project, MOVE_FUNCTION_ID);
            }
        }
    }

    private static boolean canMoveElement(@Nullable PsiElement element) {
        return element instanceof Function && !(element instanceof Method) && !((Function)element).isClosure();
    }

    @Nls
    public static String getRefactoringNameText() {
        return PhpBundle.message("refactoring.move.function.title", new Object[0]);
    }
}

