/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.constant;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.PhpMoveDelegateBase;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantDialog;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantProcessor;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import java.util.Collection;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveFileConstantDelegate
extends PhpMoveDelegateBase {
    private static final String MOVE_FILE_CONSTANT_ID = "move.file.constant";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (element instanceof Constant) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    @Override
    public String getRefactoringName() {
        return PhpMoveFileConstantDelegate.getRefactoringNameText();
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 0 || !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)elements[0])) {
            return;
        }
        Collection constants = (Collection)StreamEx.of((Object[])elements).select(Constant.class).collect(Collectors.toList());
        if (!constants.isEmpty() && constants.size() == elements.length) {
            for (Constant constant : constants) {
                if (PhpMoveFileConstantDelegate.checkHasAllowedConstantValue(project, constant, null)) continue;
                return;
            }
            PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(project, MOVE_FILE_CONSTANT_ID);
            PhpMoveFileConstantDialog dialog = new PhpMoveFileConstantDialog(constants);
            if (dialog.showAndGet()) {
                PhpClass targetClass = dialog.getTargetClass();
                if (targetClass != null) {
                    new PhpMoveFileConstantProcessor(constants, targetClass).run();
                    PhpMoveRefactoringUsageCollector.triggerMoveRefactoringFinished(project, MOVE_FILE_CONSTANT_ID);
                }
            } else {
                PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(project, MOVE_FILE_CONSTANT_ID);
            }
        }
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        if (element instanceof Constant && !PhpMoveFileConstantDelegate.checkHasAllowedConstantValue(project, (Constant)element, editor)) {
            return true;
        }
        return super.tryToMove(element, project, dataContext, reference, editor);
    }

    public static boolean checkHasAllowedConstantValue(@NotNull Project project, @NotNull Constant constant, @Nullable Editor editor) {
        PsiElement value;
        if (project == null) {
            PhpMoveFileConstantDelegate.$$$reportNull$$$0(0);
        }
        if (constant == null) {
            PhpMoveFileConstantDelegate.$$$reportNull$$$0(1);
        }
        if ((value = constant.getValue()) != null && !PhpCodeValidationUtil.isAllowedAsConstantValue(value)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PhpMoveFileConstantDelegate.getNotAllowedConstantValueMessage(), (String)PhpMoveFileConstantDelegate.getRefactoringNameText(), null);
            return false;
        }
        return true;
    }

    @Nls
    private static String getNotAllowedConstantValueMessage() {
        return PhpBundle.message("annotation.expression.is.not.allowed.as.class.constant.value", new Object[0]);
    }

    @Nls
    public static String getRefactoringNameText() {
        return PhpBundle.message("refactoring.move.constant.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "constant";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/refactoring/move/constant/PhpMoveFileConstantDelegate";
        objectArray[2] = "checkHasAllowedConstantValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

