/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MoveToClassChooser {
    private final EditorTextField destClassTextField;
    private final JBLabel myDestClassHintLabel;
    private final JLabel myTextFieldLabel;

    public MoveToClassChooser(Project project, Disposable disposable, Condition<? super PhpClass> classFilter, @Nls String labelText) {
        this.destClassTextField = new EditorTextField("", project, (FileType)FileTypes.PLAIN_TEXT);
        this.myTextFieldLabel = new JLabel(labelText);
        this.myDestClassHintLabel = new JBLabel(PhpBundle.message("0.completion.shortcut", "class reference", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myDestClassHintLabel);
        PhpCompletionUtil.installClassInterfaceCompletion(this.destClassTextField, null, disposable, classFilter, new String[0]);
    }

    public JPanel createPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myTextFieldLabel, "North");
        panel2.add((Component)this.destClassTextField, "Center");
        this.myTextFieldLabel.setLabelFor((Component)this.destClassTextField);
        panel2.add((Component)this.myDestClassHintLabel, "South");
        return panel2;
    }

    @NotNull
    public String getClassText() {
        String string = this.destClassTextField.getText();
        if (string == null) {
            MoveToClassChooser.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.destClassTextField;
        if (editorTextField == null) {
            MoveToClassChooser.$$$reportNull$$$0(1);
        }
        return editorTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/refactoring/move/MoveToClassChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

