/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.makeStatic;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpMemberDocVisitor;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticParameterInfo;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticSettings;
import com.jetbrains.php.refactoring.move.member.PhpAbstractMemberConflicts;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpMakeStaticConflicts
extends PhpAbstractMemberConflicts {
    final Method myMethod;

    public PhpMakeStaticConflicts(Method method) {
        this.myMethod = method;
    }

    public void checkOverriding(Method method) {
        Ref ans = new Ref();
        ans.set((Object)false);
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (classMember, subClass, baseClass) -> {
            ans.set((Object)true);
            return false;
        });
        if (((Boolean)ans.get()).booleanValue()) {
            String functionText = PhpFunctionCodeGenerator.CALL.generate((Function)method);
            this.myConflicts.putValue((Object)method, (Object)PhpBundle.message("refactoring.make.method.static.method.is.overridden", functionText));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkSettings(PhpMakeStaticSettings settings) {
        if (settings.isObjectNeeded() && !settings.isPassedByObject()) {
            List<MemberReference> calls = settings.getCalls();
            for (MemberReference memberReference : calls) {
                this.myConflicts.putValue((Object)memberReference, (Object)PhpBundle.message("refactoring.make.method.static.dynamic.method.call.found", memberReference.getText()));
            }
            for (Variable variable : settings.getData().getVariables()) {
                this.myConflicts.putValue((Object)variable, (Object)PhpBundle.message("refactoring.make.method.static.this.found", new Object[0]));
            }
        }
        if (!settings.isPassedByObject()) {
            void var4_9;
            PhpMakeStaticParameterInfo[] phpMakeStaticParameterInfoArray = settings.getData().getParameterInfo();
            int n = phpMakeStaticParameterInfoArray.length;
            boolean bl = false;
            while (var4_9 < n) {
                PhpMakeStaticParameterInfo info = phpMakeStaticParameterInfoArray[var4_9];
                if (!settings.isPassedByFields() || !info.passAsParameter) {
                    for (FieldReference fieldRef : info.fieldReferences) {
                        this.myConflicts.putValue((Object)fieldRef, (Object)PhpBundle.message("refactoring.make.method.static.object.is.needed", RefactoringUIUtil.getDescription((PsiElement)this.myMethod, (boolean)false), info.getName()));
                    }
                }
                ++var4_9;
            }
        }
    }

    public void checkUsagesForConflicts(UsageInfo @NotNull [] usages, PhpMakeStaticSettings settings) {
        if (usages == null) {
            PhpMakeStaticConflicts.$$$reportNull$$$0(0);
        }
        for (UsageInfo it : usages) {
            PsiElement usageElement = it.getElement();
            if (!(usageElement instanceof MemberReference)) continue;
            MemberReference memberReference = (MemberReference)usageElement;
            Method usingMethod = (Method)PhpPsiUtil.getParentByCondition((PsiElement)memberReference, (Condition<? super PsiElement>)Method.INSTANCEOF);
            if (usingMethod != null && usingMethod.isStatic()) {
                this.myConflicts.putValue((Object)memberReference, (Object)PhpBundle.message("refactoring.make.method.static.method.calls.found.in.static.context", new Object[0]));
            }
            if (!settings.isPassedByFields()) continue;
            for (PhpMakeStaticParameterInfo info : settings.getSelectedParameterInfos()) {
                PhpClass clazz;
                if (!info.passAsParameter) continue;
                PhpClass containingClass = settings.getMethod().getContainingClass();
                if (info.field.getModifier().isPrivate() && (clazz = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)memberReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != containingClass) {
                    this.myConflicts.putValue((Object)info.field, (Object)PhpBundle.message("refactoring.make.method.static.private.field.is.not.accessible", RefactoringUIUtil.getDescription((PsiElement)info.field, (boolean)false)));
                }
                if (!info.field.getModifier().isProtected() || (clazz = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)memberReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && (containingClass == null || PhpClassHierarchyUtils.isSuperClass((PhpClass)containingClass, (PhpClass)clazz, (boolean)true) || containingClass == clazz)) continue;
                this.myConflicts.putValue((Object)info.field, (Object)PhpBundle.message("refactoring.make.method.static.protected.field.is.not.accessible", RefactoringUIUtil.getDescription((PsiElement)info.field, (boolean)false)));
            }
        }
    }

    public void checkInternalReferences(Method method, final PhpMakeStaticSettings settings) {
        PhpDocComment comment = method.getDocComment();
        if (comment != null) {
            comment.accept((PsiElementVisitor)new PhpMemberDocVisitor((MultiMap<PsiElement, String>)this.myConflicts));
        }
        method.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFieldReference(@NotNull FieldReference fieldReference) {
                if (fieldReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!settings.isPassedByObject() && fieldReference.isWriteAccess()) {
                    PhpMakeStaticConflicts.this.getConflicts().putValue((Object)fieldReference, (Object)PhpBundle.message("refactoring.make.method.static.writeAccess", fieldReference.getText()));
                }
                PhpMakeStaticConflicts.this.processMemberReference((MemberReference)fieldReference);
                super.visitPhpFieldReference(fieldReference);
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                PhpMakeStaticConflicts.this.processMemberReference((MemberReference)constantReference);
                super.visitPhpClassConstantReference(constantReference);
            }

            public void visitPhpClassReference(ClassReference constantReference) {
                PhpMakeStaticConflicts.this.processClassReference(constantReference);
                super.visitPhpClassReference(constantReference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                PhpMakeStaticConflicts.this.processMemberReference((MemberReference)reference);
                super.visitPhpMethodReference(reference);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldReference", "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticConflicts$1", "visitPhpFieldReference"));
            }
        });
    }

    private void processMemberReference(@NotNull MemberReference reference) {
        PsiElement firstChild;
        if (reference == null) {
            PhpMakeStaticConflicts.$$$reportNull$$$0(1);
        }
        PsiElement resolvedMember = reference.resolve();
        PsiElement lastChild = reference.getLastChild();
        if (resolvedMember == null && PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.kwCLASS) && (firstChild = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.kwSTATIC)) != null && this.getConflicts().get((Object)firstChild).isEmpty()) {
            this.getConflicts().putValue((Object)PhpPsiUtil.getChildOfType(firstChild, PhpTokenTypes.kwSTATIC), (Object)PhpBundle.message("refactoring.move.members.late.static.binding.detected", reference.getText(), RefactoringUIUtil.getDescription((PsiElement)reference, (boolean)true)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticConflicts";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUsagesForConflicts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processMemberReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

