/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceVariable;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableDialog;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariablePresenter;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableSettings;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpVariableInplaceIntroducer;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceVariableHandler
extends PhpIntroduceBaseHandler<PhpIntroduceVariableSettings, PhpIntroduceVariablePresenter> {
    protected static final Logger LOG = Logger.getInstance(PhpIntroduceVariableHandler.class);

    @NotNull
    public static Statement getVariableDeclaration(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        return PhpIntroduceVariableHandler.getVariableDeclaration(introduceContext, settings, introduceContext.getElementDeclarationText());
    }

    @NotNull
    public static Statement getVariableDeclaration(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings, String elementDeclarationText) {
        StringBuilder assignBuilder = new StringBuilder();
        assignBuilder.append("$");
        assignBuilder.append(settings.getName());
        assignBuilder.append("=");
        assignBuilder.append(elementDeclarationText);
        assignBuilder.append(";");
        assignBuilder.append("\n");
        Statement statement = PhpPsiElementFactory.createStatement(introduceContext.getProject(), assignBuilder.toString());
        if (statement == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        return statement;
    }

    @NotNull
    private static PsiElement getNewExpressionForOccurrences(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        Variable variable = PhpPsiElementFactory.createVariable(introduceContext.getProject(), settings.getName(), true);
        if (variable == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        return variable;
    }

    @NotNull
    public static PsiElement getNewExpressionForOriginalElement(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        if (introduceContext.isPhysical() || introduceContext.getPhysicalElement() instanceof NewExpression) {
            return PhpIntroduceVariableHandler.getNewExpressionForOccurrences(introduceContext, settings);
        }
        if (introduceContext.getPhysicalElement() instanceof BinaryExpression) {
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoBinaryExpression((BinaryExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(2);
            }
            return phpPsiElement;
        }
        if (PhpPsiUtil.isOfType(introduceContext.getPhysicalElement(), PhpElementTypes.STRING)) {
            if (settings.isEmbedVariable()) {
                PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoStringByEmbeding((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
                if (phpPsiElement == null) {
                    PhpIntroduceVariableHandler.$$$reportNull$$$0(3);
                }
                return phpPsiElement;
            }
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoStringByConcatenation((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(4);
            }
            return phpPsiElement;
        }
        if (PhpPsiUtil.isOfType(introduceContext.getPhysicalElement(), PhpElementTypes.HEREDOC)) {
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoHeredoc((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(5);
            }
            return phpPsiElement;
        }
        assert (false);
        if (null == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Nullable
    private static Statement getParentStatement(@NotNull PsiElement element, boolean strict) {
        if (element == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(7);
        }
        for (PsiElement curElement = strict ? element.getParent() : element; curElement != null; curElement = curElement.getParent()) {
            if (!(curElement instanceof Statement) || curElement instanceof ElseIf || curElement instanceof Include) continue;
            return (Statement)curElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement isDeleteSelf(@NotNull PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        IElementType grandParentNodeType;
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(8);
        }
        if (!introduceContext.isPhysical() || settings.isReplaceAllOccurrences()) {
            return null;
        }
        PsiElement anchor = introduceContext.getPhysicalElement();
        PsiElement parent = anchor.getParent();
        IElementType parentNodeType = PhpIntroduceVariableHandler.getElementType(parent);
        IElementType iElementType = grandParentNodeType = parent == null ? null : PhpIntroduceVariableHandler.getElementType(parent.getParent());
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentNodeType)) {
            return anchor;
        }
        if (PhpElementTypes.STATEMENT == parentNodeType && PhpElementTypes.ANY_GROUP_STATEMENT.contains(grandParentNodeType)) {
            return parent;
        }
        return null;
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        ASTNode node = element.getNode();
        return node == null ? null : node.getElementType();
    }

    public static void replaceOccurrences(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings, PsiElement expressionForOriginalElement) {
        if (settings.isReplaceAllOccurrences()) {
            PsiElement expressionForOccurrences = introduceContext.isPhysical() ? expressionForOriginalElement : PhpIntroduceVariableHandler.getNewExpressionForOccurrences(introduceContext, settings);
            for (PsiElement occurrence : introduceContext.getOccurrences()) {
                occurrence.replace(expressionForOccurrences);
            }
        }
    }

    @Override
    @Nls
    public String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.variable.name", new Object[0]);
    }

    @Override
    protected String getFeatureId() {
        return "refactoring.introduceVariable";
    }

    @Override
    @Nullable
    protected PsiElement findScope(@NotNull PsiElement element) {
        PsiNamedElement scope;
        if (element == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(9);
        }
        if ((scope = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PhpClass.class, PhpFile.class, Function.class, Method.class, PhpNamespace.class})) instanceof PhpClass) {
            return null;
        }
        return scope;
    }

    @Override
    protected boolean isSupportedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(10);
        }
        return !PhpPsiUtil.isOfType(expression, PhpElementTypes.HASH_ARRAY_ELEMENT);
    }

    @Override
    protected boolean isSupportedScope(@Nullable PsiElement scope, @NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(11);
        }
        return scope != null;
    }

    @Override
    protected boolean isSupportedContext(@NotNull PsiElement context, @NotNull PsiElement logicalExpression, @NotNull PsiElement physicalExpression) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(12);
        }
        if (logicalExpression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(13);
        }
        if (physicalExpression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(14);
        }
        if (context instanceof Parameter) {
            return false;
        }
        if (context instanceof Constant) {
            return context instanceof PhpDefine;
        }
        return PhpPsiUtil.getParentByCondition(physicalExpression, (Condition<? super PsiElement>)((Condition)PhpAttribute.class::isInstance)) == null;
    }

    @Override
    protected MultiMap<PsiElement, PsiElement> getOccurrences(@NotNull PsiElement scope, @NotNull PsiElement sample, boolean isPhysical, @NotNull PsiElement sampleContext, @NotNull TextRange elementRange, @NotNull PhpIntroduceContext introduceContext) {
        if (scope == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(15);
        }
        if (sample == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(16);
        }
        if (sampleContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(17);
        }
        if (elementRange == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(18);
        }
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(19);
        }
        PhpIntroduceBaseHandler.OccurrencesCollector collector = new PhpIntroduceBaseHandler.OccurrencesCollector(scope, sample, isPhysical, sampleContext, elementRange){

            @Override
            protected boolean processContext(PsiElement element) {
                return !(element instanceof PhpClass) && !(element instanceof Function) && !(element instanceof Field);
            }
        };
        return collector.getOccurrences();
    }

    @Override
    @NotNull
    protected PhpIntroduceVariablePresenter getPresenter(PhpIntroduceContext introduceContext) {
        return new PhpIntroduceVariablePresenter(new PhpIntroduceVariableDialog(introduceContext.getProject()), this, introduceContext);
    }

    @Nullable
    public static PsiElement findAnchor(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings, PsiElement expressionForOriginalElement) {
        Statement anchor;
        block7: {
            Statement commonStatement;
            if (settings.isReplaceAllOccurrences()) {
                PsiElement[] introducedExpressions = (PsiElement[])ArrayUtil.append((Object[])introduceContext.getOccurrences(), (Object)introduceContext.getPhysicalElement());
                commonStatement = PhpIntroduceVariableHandler.getParentStatement(PsiTreeUtil.findCommonParent((PsiElement[])introducedExpressions), false);
            } else {
                commonStatement = PhpIntroduceVariableHandler.getParentStatement(introduceContext.getPhysicalElement(), false);
            }
            if (commonStatement instanceof GroupStatement) {
                PsiElement[] introducedExpressions = (PsiElement[])ArrayUtil.append((Object[])introduceContext.getOccurrences(), (Object)introduceContext.getPhysicalElement());
                for (anchor = commonStatement.getFirstPsiChild(); anchor != null; anchor = anchor.getNextPsiSibling()) {
                    for (PsiElement curExpression : introducedExpressions) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)anchor, (PsiElement)curExpression, (boolean)false)) {
                            continue;
                        }
                        break block7;
                    }
                }
            } else {
                anchor = commonStatement;
            }
        }
        return anchor != null ? PhpIntroduceVariableHandler.replaceAnchor(introduceContext, expressionForOriginalElement, (PsiElement)anchor) : null;
    }

    @Override
    @Nullable
    public PhpIntroduceBaseHandler.PhpIntroduceResult doRefactoring(@NotNull PhpIntroduceContext introduceContext, @NotNull PhpIntroduceVariableSettings settings) {
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(20);
        }
        if (settings == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(21);
        }
        super.doRefactoring(introduceContext, settings);
        PsiElement deleteSelf = PhpIntroduceVariableHandler.isDeleteSelf(introduceContext, settings);
        Statement assignStatement = PhpIntroduceVariableHandler.getVariableDeclaration(introduceContext, settings);
        if (deleteSelf != null) {
            return new PhpIntroduceBaseHandler.PhpIntroduceResult(deleteSelf.replace((PsiElement)assignStatement), null, null);
        }
        PsiElement expressionForOriginalElement = PhpIntroduceVariableHandler.getNewExpressionForOriginalElement(introduceContext, settings);
        PsiElement anchor = PhpIntroduceVariableHandler.findAnchor(introduceContext, settings, expressionForOriginalElement);
        if (anchor != null) {
            Statement result = PhpCodeEditUtil.putStatementBefore(anchor, assignStatement);
            PhpIntroduceVariableHandler.replaceOccurrences(introduceContext, settings, expressionForOriginalElement);
            return new PhpIntroduceBaseHandler.PhpIntroduceResult((PsiElement)result, null, null);
        }
        this.showErrorHint(introduceContext.getProject(), introduceContext.getEditor(), PhpBundle.message("refactoring.common.not.supported.expression.in.scope", this.getRefactoringName()));
        return null;
    }

    private static PsiElement replaceAnchor(PhpIntroduceContext introduceContext, PsiElement expressionForOriginalElement, PsiElement anchor) {
        PsiElement physicalElement = introduceContext.getPhysicalElement();
        if (anchor == physicalElement) {
            anchor = physicalElement.replace(expressionForOriginalElement);
        } else {
            physicalElement.replace(expressionForOriginalElement);
        }
        return anchor;
    }

    @Override
    protected boolean canPerformInplaceIntroduce(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(22);
        }
        return !PhpRefactoringUtil.isEmbedVariableAllowed(context);
    }

    @Override
    @NotNull
    protected PhpBaseInplaceIntroducer<? extends PhpNamedElement, PhpIntroduceVariableSettings> getInplaceIntroducer(@NotNull PhpIntroduceContext context, @NotNull PhpIntroduceVariableSettings settings) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(23);
        }
        if (settings == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(24);
        }
        return new PhpVariableInplaceIntroducer(this, context, settings);
    }

    @Override
    @NotNull
    protected PhpIntroduceVariableSettings getInplaceIntroduceSettings(final @NotNull PhpIntroduceContext introduceContext, final boolean replaceAll) {
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(25);
        }
        return new PhpIntroduceVariableSettings(){

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAll;
            }

            @Override
            public boolean isEmbedVariable() {
                return false;
            }

            @Override
            public String getName() {
                String[] names = new PhpIntroduceVariableNameSuggestionProvider(introduceContext, PhpIntroduceVariableHandler.getOccupiedElements(introduceContext)).getSuggestedNames();
                return names.length > 0 ? names[0] : "x";
            }
        };
    }

    @NotNull
    public static Set<? extends PhpNamedElement> getOccupiedElements(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(26);
        }
        Set<? extends PhpNamedElement> set = VariableImpl.collectDeclarations(context.getPhysicalElement(), true, null);
        if (set == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(27);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceVariable/PhpIntroduceVariableHandler";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 19: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physicalExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOccurrences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOriginalElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceVariable/PhpIntroduceVariableHandler";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccupiedElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDeleteSelf";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedScope";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedContext";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "canPerformInplaceIntroduce";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroducer";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroduceSettings";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOccupiedElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

