/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceParameter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportConstantQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportFunctionQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceParameter.PhpFunctionCallReferenceReplacer;
import com.jetbrains.php.refactoring.introduce.introduceParameter.PhpIntroduceParameterDialog;
import com.jetbrains.php.refactoring.introduce.introduceParameter.PhpIntroduceParameterPresenter;
import com.jetbrains.php.refactoring.introduce.introduceParameter.PhpParameterInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableSettings;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceParameterHandler
extends PhpIntroduceVariableHandler {
    static void processUsages(Project project, PhpIntroduceContext introduceContext, Collection<PsiReference> references, Map<String, Constant> constantReferenceToDeclaration, Map<String, Function> functionCallToDeclaration, @NotNull Function function, @NotNull TIntHashSet parametersToRemove, @Nullable String argumentName) {
        if (function == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        if (parametersToRemove == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        for (PsiReference reference : references) {
            PhpIntroduceParameterHandler.processUsage(project, introduceContext, reference, constantReferenceToDeclaration, functionCallToDeclaration, function, parametersToRemove, argumentName);
        }
    }

    private static void processUsage(Project project, PhpIntroduceContext introduceContext, PsiReference reference, Map<String, Constant> constantReferenceToDeclaration, Map<String, Function> functionCallToDeclaration, @NotNull Function function, @NotNull TIntHashSet parametersToRemove, @Nullable String argumentName) {
        PsiElement newArgument;
        FunctionReference fr;
        ParameterList frParameterList;
        Object functionReference;
        if (function == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        if (parametersToRemove == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        PsiElement logicalElement = introduceContext.getLogicalElement();
        String parameterText = logicalElement.getText();
        if (reference instanceof PhpCallbackReferenceBase && (functionReference = PhpPsiUtil.getParentByCondition(reference.getElement(), (Condition<? super PsiElement>)FunctionReference.INSTANCEOF)) instanceof PsiReference) {
            reference = (PsiReference)functionReference;
        }
        if (reference instanceof FunctionReference && (frParameterList = (fr = (FunctionReference)reference).getParameterList()) != null && (newArgument = PhpIntroduceParameterHandler.createArgument(project, parameterText)) != null) {
            PhpFunctionCallReferenceReplacer referenceReplacer = new PhpFunctionCallReferenceReplacer(function, fr);
            referenceReplacer.replaceReferences(newArgument, logicalElement);
            boolean hasNamedArguments = ContainerUtil.exists((Object[])frParameterList.getParameters(), p -> ParameterListImpl.getNameIdentifier(p) != null);
            frParameterList = PhpIntroduceParameterHandler.removeUnusedArguments(project, parametersToRemove, function, frParameterList, hasNamedArguments);
            int length = frParameterList.getParameters().length;
            String argumentText = (String)(hasNamedArguments && argumentName != null ? argumentName + ": " : "") + newArgument.getText();
            String text = frParameterList.getText() + (length > 0 ? ", " : "") + argumentText;
            frParameterList.replace((PsiElement)PhpPsiElementFactory.createArgumentList(project, text));
            ((PsiElement)ArrayUtil.getLastElement((Object[])fr.getParameters())).accept((PsiElementVisitor)new ImportingVisitor(constantReferenceToDeclaration, functionCallToDeclaration));
        }
    }

    @Nullable
    private static PsiElement createArgument(Project project, @NotNull String argumentText) {
        if (argumentText == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        ParameterList newParameterList = PhpPsiElementFactory.createArgumentList(project, argumentText);
        return (PsiElement)ArrayUtil.getFirstElement((Object[])newParameterList.getParameters());
    }

    @Override
    @Nls
    public String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.parameter.name", new Object[0]);
    }

    @Override
    @NotNull
    protected PhpIntroduceParameterPresenter getPresenter(PhpIntroduceContext introduceContext) {
        return new PhpIntroduceParameterPresenter(new PhpIntroduceParameterDialog(introduceContext.getProject()), this, introduceContext);
    }

    @Override
    protected boolean isSupportedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(5);
        }
        return PhpCodeValidationUtil.isAllowedAsParameterValue(expression);
    }

    @Override
    protected boolean isSupportedScope(@Nullable PsiElement scope, @NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(6);
        }
        return scope != null;
    }

    @Override
    @Nullable
    protected PsiElement findScope(@NotNull PsiElement element) {
        if (element == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(7);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{Function.class, Method.class});
    }

    @Override
    @Nullable
    public PhpIntroduceBaseHandler.PhpIntroduceResult doRefactoring(@NotNull PhpIntroduceContext introduceContext, @NotNull PhpIntroduceVariableSettings settings) {
        if (introduceContext == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(9);
        }
        String name = settings.getName();
        Project project = introduceContext.getProject();
        Parameter parameter = PhpPsiElementFactory.createParameter(project, name);
        PsiElement physicalElement = introduceContext.getPhysicalElement();
        PsiElement expressionForOriginalElement = PhpIntroduceVariableHandler.getNewExpressionForOriginalElement(introduceContext, settings);
        Function function = (Function)PhpPsiUtil.getParentByCondition(introduceContext.getPhysicalElement(), (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (function == null) {
            return null;
        }
        THashMap constReferenceToDeclaration = new THashMap();
        THashMap functionCallToDeclaration = new THashMap();
        if (introduceContext.getContext() != null) {
            introduceContext.getContext().accept((PsiElementVisitor)new PhpRecursiveElementVisitor((Map)constReferenceToDeclaration, (Map)functionCallToDeclaration){
                final /* synthetic */ Map val$constReferenceToDeclaration;
                final /* synthetic */ Map val$functionCallToDeclaration;
                {
                    this.val$constReferenceToDeclaration = map;
                    this.val$functionCallToDeclaration = map2;
                }

                public void visitPhpConstantReference(ConstantReference constantReference) {
                    PsiElement resolve = constantReference.resolve();
                    if (resolve instanceof Constant) {
                        this.val$constReferenceToDeclaration.put(constantReference.getName(), (Constant)resolve);
                    }
                    super.visitPhpConstantReference(constantReference);
                }

                public void visitPhpFunctionCall(FunctionReference functionReference) {
                    PsiElement resolve = functionReference.resolve();
                    if (resolve instanceof Function) {
                        this.val$functionCallToDeclaration.put(functionReference.getName(), (Function)resolve);
                    }
                    super.visitPhpFunctionCall(functionReference);
                }
            });
        }
        TIntHashSet parametersToRemove = PhpIntroduceParameterHandler.findParametersToRemove(function, introduceContext, settings);
        Collection references = ReferencesSearch.search((PsiElement)function).findAll();
        PhpIntroduceParameterHandler.processUsages(project, introduceContext, references, (Map<String, Constant>)constReferenceToDeclaration, (Map<String, Function>)functionCallToDeclaration, function, parametersToRemove, settings.getName());
        physicalElement.replace(expressionForOriginalElement);
        PhpChangeSignatureProcessor.appendParameterToParameterList(function, parameter);
        PhpIntroduceVariableHandler.replaceOccurrences(introduceContext, settings, expressionForOriginalElement);
        ParameterList newParameterList = PhpIntroduceParameterHandler.removeUnusedParameters(project, parametersToRemove, function);
        PhpChangeSignatureUsageProcessor.fixPhpDoc(function, false);
        return new PhpIntroduceBaseHandler.PhpIntroduceResult((PsiElement)ArrayUtil.getLastElement((Object[])newParameterList.getParameters()), null, null);
    }

    private static ParameterList removeUnusedParameters(Project project, @NotNull TIntHashSet parametersToRemove, @NotNull Function function) {
        if (parametersToRemove == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(10);
        }
        if (function == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(11);
        }
        ParameterList parameterList = (ParameterList)PhpPsiUtil.getChildOfType((PsiElement)function, PhpElementTypes.PARAMETER_LIST);
        assert (parameterList != null);
        if (parametersToRemove.isEmpty()) {
            return parameterList;
        }
        PsiElement[] parameters = parameterList.getParameters();
        ArrayList<String> filteredParameters = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            if (parametersToRemove.contains(i)) continue;
            filteredParameters.add(parameters[i].getText());
        }
        String text = String.join((CharSequence)", ", filteredParameters);
        ParameterList newParameterList = PhpPsiElementFactory.createParameterList(project, text);
        return (ParameterList)parameterList.replace((PsiElement)newParameterList);
    }

    private static ParameterList removeUnusedArguments(Project project, @NotNull TIntHashSet parametersToRemove, @NotNull Function function, @NotNull ParameterList argumentList, boolean hasNamedArguments) {
        if (parametersToRemove == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(12);
        }
        if (function == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(13);
        }
        if (argumentList == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(14);
        }
        if (parametersToRemove.isEmpty()) {
            return argumentList;
        }
        PsiElement[] arguments = argumentList.getParameters();
        ArrayList<PsiElement> toDelete = new ArrayList<PsiElement>();
        for (int indexToRemove : parametersToRemove.toArray()) {
            PsiElement argument = PhpIntroduceParameterHandler.getArgumentByParameterIndex(function.getParameters(), arguments, indexToRemove);
            if (argument == null) continue;
            toDelete.add(argument);
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (PsiElement argument : arguments) {
            if (toDelete.contains(argument)) continue;
            PsiElement namePart = ParameterListImpl.getNameIdentifier(argument);
            String elementText = hasNamedArguments && namePart != null ? namePart.getText() + ":" + argument.getText() : argument.getText();
            joiner.add(elementText);
        }
        String text = joiner.toString();
        ParameterList newParameterList = PhpPsiElementFactory.createArgumentList(project, text);
        return (ParameterList)argumentList.replace((PsiElement)newParameterList);
    }

    @NotNull
    private static TIntHashSet findParametersToRemove(@NotNull Function rootFunction, @NotNull PhpIntroduceContext introduceContext, @NotNull PhpIntroduceVariableSettings settings) {
        Parameter[] parameters;
        if (rootFunction == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(15);
        }
        if (introduceContext == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(16);
        }
        if (settings == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(17);
        }
        if ((parameters = rootFunction.getParameters()).length == 0) {
            return new TIntHashSet();
        }
        PsiElement expression = introduceContext.getLogicalElement();
        final TIntHashSet suspects = new TIntHashSet();
        expression.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                int index;
                PsiElement resolvedReference = variable.resolve();
                if (resolvedReference instanceof Parameter && (index = ArrayUtil.find((Object[])parameters, (Object)resolvedReference)) != -1) {
                    suspects.add(index);
                }
            }
        });
        if (suspects.isEmpty() || !PhpIntroduceParameterHandler.areParametersCanBeDeleted(rootFunction)) {
            return new TIntHashSet();
        }
        TIntIterator iterator = suspects.iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            Parameter parameter = parameters[index];
            if (parameter.isVariadic()) {
                iterator.remove();
            }
            ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).forEach(reference -> {
                PsiElement element = reference.getElement();
                if (!(PhpIntroduceParameterHandler.isInsideElement(expression, element) || PhpIntroduceParameterHandler.isInsidePhpDoc(element) || PhpIntroduceParameterHandler.isInsideExpressionOccurrence(element, introduceContext.getOccurrences(), settings))) {
                    iterator.remove();
                    return false;
                }
                return true;
            });
        }
        TIntHashSet tIntHashSet = suspects;
        if (tIntHashSet == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(18);
        }
        return tIntHashSet;
    }

    private static boolean areParametersCanBeDeleted(@NotNull Function rootFunction) {
        if (rootFunction == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(19);
        }
        if (rootFunction instanceof Method) {
            Method method = (Method)rootFunction;
            boolean isConstructor = method.getMethodType(false) == Method.MethodType.CONSTRUCTOR;
            Collection<Function> functions = PhpChangeSignatureUsageSearcher.getOverridingMembers((Function)method, false);
            if (functions.size() != 1) {
                return false;
            }
            Method superMethod = PhpChangeSignatureUsageSearcher.findDeepestSuperMethod(method, isConstructor);
            if (superMethod != null) {
                return false;
            }
        }
        return true;
    }

    @Contract(pure=true)
    private static boolean isInsidePhpDoc(@NotNull PsiElement element) {
        if (element == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(20);
        }
        return PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF) != null;
    }

    private static boolean isInsideExpressionOccurrence(@NotNull PsiElement element, PsiElement @Nullable [] occurrences, @NotNull PhpIntroduceVariableSettings settings) {
        if (element == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(21);
        }
        if (settings == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(22);
        }
        if (!settings.isReplaceAllOccurrences()) {
            return false;
        }
        if (occurrences == null) {
            return false;
        }
        for (PsiElement occurrence : occurrences) {
            if (!PhpIntroduceParameterHandler.isInsideElement(occurrence, element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInsideElement(@NotNull PsiElement parent, @NotNull PsiElement child) {
        if (parent == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(23);
        }
        if (child == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(24);
        }
        return parent.getTextRange().contains(child.getTextRange());
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getArgumentByParameterIndex(Parameter @NotNull [] parameters, PsiElement @NotNull [] arguments, int index) {
        if (parameters == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(25);
        }
        if (arguments == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(26);
        }
        if (index < arguments.length) {
            return arguments[index];
        }
        if (arguments.length < parameters.length) {
            return parameters[index].getDefaultValue();
        }
        return null;
    }

    @Override
    protected boolean canPerformInplaceIntroduce(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(27);
        }
        return true;
    }

    @Override
    @NotNull
    protected PhpBaseInplaceIntroducer<Parameter, PhpIntroduceVariableSettings> getInplaceIntroducer(@NotNull PhpIntroduceContext context, @NotNull PhpIntroduceVariableSettings settings) {
        if (context == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(28);
        }
        if (settings == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(29);
        }
        return new PhpParameterInplaceIntroducer(this, context, settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToRemove";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentText";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 9: 
            case 17: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFunction";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceParameter/PhpIntroduceParameterHandler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceParameter/PhpIntroduceParameterHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findParametersToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processUsages";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processUsage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createArgument";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeUnusedParameters";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeUnusedArguments";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findParametersToRemove";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "areParametersCanBeDeleted";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePhpDoc";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInsideExpressionOccurrence";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInsideElement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentByParameterIndex";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canPerformInplaceIntroduce";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroducer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ImportingVisitor
    extends PhpRecursiveElementVisitor {
        Map<String, Constant> constReferenceToDeclaration;
        Map<String, Function> functionCallToDeclaration;

        ImportingVisitor(Map<String, Constant> constReferenceToDeclaration, Map<String, Function> functionCallToDeclaration) {
            this.constReferenceToDeclaration = constReferenceToDeclaration;
            this.functionCallToDeclaration = functionCallToDeclaration;
        }

        public void visitPhpConstantReference(ConstantReference reference) {
            Constant definition = this.constReferenceToDeclaration.get(reference.getName());
            if (definition != null) {
                PhpImportConstantQuickFix.INSTANCE.applyFix(reference.getProject(), (PhpReference)reference, (PhpNamedElement)definition);
            }
            super.visitPhpConstantReference(reference);
        }

        public void visitPhpFunctionCall(FunctionReference reference) {
            Function definition = this.functionCallToDeclaration.get(reference.getName());
            if (definition != null) {
                PhpImportFunctionQuickFix.INSTANCE.applyFix(reference.getProject(), (PhpReference)reference, (PhpNamedElement)definition);
            }
            super.visitPhpFunctionCall(reference);
        }
    }
}

