/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceField;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBasePresenter;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceRefactoringHandler;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpFieldInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldDisplay;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldHandler;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldSettings;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpIntroduceFieldPresenter
extends PhpIntroduceBasePresenter<PhpIntroduceFieldDisplay, PhpIntroduceFieldSettings, PhpIntroduceRefactoringHandler<PhpIntroduceFieldSettings>>
implements PhpIntroduceBasePresenter.DisplayHandler<PhpIntroduceFieldDisplay> {
    public PhpIntroduceFieldPresenter(PhpIntroduceFieldDisplay display, PhpIntroduceRefactoringHandler<PhpIntroduceFieldSettings> refactoringHandler, PhpIntroduceContext introduceContext) {
        super(display, refactoringHandler, introduceContext);
        PhpPsiElement point = (PhpPsiElement)ObjectUtils.tryCast((Object)introduceContext.getScope(), PhpPsiElement.class);
        Set<Object> declarations = point != null ? FieldImpl.collectFieldDeclarations(point) : Collections.emptySet();
        this.handleDeclarations(declarations, PhpLangUtil.PREDEFINED_DYNAMIC_FIELDS_SET);
    }

    @Override
    public @NotNull Pair<Boolean, @Nls String> validate(PhpIntroduceFieldDisplay display) {
        String name = display.getName();
        if (!PhpLangUtil.isPhpIdentifier(name)) {
            return new Pair((Object)false, (Object)PhpBundle.message("refactoring.extract.base.validator.not.valid.identifier", name));
        }
        if (PhpLangUtil.isPhpReservedFieldName(name)) {
            return new Pair((Object)false, (Object)PhpBundle.message("refactoring.extract.field.validator.reserved.field.name", name));
        }
        if (this.myOccupiedNames.contains(name)) {
            return new Pair((Object)true, (Object)PhpBundle.message("refactoring.extract.field.conflict.already.exists", name));
        }
        Pair pair = EVERYTHING_IS_OK;
        if (pair == null) {
            PhpIntroduceFieldPresenter.$$$reportNull$$$0(0);
        }
        return pair;
    }

    @Override
    protected void initDisplay() {
        boolean isStatic = PhpIntroduceFieldHandler.isStaticContext(this.myIntroduceContext.getContext());
        boolean isMethodConstructor = this.myIntroduceContext.getContext() instanceof Method && PhpRefactoringUtil.isConstructor((Method)this.myIntroduceContext.getContext());
        boolean allowInitInMethodIfAll = isMethodConstructor || this.myIntroduceContext.isInSameContext();
        PsiElement initValue = this.myIntroduceContext.getInitializeValue();
        boolean allowInitInConstructor = !isStatic && !isMethodConstructor && (initValue == null || !PhpRefactoringUtil.containsLocalVariables(initValue));
        boolean allowInitInFieldDeclaration = initValue == null || PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(initValue);
        boolean allowIntroduceMethodPanel = !isStatic && PhpRefactoringUtil.isEmbedVariableAllowed(this.myIntroduceContext);
        boolean allowIntroduceInSetUp = PhpFieldInplaceIntroducer.allowInitInSetUp(this.myIntroduceContext);
        ((PhpIntroduceFieldDisplay)this.myDisplay).setData(this.myIntroduceContext.getOccurrencesCount(), new PhpIntroduceFieldNameSuggestionProvider(this.myIntroduceContext, this.myOccupiedNames).getSuggestedNames(), this, allowInitInFieldDeclaration, allowInitInConstructor, allowIntroduceInSetUp, allowInitInMethodIfAll, allowIntroduceMethodPanel, isMethodConstructor, isStatic, this.myIntroduceContext.isToReplaceSourceElement());
    }

    @Override
    public PhpIntroduceFieldSettings getSettings() {
        return (PhpIntroduceFieldSettings)((Object)this.myDisplay);
    }

    @Override
    public void collectConflicts(MultiMap<PsiElement, String> conflicts) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/introduce/introduceField/PhpIntroduceFieldPresenter", "validate"));
    }
}

