/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceField;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpFieldInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldDialog;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldPresenter;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceFieldHandler
extends PhpIntroduceBaseHandler<PhpIntroduceFieldSettings, PhpIntroduceFieldPresenter> {
    public static boolean isStaticContext(@Nullable PsiElement context) {
        return context instanceof Method && ((Method)context).isStatic();
    }

    private static String getFieldReferenceText(@NotNull PhpIntroduceFieldSettings settings) {
        if (settings == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(0);
        }
        return PhpIntroduceFieldHandler.getFieldReferenceText(settings.isStatic(), settings.getName());
    }

    private static String getFieldReferenceText(boolean isStatic, @NotNull String name) {
        if (name == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(1);
        }
        if (isStatic) {
            return "self::$" + name;
        }
        return "$this->" + name;
    }

    @NotNull
    private static PsiElement getFieldDeclaration(PhpIntroduceContext introduceContext, PhpIntroduceFieldSettings settings) {
        return PhpIntroduceFieldHandler.getFieldDeclaration(introduceContext, settings, settings.getInitPlace().equals((Object)PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION), settings.getName());
    }

    @NotNull
    public static PsiElement getFieldDeclaration(PhpIntroduceContext introduceContext, PhpIntroduceFieldSettings settings, boolean inFieldDeclaration, String name) {
        PhpModifier modifier = PhpModifier.instance((PhpModifier.Access)settings.getAccess(), (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)(settings.isStatic() ? PhpModifier.State.STATIC : PhpModifier.State.DYNAMIC));
        String defaultValue = inFieldDeclaration ? introduceContext.getElementDeclarationText() : null;
        PhpPsiElement phpPsiElement = PhpPsiElementFactory.createClassField(introduceContext.getProject(), modifier, name, defaultValue, null);
        if (phpPsiElement == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(2);
        }
        return phpPsiElement;
    }

    @NotNull
    public static Statement getFieldInitialization(PhpIntroduceContext introduceContext, boolean isStatic, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("class A{\npublic function f(){\n");
        builder.append(PhpIntroduceFieldHandler.getFieldReferenceText(isStatic, name));
        builder.append(" = ");
        builder.append(introduceContext.getElementDeclarationText());
        builder.append(";");
        builder.append("\n\n");
        builder.append("}}");
        Statement statement = (Statement)PhpPsiElementFactory.createPhpPsiFromText(introduceContext.getProject(), PhpElementTypes.ASSIGNMENT_EXPRESSION, builder.toString()).getParent();
        if (statement == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(3);
        }
        return statement;
    }

    @NotNull
    private static PsiElement getNewExpressionForOccurrences(PhpIntroduceContext introduceContext, PhpIntroduceFieldSettings settings) {
        if (settings.isStatic()) {
            FieldReference fieldReference = PhpPsiElementFactory.createFieldReferenceUsingSelf(introduceContext.getProject(), settings.getName());
            if (fieldReference == null) {
                PhpIntroduceFieldHandler.$$$reportNull$$$0(4);
            }
            return fieldReference;
        }
        FieldReference fieldReference = PhpPsiElementFactory.createFieldReferenceUsingThis(introduceContext.getProject(), settings.getName());
        if (fieldReference == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(5);
        }
        return fieldReference;
    }

    @NotNull
    private static PsiElement getNewExpressionForOriginalElement(PhpIntroduceContext introduceContext, PhpIntroduceFieldSettings settings) {
        if (introduceContext.isPhysical()) {
            return PhpIntroduceFieldHandler.getNewExpressionForOccurrences(introduceContext, settings);
        }
        if (introduceContext.getPhysicalElement() instanceof BinaryExpression) {
            PhpPsiElement phpPsiElement = PhpIntroduceFieldHandler.insertIntoBinaryExpression((BinaryExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), PhpIntroduceFieldHandler.getFieldReferenceText(settings));
            if (phpPsiElement == null) {
                PhpIntroduceFieldHandler.$$$reportNull$$$0(6);
            }
            return phpPsiElement;
        }
        if (introduceContext.getPhysicalElement().getNode().getElementType().equals(PhpElementTypes.STRING)) {
            if (settings.isEmbedVariable()) {
                PhpPsiElement phpPsiElement = PhpIntroduceFieldHandler.insertIntoStringByEmbeding((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), PhpIntroduceFieldHandler.getFieldReferenceText(settings));
                if (phpPsiElement == null) {
                    PhpIntroduceFieldHandler.$$$reportNull$$$0(7);
                }
                return phpPsiElement;
            }
            PhpPsiElement phpPsiElement = PhpIntroduceFieldHandler.insertIntoStringByConcatenation((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), PhpIntroduceFieldHandler.getFieldReferenceText(settings));
            if (phpPsiElement == null) {
                PhpIntroduceFieldHandler.$$$reportNull$$$0(8);
            }
            return phpPsiElement;
        }
        if (introduceContext.getPhysicalElement().getNode().getElementType().equals(PhpElementTypes.HEREDOC)) {
            PhpPsiElement phpPsiElement = PhpIntroduceFieldHandler.insertIntoHeredoc((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), PhpIntroduceFieldHandler.getFieldReferenceText(settings));
            if (phpPsiElement == null) {
                PhpIntroduceFieldHandler.$$$reportNull$$$0(9);
            }
            return phpPsiElement;
        }
        assert (false) : "Not supported element type: " + introduceContext.getPhysicalElement().getNode().getElementType();
        if (null == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Nullable
    private static Method getOrCreateInitMethod(PhpIntroduceFieldSettings.InitPlace initPlace, PhpIntroduceContext context) {
        if (initPlace == PhpIntroduceFieldSettings.InitPlace.CONSTRUCTOR) {
            return PhpIntroduceFieldHandler.getOrCreateConstructor(context);
        }
        if (initPlace == PhpIntroduceFieldSettings.InitPlace.SET_UP) {
            return PhpIntroduceFieldHandler.getOrCreateSetUp(context);
        }
        return (Method)ObjectUtils.tryCast((Object)context.getContext(), Method.class);
    }

    @Nullable
    public static PsiElement putInitStatementInMethodBlock(@NotNull PhpIntroduceFieldSettings.InitPlace initPlace, @NotNull Statement initStatement, @NotNull PhpIntroduceContext introduceContext, @NotNull PhpIntroduceFieldSettings settings) {
        Method method;
        if (initPlace == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(11);
        }
        if (initStatement == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(12);
        }
        if (introduceContext == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(14);
        }
        if ((method = PhpIntroduceFieldHandler.getOrCreateInitMethod(initPlace, introduceContext)) == null) {
            return null;
        }
        GroupStatement methodBlock = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)method, GroupStatement.class);
        if (methodBlock.getChildren().length == 0) {
            return methodBlock.addAfter((PsiElement)initStatement, methodBlock.getFirstChild());
        }
        PsiElement anchor = PhpIntroduceFieldHandler.findAnchorInMethodBlock(methodBlock, introduceContext, settings);
        if (anchor == null) {
            return methodBlock.addBefore((PsiElement)initStatement, methodBlock.getLastChild());
        }
        return anchor.getParent().addBefore((PsiElement)initStatement, anchor);
    }

    @Nullable
    private static PsiElement findAnchorInMethodBlock(GroupStatement methodBlock, PhpIntroduceContext introduceContext, PhpIntroduceFieldSettings settings) {
        PsiElement[] occurrences = settings.isReplaceAllOccurrences() ? (PsiElement[])ArrayUtil.append((Object[])introduceContext.getOccurrences(), (Object)introduceContext.getPhysicalElement()) : new PsiElement[]{introduceContext.getPhysicalElement()};
        for (PsiElement child : methodBlock.getChildren()) {
            for (PsiElement occurrence : occurrences) {
                if (!PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)occurrence, (boolean)false)) continue;
                return child;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement replaceOriginalElement(@NotNull PhpIntroduceContext context, @NotNull PsiElement newElement) {
        if (context == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(15);
        }
        if (newElement == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(16);
        }
        PsiElement physicalElement = context.getPhysicalElement();
        if (context.isToReplaceSourceElement()) {
            assert (physicalElement instanceof Variable);
            AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition(physicalElement, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
            if (assignment != null) {
                PsiElement statement = assignment.getParent();
                if (statement instanceof Statement) {
                    statement.getParent().deleteChildRange(statement, statement);
                    return null;
                }
                physicalElement = assignment;
            }
        }
        return physicalElement.replace(newElement);
    }

    @Override
    @Nullable
    protected PsiElement findScope(@NotNull PsiElement element) {
        PsiElement scope;
        if (element == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(17);
        }
        if ((scope = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PhpClass.class, PhpFile.class, Function.class, Method.class, Global.class})) instanceof Method) {
            return PsiTreeUtil.getParentOfType((PsiElement)scope, PhpClass.class);
        }
        if (scope instanceof PhpFile || scope instanceof Function || scope instanceof Global) {
            return null;
        }
        return scope;
    }

    @Override
    protected boolean isSupportedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(18);
        }
        return !PhpPsiUtil.isOfType(expression, PhpElementTypes.HASH_ARRAY_ELEMENT);
    }

    @Override
    protected boolean isSupportedScope(@Nullable PsiElement scope, @NotNull PsiElement expression) {
        Statement parent;
        if (expression == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(19);
        }
        if ((parent = (Statement)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpStaticStatement.class)) != null) {
            return !(expression instanceof Variable) || !((Variable)expression).isDeclaration();
        }
        return scope != null;
    }

    @Override
    protected boolean isSupportedContext(@NotNull PsiElement context, @NotNull PsiElement logicalExpression, PsiElement physicalExpression) {
        boolean isPhysical;
        if (context == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(20);
        }
        if (logicalExpression == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(21);
        }
        boolean bl = isPhysical = logicalExpression == physicalExpression;
        if (context instanceof PhpDefine) {
            return true;
        }
        if (!(context instanceof Method)) {
            return false;
        }
        return !((Method)context).isStatic() || isPhysical || !PhpElementTypes.HEREDOC.equals(physicalExpression.getNode().getElementType());
    }

    @Override
    protected MultiMap<PsiElement, PsiElement> getOccurrences(@NotNull PsiElement scope, final @NotNull PsiElement sample, boolean isPhysical, final @NotNull PsiElement sampleContext, @NotNull TextRange elementRange, @NotNull PhpIntroduceContext introduceContext) {
        PhpAccessVariableInstruction instruction;
        if (scope == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(22);
        }
        if (sample == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(23);
        }
        if (sampleContext == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(24);
        }
        if (elementRange == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(25);
        }
        if (introduceContext == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(26);
        }
        if (sampleContext instanceof PhpScopeHolder && sample instanceof Variable && (instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)((Variable)sample), PhpAccessVariableInstruction.class)) != null) {
            final CharSequence variableName = ((Variable)sample).getNameCS();
            final MultiMap occurrences = new MultiMap();
            PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    PhpPsiElement variable = instruction.getAnchor();
                    if (variable instanceof Variable && PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName)) {
                        occurrences.putValue((Object)sampleContext, (Object)variable);
                    }
                    return true;
                }
            });
            return occurrences;
        }
        PhpIntroduceBaseHandler.OccurrencesCollector collector = new PhpIntroduceBaseHandler.OccurrencesCollector(scope, sample, isPhysical, sampleContext, elementRange){
            boolean isStaticContext;
            boolean isConstExpression;
            boolean isReferenceFree;

            @Override
            protected void init() {
                this.isStaticContext = PhpIntroduceFieldHandler.isStaticContext(this.mySampleContext);
                if (this.isStaticContext) {
                    this.isReferenceFree = false;
                    this.isConstExpression = PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(sample);
                } else {
                    this.isReferenceFree = PhpRefactoringUtil.isReferenceFreeExpression(sample);
                    this.isConstExpression = false;
                }
            }

            @Override
            protected boolean processContext(PsiElement context) {
                if (PhpRefactoringUtil.isFunction(context) || context instanceof PhpClass || context instanceof Field) {
                    return false;
                }
                if (context instanceof Method) {
                    if (this.isStaticContext != ((Method)context).isStatic()) {
                        return false;
                    }
                    if (this.contextStack.peek() != this.mySampleContext) {
                        if (this.isStaticContext) {
                            return this.isConstExpression;
                        }
                        return this.isReferenceFree;
                    }
                }
                return true;
            }
        };
        return collector.getOccurrences();
    }

    @Override
    @NotNull
    protected PhpIntroduceFieldPresenter getPresenter(PhpIntroduceContext introduceContext) {
        return new PhpIntroduceFieldPresenter(new PhpIntroduceFieldDialog(introduceContext.getProject()), this, introduceContext);
    }

    @Override
    protected boolean canPerformInplaceIntroduce(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(27);
        }
        return !PhpRefactoringUtil.isEmbedVariableAllowed(context);
    }

    @Override
    @NotNull
    protected PhpBaseInplaceIntroducer<Field, PhpIntroduceFieldSettings> getInplaceIntroducer(@NotNull PhpIntroduceContext context, @NotNull PhpIntroduceFieldSettings settings) {
        if (context == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(28);
        }
        if (settings == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(29);
        }
        return new PhpFieldInplaceIntroducer(this, context, settings);
    }

    @Override
    @NotNull
    protected PhpIntroduceFieldSettings getInplaceIntroduceSettings(final @NotNull PhpIntroduceContext introduceContext, final boolean replaceAll) {
        PhpPsiElement scope;
        if (introduceContext == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(30);
        }
        Set occupiedNames = (scope = (PhpPsiElement)ObjectUtils.tryCast((Object)introduceContext.getScope(), PhpPsiElement.class)) != null ? ContainerUtil.map2Set(FieldImpl.collectFieldDeclarations(scope), PhpNamedElement::getName) : Collections.emptySet();
        Object[] suggestedNames = new PhpIntroduceFieldNameSuggestionProvider(introduceContext, occupiedNames).getSuggestedNames();
        final LinkedHashSet uniqueSuggestedNames = ContainerUtil.newLinkedHashSet((Object[])suggestedNames);
        return new PhpIntroduceFieldSettings(){

            @Override
            public PhpModifier.Access getAccess() {
                return ((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)introduceContext.getFile(), PhpCodeStyleSettings.class)).FIELDS_DEFAULT_VISIBILITY;
            }

            @Override
            public PhpIntroduceFieldSettings.InitPlace getInitPlace() {
                PhpIntroduceFieldSettings.InitPlace lastSelectedInitPlace = PhpFieldInplaceIntroducer.getLastSelectedInitPlace(introduceContext.getProject());
                if (this.isSuitableInitPlace(lastSelectedInitPlace)) {
                    return lastSelectedInitPlace;
                }
                return PhpIntroduceFieldSettings.InitPlace.CURRENT_METHOD;
            }

            private boolean isSuitableInitPlace(PhpIntroduceFieldSettings.InitPlace lastSelectedInitPlace) {
                return lastSelectedInitPlace == PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION && PhpFieldInplaceIntroducer.allowInitInFieldDeclaration(introduceContext) || lastSelectedInitPlace == PhpIntroduceFieldSettings.InitPlace.CONSTRUCTOR && PhpFieldInplaceIntroducer.allowInitInConstructor(introduceContext) || lastSelectedInitPlace == PhpIntroduceFieldSettings.InitPlace.SET_UP && PhpFieldInplaceIntroducer.allowInitInSetUp(introduceContext);
            }

            @Override
            public boolean isStatic() {
                return PhpIntroduceFieldHandler.isStaticContext(introduceContext.getContext());
            }

            @Override
            public boolean isEmbedVariable() {
                return false;
            }

            @Override
            public String getName() {
                return (String)ObjectUtils.notNull((Object)((String)ContainerUtil.getFirstItem((Collection)uniqueSuggestedNames)), (Object)"t");
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAll;
            }
        };
    }

    @Override
    @Nls
    public String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.field.name", new Object[0]);
    }

    @Override
    @Nullable
    public PhpIntroduceBaseHandler.PhpIntroduceResult doRefactoring(@NotNull PhpIntroduceContext introduceContext, @NotNull PhpIntroduceFieldSettings settings) {
        Object introducedField;
        if (introduceContext == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(31);
        }
        if (settings == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(32);
        }
        super.doRefactoring(introduceContext, settings);
        PsiElement expressionForOriginalElement = PhpIntroduceFieldHandler.getNewExpressionForOriginalElement(introduceContext, settings);
        PhpClass clazz = (PhpClass)ObjectUtils.tryCast((Object)introduceContext.getScope(), PhpClass.class);
        if (clazz == null) {
            return null;
        }
        PsiElement classFields = PhpCodeEditUtil.insertClassMember(clazz, PhpIntroduceFieldHandler.getFieldDeclaration(introduceContext, settings));
        Object initStatement = introducedField = PhpPsiUtil.getChildByCondition(classFields, (Condition<? super PsiElement>)((Condition)a -> a instanceof Field && StringUtil.equals((CharSequence)((Field)a).getName(), (CharSequence)settings.getName())));
        if (!PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION.equals((Object)settings.getInitPlace())) {
            initStatement = PhpIntroduceFieldHandler.putInitStatementInMethodBlock(settings.getInitPlace(), PhpIntroduceFieldHandler.getFieldInitialization(introduceContext, settings.isStatic(), settings.getName()), introduceContext, settings);
        }
        PsiElement element = PhpIntroduceFieldHandler.replaceOriginalElement(introduceContext, expressionForOriginalElement);
        if (settings.isReplaceAllOccurrences()) {
            PsiElement expressionForOccurrences = introduceContext.isPhysical() ? expressionForOriginalElement : PhpIntroduceFieldHandler.getNewExpressionForOccurrences(introduceContext, settings);
            for (PsiElement occurrence : introduceContext.getOccurrences()) {
                if (element == null) {
                    element = occurrence.replace(expressionForOccurrences);
                    continue;
                }
                occurrence.replace(expressionForOccurrences);
            }
        }
        assert (introducedField != null);
        return new PhpIntroduceBaseHandler.PhpIntroduceResult((PsiElement)introducedField, element, (PsiElement)initStatement);
    }

    @Nullable
    public static Method getOrCreateConstructor(@NotNull PhpIntroduceContext introduceContext) {
        PhpClass clazz;
        if (introduceContext == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(33);
        }
        if ((clazz = (PhpClass)ObjectUtils.tryCast((Object)introduceContext.getScope(), PhpClass.class)) == null) {
            return null;
        }
        return PhpIntroduceFieldHandler.getOrCreateConstructor(clazz);
    }

    @Nullable
    public static Method getOrCreateConstructor(PhpClass clazz) {
        Method constructor = clazz.getOwnConstructor();
        if (constructor == null) {
            Method classConstructor;
            PhpClass superClass = clazz.getSuperClass();
            if (superClass != null) {
                Method superClassConstructor = superClass.getConstructor();
                if (superClassConstructor != null) {
                    String constructorParameters = Arrays.stream(superClassConstructor.getParameters()).map(e -> e.getText()).collect(Collectors.joining(","));
                    String constructorArguments = Arrays.stream(superClassConstructor.getParameters()).map(e -> "$" + e.getName()).collect(Collectors.joining(","));
                    classConstructor = PhpPsiElementFactory.createMethod(clazz.getProject(), "public function __construct(" + constructorParameters + "){ " + (String)(superClassConstructor.isAbstract() ? "" : "parent::__construct(" + constructorArguments + ");") + " }");
                } else {
                    classConstructor = PhpPsiElementFactory.createClassEmptyConstructor(clazz.getProject());
                }
            } else {
                classConstructor = PhpPsiElementFactory.createClassEmptyConstructor(clazz.getProject());
            }
            constructor = (Method)PhpCodeEditUtil.insertClassMember(clazz, (PsiElement)classConstructor);
        }
        return constructor;
    }

    @Nullable
    public static Method getOrCreateSetUp(@NotNull PhpIntroduceContext introduceContext) {
        PhpClass clazz;
        if (introduceContext == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(34);
        }
        if ((clazz = (PhpClass)ObjectUtils.tryCast((Object)introduceContext.getScope(), PhpClass.class)) == null) {
            return null;
        }
        Method setUp = clazz.findOwnMethodByName((CharSequence)"setUp");
        if (setUp == null) {
            String methodText = FileTemplateManager.getInstance((Project)introduceContext.getProject()).getCodeTemplate("PHPUnit SetUp Method").getText();
            Method setUpMethod = PhpPsiElementFactory.createMethod(introduceContext.getProject(), methodText);
            setUp = (Method)PhpCodeEditUtil.insertClassMember(clazz, (PsiElement)setUpMethod);
        }
        return setUp;
    }

    @Override
    @Nullable
    protected PhpPsiElement getParentIntroducibleElement(@NotNull PsiElement element, boolean strict) {
        Variable variable;
        if (element == null) {
            PhpIntroduceFieldHandler.$$$reportNull$$$0(35);
        }
        return (variable = (Variable)PhpPsiUtil.getParentByCondition(element, strict, (Condition<? super PsiElement>)Variable.INSTANCEOF)) == null ? super.getParentIntroducibleElement(element, strict) : variable;
    }

    @Override
    protected boolean replaceSourceElementIfPossible() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceField/PhpIntroduceFieldHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initPlace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initStatement";
                break;
            }
            case 13: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 15: 
            case 20: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 17: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalExpression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleContext";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceField/PhpIntroduceFieldHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldInitialization";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOccurrences";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOriginalElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFieldReferenceText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putInitStatementInMethodBlock";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceOriginalElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedScope";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedContext";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canPerformInplaceIntroduce";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroducer";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroduceSettings";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateConstructor";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSetUp";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getParentIntroducibleElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

