/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceConstant;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBasePresenter;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceRefactoringHandler;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantDisplay;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceConstantPresenter
extends PhpIntroduceBasePresenter<PhpIntroduceConstantDisplay, PhpIntroduceConstantSettings, PhpIntroduceRefactoringHandler<PhpIntroduceConstantSettings>>
implements PhpIntroduceBasePresenter.DisplayHandler<PhpIntroduceConstantDisplay> {
    private String mySuggestedName;
    private PhpModifier.Access myAccess;
    private boolean myMoveToClassByDefault;

    public PhpIntroduceConstantPresenter(PhpIntroduceConstantDisplay display, PhpIntroduceRefactoringHandler<PhpIntroduceConstantSettings> refactoringHandler, PhpIntroduceContext introduceContext) {
        super(display, refactoringHandler, introduceContext);
        this.handleDeclarations(PhpIntroduceConstantPresenter.collectConstDeclarations(introduceContext));
    }

    public static Set<? extends PhpNamedElement> collectConstDeclarations(PhpIntroduceContext introduceContext) {
        PsiElement scope = introduceContext.getScope();
        if (scope instanceof PhpClass) {
            return FieldImpl.collectClassConstDeclarations((PhpPsiElement)((PhpClass)scope));
        }
        if (scope instanceof PhpFile) {
            final HashSet constants = new HashSet();
            scope.accept((PsiElementVisitor)new PhpElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof PhpClass || element instanceof PhpNamespace || element instanceof Function) {
                        return;
                    }
                    if (element instanceof Constant) {
                        constants.add((Constant)element);
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantPresenter$1", "visitElement"));
                }
            });
            return constants;
        }
        if (scope instanceof PhpNamespace) {
            final HashSet constants = new HashSet();
            scope.accept((PsiElementVisitor)new PhpElementVisitor(){

                public void visitPhpElement(PhpPsiElement element) {
                    if (element instanceof PhpClass || element instanceof PhpFile || element instanceof Function) {
                        return;
                    }
                    if (element instanceof Constant) {
                        constants.add((Constant)element);
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return constants;
        }
        assert (false);
        return Collections.emptySet();
    }

    @Override
    public PhpIntroduceConstantDisplay getSettings() {
        return (PhpIntroduceConstantDisplay)this.myDisplay;
    }

    @Override
    protected void initDisplay() {
        PsiElement scope = this.myIntroduceContext.getScope();
        boolean allowConstSyntax = scope instanceof PhpFile ? PhpCodeValidationUtil.isAllowedAsConstantValue(this.myIntroduceContext.getLogicalElement()) : false;
        Object[] names = new PhpIntroduceConstantNameSuggestionProvider(this.myIntroduceContext, this.myOccupiedNames).getSuggestedNames();
        if (this.mySuggestedName != null) {
            names = (String[])ArrayUtil.prepend((Object)this.mySuggestedName, (Object[])names);
        }
        ((PhpIntroduceConstantDisplay)this.myDisplay).setData(this.myIntroduceContext.getOccurrencesCount(), (String[])names, this, scope, allowConstSyntax, this.myAccess, this.myMoveToClassByDefault);
    }

    public void setSuggestedNames(String name) {
        this.mySuggestedName = name;
    }

    public void setAccess(PhpModifier.Access access) {
        this.myAccess = access;
    }

    public void setMoveToClassByDefault(boolean moveToClassByDefault) {
        this.myMoveToClassByDefault = moveToClassByDefault;
    }

    @Override
    public @NotNull Pair<Boolean, @Nls String> validate(PhpIntroduceConstantDisplay display) {
        String name = display.getName();
        if (!PhpLangUtil.isPhpIdentifier(name)) {
            return new Pair((Object)false, (Object)PhpBundle.message("refactoring.extract.base.validator.not.valid.identifier", name));
        }
        if (PhpLangUtil.isPhpReservedKeyword(name)) {
            return new Pair((Object)false, (Object)PhpBundle.message("refactoring.extract.base.validator.reserved.keyword", name));
        }
        if (this.myOccupiedNames.contains(name)) {
            return new Pair((Object)true, (Object)PhpBundle.message("refactoring.extract.constant.conflict.already.exists", name));
        }
        Pair constantInBaseClass = PhpIntroduceConstantPresenter.checkConstantInBaseClasses(display, name);
        Pair pair = constantInBaseClass != null ? constantInBaseClass : EVERYTHING_IS_OK;
        if (pair == null) {
            PhpIntroduceConstantPresenter.$$$reportNull$$$0(0);
        }
        return pair;
    }

    @Nullable
    private static Pair<Boolean, String> checkConstantInBaseClasses(PhpIntroduceConstantDisplay display, String name) {
        PhpClass classz = (PhpClass)ObjectUtils.tryCast((Object)display.getScope(), PhpClass.class);
        if (classz == null) {
            return null;
        }
        Ref baseConstantExists = new Ref((Object)false);
        Ref isBaseInterface = new Ref((Object)false);
        Ref baseConstantHasStricterAccess = new Ref((Object)false);
        Ref baseClassName = new Ref();
        Ref baseAccess = new Ref();
        PhpClassHierarchyUtils.processFields((PhpClass)classz, (PhpClass)classz, (field, subClass, baseClass) -> {
            if (subClass == classz) {
                return true;
            }
            if (field == null || !field.isConstant() || !field.getName().equals(name)) {
                return true;
            }
            PhpModifier.Access access = field.getModifier().getAccess();
            if (access.isPrivate()) {
                return true;
            }
            if (!((Boolean)baseConstantExists.get()).booleanValue()) {
                baseConstantExists.set((Object)true);
                baseClassName.set((Object)subClass.getName());
                if (subClass.isInterface()) {
                    isBaseInterface.set((Object)true);
                    return false;
                }
            }
            if (access.isWeakerThan((PhpModifier.Access)MoreObjects.firstNonNull((Object)display.getAccess(), (Object)PhpModifier.Access.PUBLIC))) {
                baseConstantHasStricterAccess.set((Object)true);
                baseAccess.set((Object)access);
                return false;
            }
            return true;
        }, (boolean)false);
        if (!((Boolean)baseConstantExists.get()).booleanValue()) {
            return null;
        }
        return new Pair((Object)true, (Object)PhpIntroduceConstantPresenter.getMessage(name, (Boolean)baseConstantHasStricterAccess.get(), (Boolean)isBaseInterface.get(), (String)baseClassName.get(), (PhpModifier.Access)baseAccess.get()));
    }

    @NotNull
    private static String getMessage(String constantName, Boolean baseConstantHasStricterAccess, Boolean isBaseInterface, String baseClassName, PhpModifier.Access baseAccess) {
        if (isBaseInterface.booleanValue()) {
            String string = PhpBundle.message("refactoring.extract.constant.conflict.cannot.override.interface.constant", constantName, baseClassName);
            if (string == null) {
                PhpIntroduceConstantPresenter.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (baseConstantHasStricterAccess.booleanValue()) {
            String string = PhpBundle.message("refactoring.extract.constant.conflict.exists.in.subclass.with.weaker.access", constantName, baseAccess.toString(), baseClassName);
            if (string == null) {
                PhpIntroduceConstantPresenter.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = PhpBundle.message("refactoring.extract.constant.conflict.exists.in.subclass", baseClassName, constantName);
        if (string == null) {
            PhpIntroduceConstantPresenter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void collectConflicts(MultiMap<PsiElement, String> conflicts) {
    }

    @Override
    public PhpIntroduceBasePresenter.DisplayHandler.HandleReaction handleOKAction(PhpIntroduceConstantDisplay display) {
        PhpClass targetClass;
        String targetClassFqn = display.getTargetClassFqn();
        if (targetClassFqn != null && (targetClass = (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)this.myIntroduceContext.getProject()).getAnyByFQN(targetClassFqn))) != null && !CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)targetClass.getProject(), Collections.singleton(targetClass), (boolean)true)) {
            return PhpIntroduceBasePresenter.DisplayHandler.HandleReaction.RETURN;
        }
        return super.handleOKAction(display);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantPresenter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

