/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceConstant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpClassConstantInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpFileConstantInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantDialog;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantPresenter;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantSettings;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantProcessor;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceConstantHandler
extends PhpIntroduceBaseHandler<PhpIntroduceConstantSettings, PhpIntroduceConstantPresenter> {
    @NotNull
    private PsiElement createConstantDeclaration(PhpIntroduceContext introduceContext, PhpIntroduceConstantSettings settings) {
        if (introduceContext.getScope() instanceof PhpFile || introduceContext.getScope() instanceof PhpNamespace) {
            PsiElement psiElement = this.createFileConstantDeclaration(introduceContext, settings.isDefineSyntax(), settings.getName());
            if (psiElement == null) {
                PhpIntroduceConstantHandler.$$$reportNull$$$0(0);
            }
            return psiElement;
        }
        PsiElement psiElement = this.createClassConstantDeclaration(introduceContext, settings.getAccess(), settings.getName());
        if (psiElement == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createFileConstantDeclaration(PhpIntroduceContext introduceContext, boolean isDefineSyntax, String name) {
        StringBuilder assignBuilder = new StringBuilder();
        if (isDefineSyntax) {
            assignBuilder.append("define('");
            assignBuilder.append(name);
            assignBuilder.append("',");
            assignBuilder.append(this.getConstantValue(introduceContext).getText());
            assignBuilder.append(");");
        } else {
            assignBuilder.append("const ");
            assignBuilder.append(name);
            assignBuilder.append("=");
            assignBuilder.append(this.getConstantValue(introduceContext).getText());
            assignBuilder.append(";\n");
        }
        Statement statement = PhpPsiElementFactory.createStatement(introduceContext.getProject(), assignBuilder.toString());
        if (statement == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        return statement;
    }

    protected PsiElement getConstantValue(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(3);
        }
        return introduceContext.getLogicalElement();
    }

    public PsiElement createClassConstantDeclaration(PhpIntroduceContext introduceContext, PhpModifier.Access access, String name) {
        StringBuilder assignBuilder = new StringBuilder();
        assignBuilder.append("class A{");
        if (access != null) {
            assignBuilder.append(access);
        }
        assignBuilder.append(" const ");
        assignBuilder.append(name);
        assignBuilder.append("=");
        assignBuilder.append(this.getConstantValue(introduceContext).getText());
        assignBuilder.append(";\n}");
        return PhpPsiElementFactory.createFromText(introduceContext.getProject(), PhpElementTypes.CLASS_CONSTANTS, assignBuilder.toString());
    }

    @NotNull
    private static PsiElement getNewExpressionForOccurrences(PhpIntroduceContext introduceContext, PhpIntroduceConstantSettings settings) {
        PsiElement scope = introduceContext.getScope();
        if (scope instanceof PhpFile || scope instanceof PhpNamespace) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(introduceContext.getProject(), settings.getName());
            if (constantReference == null) {
                PhpIntroduceConstantHandler.$$$reportNull$$$0(4);
            }
            return constantReference;
        }
        ClassConstantReference classConstantReference = PhpPsiElementFactory.createClassConstantReferenceUsingSelf(introduceContext.getProject(), settings.getName());
        if (classConstantReference == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(5);
        }
        return classConstantReference;
    }

    @NotNull
    private static PsiElement getNewExpressionForOriginalElement(PhpIntroduceContext introduceContext, PhpIntroduceConstantSettings settings) {
        if (introduceContext.isPhysical()) {
            return PhpIntroduceConstantHandler.getNewExpressionForOccurrences(introduceContext, settings);
        }
        if (introduceContext.getPhysicalElement() instanceof BinaryExpression) {
            if (introduceContext.getScope() instanceof PhpClass) {
                PhpPsiElement phpPsiElement = PhpIntroduceConstantHandler.insertIntoBinaryExpression((BinaryExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "self::" + settings.getName());
                if (phpPsiElement == null) {
                    PhpIntroduceConstantHandler.$$$reportNull$$$0(6);
                }
                return phpPsiElement;
            }
            PhpPsiElement phpPsiElement = PhpIntroduceConstantHandler.insertIntoBinaryExpression((BinaryExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceConstantHandler.$$$reportNull$$$0(7);
            }
            return phpPsiElement;
        }
        if (introduceContext.getPhysicalElement().getNode().getElementType().equals(PhpElementTypes.STRING)) {
            if (introduceContext.getScope() instanceof PhpClass) {
                PhpPsiElement phpPsiElement = PhpIntroduceConstantHandler.insertIntoStringByConcatenation((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "self::" + settings.getName());
                if (phpPsiElement == null) {
                    PhpIntroduceConstantHandler.$$$reportNull$$$0(8);
                }
                return phpPsiElement;
            }
            PhpPsiElement phpPsiElement = PhpIntroduceConstantHandler.insertIntoStringByConcatenation((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceConstantHandler.$$$reportNull$$$0(9);
            }
            return phpPsiElement;
        }
        assert (false) : PhpIntroduceConstantHandler.createErrorMessage(introduceContext);
        if (null == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(10);
        }
        return null;
    }

    @NotNull
    private static String createErrorMessage(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(11);
        }
        StringBuilder builder = new StringBuilder("Unexpected element to introduce was found '");
        builder.append(introduceContext.getPhysicalElement().getText()).append("' : (");
        TextRange range = introduceContext.getLogicalElementRange();
        int startOffset = introduceContext.getPhysicalElement().getTextRange().getStartOffset();
        builder.append(range.getStartOffset() - startOffset).append(", ");
        builder.append(range.getEndOffset() - startOffset).append(")");
        String string = builder.toString();
        if (string == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static PsiElement findAnchorInFile(@Nullable PsiElement scope) {
        PhpPsiElement groupStatement = PhpIntroduceConstantHandler.getGroupStatement(scope);
        return groupStatement != null ? PhpIntroduceConstantHandler.getFirstNotConstantChild(groupStatement) : null;
    }

    @Nullable
    private static PhpPsiElement getGroupStatement(@Nullable PsiElement scope) {
        if (scope instanceof PhpFile) {
            return ((PhpFile)scope).getFirstPsiChild();
        }
        if (scope instanceof PhpNamespace) {
            return ((PhpNamespace)scope).getStatements();
        }
        return null;
    }

    @Nullable
    private static PsiElement getFirstNotConstantChild(@NotNull PhpPsiElement groupStatement) {
        PhpNamedElement phpNamedElement;
        PhpDocComment docComment;
        PhpPsiElement candidate;
        if (groupStatement == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(13);
        }
        if ((candidate = groupStatement.getFirstPsiChild()) == null) {
            return null;
        }
        candidate = PhpWorkaroundUtil.findNextPhpPsiElement((PsiElement)candidate);
        assert (candidate != null);
        PhpPsiElement prevCandidate = null;
        while (candidate != null && (PhpElementTypes.CONSTANTS == candidate.getNode().getElementType() || candidate instanceof PhpUseList)) {
            prevCandidate = candidate;
            candidate = PhpWorkaroundUtil.getNextPsiSibling(candidate);
        }
        if (candidate == null) {
            return prevCandidate;
        }
        if (candidate instanceof PhpNamedElement && (docComment = (phpNamedElement = (PhpNamedElement)candidate).getDocComment()) != null) {
            return docComment;
        }
        return candidate;
    }

    @Override
    @NotNull
    protected PhpIntroduceConstantPresenter getPresenter(PhpIntroduceContext introduceContext) {
        return new PhpIntroduceConstantPresenter(new PhpIntroduceConstantDialog(introduceContext), this, introduceContext);
    }

    @Override
    @Nls
    public String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.constant.name", new Object[0]);
    }

    @Override
    protected String getFeatureId() {
        return "refactoring.introduceConstant";
    }

    @Override
    @Nullable
    protected PsiElement findScope(@NotNull PsiElement element) {
        PsiElement scope;
        if (element == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(14);
        }
        if ((scope = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PhpNamespace.class, PhpClass.class, PhpFile.class, Function.class, Method.class})) instanceof Method) {
            return PsiTreeUtil.getParentOfType((PsiElement)scope, PhpClass.class);
        }
        if (scope instanceof Function) {
            return PsiTreeUtil.getParentOfType((PsiElement)scope, (Class[])new Class[]{PhpFile.class, PhpNamespace.class});
        }
        return scope;
    }

    @Override
    protected boolean isSupportedExpression(@NotNull PsiElement expression) {
        PsiElement parent;
        if (expression == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(15);
        }
        if ((parent = expression.getParent()) instanceof ImplementsList || parent instanceof ExtendsList) {
            return false;
        }
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PhpNamespace.class, PhpClass.class, PhpFile.class, Function.class, Method.class});
        if (scope instanceof PhpClass || scope instanceof PhpNamespace) {
            return PhpCodeValidationUtil.isAllowedAsConstantValue(expression);
        }
        return PhpRefactoringUtil.isScalarExpressions(expression) || PhpCodeValidationUtil.isAllowedAsConstantValue(expression);
    }

    @Override
    protected boolean isSupportedScope(@Nullable PsiElement scope, @NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(16);
        }
        if (scope instanceof PhpClass || scope instanceof PhpNamespace) {
            return PhpCodeValidationUtil.isAllowedAsConstantValue(expression);
        }
        return scope != null;
    }

    @Override
    protected boolean isSupportedContext(@NotNull PsiElement context, @NotNull PsiElement logicalExpression, @NotNull PsiElement physicalExpression) {
        boolean isPhysical;
        if (context == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(17);
        }
        if (logicalExpression == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(18);
        }
        if (physicalExpression == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(19);
        }
        boolean bl = isPhysical = logicalExpression == physicalExpression;
        if (context instanceof Parameter) {
            return false;
        }
        if (!isPhysical) {
            if (context instanceof Field) {
                return false;
            }
            if (PhpPsiUtil.isOfType(physicalExpression, PhpElementTypes.HEREDOC)) {
                return false;
            }
        }
        return !(physicalExpression.getParent() instanceof PhpAttribute);
    }

    @Override
    protected MultiMap<PsiElement, PsiElement> getOccurrences(@NotNull PsiElement scope, @NotNull PsiElement sample, boolean isPhysical, @NotNull PsiElement sampleContext, @NotNull TextRange elementRange, @NotNull PhpIntroduceContext introduceContext) {
        if (scope == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(20);
        }
        if (sample == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(21);
        }
        if (sampleContext == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(22);
        }
        if (elementRange == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(23);
        }
        if (introduceContext == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(24);
        }
        PhpIntroduceBaseHandler.OccurrencesCollector collector = new PhpIntroduceBaseHandler.OccurrencesCollector(scope, sample, isPhysical, sampleContext, elementRange){
            private boolean inClass;
            {
                this.inClass = false;
            }

            @Override
            protected void init() {
                if (this.myScope instanceof PhpClass) {
                    this.inClass = true;
                }
            }

            @Override
            protected boolean processContext(PsiElement element) {
                if (this.inClass) {
                    if (PhpRefactoringUtil.isFunction(element)) {
                        return false;
                    }
                    if (element instanceof PhpClass) {
                        return false;
                    }
                } else if (element instanceof PhpClass) {
                    this.skip = true;
                } else {
                    if (element instanceof Field) {
                        return false;
                    }
                    if (element instanceof Method) {
                        this.skip = true;
                    } else if (element instanceof Function) {
                        this.skip = false;
                    }
                }
                return true;
            }
        };
        return collector.getOccurrences();
    }

    @Override
    @Nullable
    public PhpIntroduceBaseHandler.PhpIntroduceResult doRefactoring(@NotNull PhpIntroduceContext introduceContext, @NotNull PhpIntroduceConstantSettings settings) {
        if (introduceContext == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(25);
        }
        if (settings == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(26);
        }
        super.doRefactoring(introduceContext, settings);
        PsiElement expressionForOriginalElement = PhpIntroduceConstantHandler.getNewExpressionForOriginalElement(introduceContext, settings);
        PsiElement introducedDeclaration = this.introduceConstantDeclaration(introduceContext, settings);
        if (introducedDeclaration == null) {
            this.showErrorHint(introduceContext.getProject(), introduceContext.getEditor(), PhpBundle.message("refactoring.extract.constant.unable.to.add.constant.declaration", new Object[0]));
            return null;
        }
        PsiElement result = introduceContext.getPhysicalElement().replace(expressionForOriginalElement);
        if (settings.isReplaceAllOccurrences()) {
            PsiElement expressionForOccurrences = introduceContext.isPhysical() ? expressionForOriginalElement : PhpIntroduceConstantHandler.getNewExpressionForOccurrences(introduceContext, settings);
            for (PsiElement occurrence : introduceContext.getOccurrences()) {
                occurrence.replace(expressionForOccurrences);
            }
        }
        PsiElement scope = introduceContext.getScope();
        String targetClassFqn = settings.getTargetClassFqn();
        if (scope instanceof PhpClass) {
            if (targetClassFqn != null && !PhpLangUtil.equalsClassNames(targetClassFqn, ((PhpClass)scope).getFQN())) {
                PsiElement movedElement = PhpIntroduceConstantHandler.moveIntroducedField(introduceContext, settings, scope, targetClassFqn);
                assert (movedElement != null);
                return new PhpIntroduceBaseHandler.PhpIntroduceResult(movedElement, null, null);
            }
        } else if (targetClassFqn != null) {
            Field movedElement = PhpIntroduceConstantHandler.moveIntroducedConstant(introduceContext, targetClassFqn, (Constant)PhpPsiUtil.getChildByCondition(introducedDeclaration, (Condition<? super PsiElement>)Constant.INSTANCEOF));
            assert (movedElement != null);
            return new PhpIntroduceBaseHandler.PhpIntroduceResult((PsiElement)movedElement, null, null);
        }
        return new PhpIntroduceBaseHandler.PhpIntroduceResult(introducedDeclaration, result, null);
    }

    private static Field moveIntroducedConstant(PhpIntroduceContext introduceContext, String targetClassFqn, @Nullable Constant constant) {
        PhpClass targetClass = (PhpClass)ContainerUtil.getOnlyItem((Collection)PhpIndex.getInstance((Project)introduceContext.getProject()).getAnyByFQN(targetClassFqn));
        if (targetClass != null && constant != null) {
            return PhpIntroduceConstantHandler.performMainRefactoring(introduceContext.getProject(), constant, targetClass, PhpMoveFileConstantProcessor.findUsages(constant));
        }
        return null;
    }

    private static Field performMainRefactoring(Project project, Constant constant, PhpClass targetClass, @NotNull Collection<UsageInfo> usages) {
        if (usages == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(27);
        }
        Field field = PhpMoveFileConstantProcessor.copyConstantToClass(project, constant, targetClass);
        PhpMoveFileConstantProcessor.replaceUsages(usages, constant, targetClass);
        PhpMoveFileConstantProcessor.deleteOriginalConstantDeclaration(constant);
        return field;
    }

    @Nullable
    private static PsiElement moveIntroducedField(PhpIntroduceContext introduceContext, PhpIntroduceConstantSettings settings, PsiElement scope, String targetClassFqn) {
        PhpIndex instance = PhpIndex.getInstance((Project)introduceContext.getProject());
        PhpClass targetClass = (PhpClass)ContainerUtil.getOnlyItem((Collection)instance.getAnyByFQN(targetClassFqn));
        Field field = ((PhpClass)scope).findOwnFieldByName((CharSequence)settings.getName(), true);
        if (targetClass != null && field != null) {
            List<Field> members = Collections.singletonList(field);
            return (PsiElement)ContainerUtil.getOnlyItem(PhpMoveMemberProcessor.performRefactoring(scope.getProject(), PhpMoveMemberProcessor.findUsages(members), members, targetClass, (PhpClass)scope));
        }
        return null;
    }

    @Nullable
    private PsiElement introduceConstantDeclaration(PhpIntroduceContext introduceContext, PhpIntroduceConstantSettings settings) {
        PsiElement constantDeclaration = this.createConstantDeclaration(introduceContext, settings);
        if (introduceContext.getScope() instanceof PhpClass) {
            return PhpCodeEditUtil.insertClassMember((PhpClass)introduceContext.getScope(), constantDeclaration);
        }
        PsiElement anchor = PhpIntroduceConstantHandler.findAnchorInFile(introduceContext.getScope());
        if (anchor == null) {
            return null;
        }
        CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)anchor);
        return anchor.getParent().addBefore(constantDeclaration, anchor);
    }

    @Override
    protected boolean canPerformInplaceIntroduce(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(28);
        }
        return true;
    }

    @Override
    @NotNull
    protected PhpBaseInplaceIntroducer<? extends PhpNamedElement, PhpIntroduceConstantSettings> getInplaceIntroducer(@NotNull PhpIntroduceContext context, @NotNull PhpIntroduceConstantSettings settings) {
        if (context == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(29);
        }
        if (settings == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(30);
        }
        return context.getScope() instanceof PhpClass ? new PhpClassConstantInplaceIntroducer(this, context, settings) : new PhpFileConstantInplaceIntroducer(this, context, settings);
    }

    @Override
    @NotNull
    protected PhpIntroduceConstantSettings getInplaceIntroduceSettings(final @NotNull PhpIntroduceContext context, final boolean replaceAll) {
        if (context == null) {
            PhpIntroduceConstantHandler.$$$reportNull$$$0(31);
        }
        final Set occupiedNames = ContainerUtil.map2Set(PhpIntroduceConstantPresenter.collectConstDeclarations(context), PhpNamedElement::getName);
        Object[] suggestedNames = new PhpIntroduceConstantNameSuggestionProvider(context, occupiedNames).getSuggestedNames();
        final String suggestedName = (String)ContainerUtil.getFirstItem((Collection)ContainerUtil.newLinkedHashSet((Object[])suggestedNames));
        return new PhpIntroduceConstantSettings(){

            @Override
            public PsiElement getScope() {
                return context.getScope();
            }

            @Override
            @Nullable
            public PhpModifier.Access getAccess() {
                return PhpClassConstantInplaceIntroducer.getLastSelectedAccess(context.getProject());
            }

            @Override
            public boolean isDefineSyntax() {
                return !PhpCodeValidationUtil.isAllowedAsConstantValue(context.getLogicalElement()) || PhpFileConstantInplaceIntroducer.lastSelectedSyntaxIsDefine(context.getProject());
            }

            @Override
            public String getName() {
                return suggestedName != null ? PhpNameUtil.unique(suggestedName, "", "", (Condition<? super String>)((Condition)str -> PhpLangUtil.isPhpReservedKeyword(str) || occupiedNames.contains(str))) : "C";
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAll;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantHandler";
                break;
            }
            case 3: 
            case 11: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupStatement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physicalExpression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileConstantDeclaration";
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOccurrences";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOriginalElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConstantValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createErrorMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNotConstantChild";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedScope";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedContext";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "performMainRefactoring";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "canPerformInplaceIntroduce";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroducer";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroduceSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

