/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceConstant;

import com.intellij.DynamicBundle;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseDialog;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBasePresenter;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantDisplay;
import com.jetbrains.php.ui.PhpTargetClassChooser;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceConstantDialog
extends PhpIntroduceBaseDialog
implements PhpIntroduceConstantDisplay {
    private final PhpTargetClassChooser myClassChooser;
    private JPanel myCenterPanel;
    private JPanel myFileScopePanel;
    private JRadioButton myDefineRadioButton;
    private JRadioButton myConstRadioButton;
    private JPanel myVisibilityPanel;
    private JRadioButton myPublicRadioButton;
    private JRadioButton myProtectedRadioButton;
    private JRadioButton myPrivateRadioButton;
    private JRadioButton myDefaultRadioButton;
    private JPanel myTargetClassWrapperPanel;
    @Nullable
    private PsiElement myScope;
    private ActionListener myVisibilityChangedListener;
    private boolean myReplaceAllOccurrencesByDefault = true;
    private boolean myMoveToClassByDefault;

    public PhpIntroduceConstantDialog(PhpIntroduceContext introduceContext) {
        super(introduceContext.getProject());
        this.$$$setupUI$$$();
        this.myFileScopePanel.setVisible(false);
        this.myVisibilityPanel.setVisible(false);
        PsiElement scope = introduceContext.getScope();
        this.myClassChooser = new PhpTargetClassChooser(this.myProject, scope instanceof PhpClass ? ((PhpClass)scope).getPresentableFQN() : "", scope instanceof PhpFile, this.getDisposable());
        this.myTargetClassWrapperPanel.add(this.myClassChooser.getPanel());
        JBCheckBox checkBox = this.myClassChooser.getTargetClassCheckBox();
        checkBox.addChangeListener(e -> {
            this.myConstRadioButton.setEnabled(!checkBox.isSelected());
            this.myDefineRadioButton.setEnabled(!checkBox.isSelected());
        });
    }

    @Override
    protected String getHelpId() {
        return "refactoring.introduceConstant";
    }

    @Override
    public String getTitle() {
        return PhpBundle.message("refactoring.extract.constant.name", new Object[0]);
    }

    @NotNull
    protected JPanel createCenterPanel() {
        JPanel jPanel = this.myCenterPanel;
        if (jPanel == null) {
            PhpIntroduceConstantDialog.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    protected boolean isReplaceAllOccurrencesByDefault() {
        return this.myReplaceAllOccurrencesByDefault;
    }

    private void setAccess(@Nullable PhpModifier.Access access) {
        this.myPublicRadioButton.setSelected(access == PhpModifier.Access.PUBLIC);
        this.myProtectedRadioButton.setSelected(access == PhpModifier.Access.PROTECTED);
        this.myProtectedRadioButton.setSelected(access == PhpModifier.Access.PRIVATE);
        this.myDefaultRadioButton.setSelected(access == null);
    }

    @Override
    public void setData(int expressionOccurrences, String @NotNull [] suggestedNames, @NotNull PhpIntroduceBasePresenter.DisplayHandler handler, @Nullable PsiElement scope, boolean allowConstSyntax, PhpModifier.Access access, boolean moveToClassByDefault) {
        PhpLanguageLevel languageLevel;
        if (handler == null) {
            PhpIntroduceConstantDialog.$$$reportNull$$$0(1);
        }
        if (suggestedNames == null) {
            PhpIntroduceConstantDialog.$$$reportNull$$$0(2);
        }
        this.myScope = scope;
        this.myMoveToClassByDefault = moveToClassByDefault;
        super.setData(expressionOccurrences, suggestedNames, handler);
        if (scope instanceof PhpFile) {
            this.myFileScopePanel.setVisible(true);
            if (allowConstSyntax) {
                this.myConstRadioButton.setSelected(true);
            } else {
                this.myConstRadioButton.setEnabled(false);
                this.myDefineRadioButton.setSelected(true);
            }
        } else if (scope instanceof PhpClass && (languageLevel = PhpProjectConfigurationFacade.getInstance(this.myProject).getLanguageLevel()).hasFeature(PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY)) {
            this.myVisibilityPanel.setVisible(true);
            this.myDefaultRadioButton.setSelected(true);
            if (((PhpClass)scope).isInterface()) {
                this.myPrivateRadioButton.setVisible(false);
                this.myProtectedRadioButton.setVisible(false);
            }
            this.setAccess(access);
        }
        this.init();
        if (moveToClassByDefault) {
            this.myClassChooser.getTargetClassCheckBox().setSelected(true);
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myMoveToClassByDefault ? this.myClassChooser.getTargetClassFocusable() : super.getPreferredFocusedComponent();
    }

    @Override
    public void setAllOccurrencesByDefault(boolean replaceAllOccurrencesByDefault) {
        this.myReplaceAllOccurrencesByDefault = replaceAllOccurrencesByDefault;
    }

    @Override
    @Nullable
    public PsiElement getScope() {
        return this.myScope;
    }

    @Override
    @Nullable
    public PhpModifier.Access getAccess() {
        if (this.myPublicRadioButton.isSelected()) {
            return PhpModifier.Access.PUBLIC;
        }
        if (this.myProtectedRadioButton.isSelected()) {
            return PhpModifier.Access.PROTECTED;
        }
        if (this.myPrivateRadioButton.isSelected()) {
            return PhpModifier.Access.PRIVATE;
        }
        return null;
    }

    @Override
    public boolean isDefineSyntax() {
        return this.myDefineRadioButton.isSelected();
    }

    @Override
    protected void init() {
        super.init();
        this.myVisibilityChangedListener = e -> this.scheduleValidation();
        this.myPublicRadioButton.addActionListener(this.myVisibilityChangedListener);
        this.myProtectedRadioButton.addActionListener(this.myVisibilityChangedListener);
        this.myPrivateRadioButton.addActionListener(this.myVisibilityChangedListener);
        this.myDefaultRadioButton.addActionListener(this.myVisibilityChangedListener);
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.myPublicRadioButton.removeActionListener(this.myVisibilityChangedListener);
        this.myProtectedRadioButton.removeActionListener(this.myVisibilityChangedListener);
        this.myPrivateRadioButton.removeActionListener(this.myVisibilityChangedListener);
        this.myDefaultRadioButton.removeActionListener(this.myVisibilityChangedListener);
    }

    @Override
    @Nullable
    public String getTargetClassFqn() {
        return this.myClassChooser.getTargetClassFqn();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        Field field;
        ValidationInfo classValidationInfo = this.myClassChooser.validate(this.myProject);
        if (classValidationInfo != null) {
            return classValidationInfo;
        }
        PhpClass targetClass = this.myClassChooser.findTargetClass(this.myProject);
        Field field2 = field = targetClass != null ? targetClass.findOwnFieldByName((CharSequence)this.getName(), true) : null;
        if (field != null && field.isConstant()) {
            return new ValidationInfo(PhpBundle.message("constant.with.same.name.already.exists.in.0", targetClass.getName()), this.myNameField.getFocusableComponent());
        }
        return super.doValidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel2;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myCenterPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myFileScopePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIntroduceConstantDialog.class).getString("border.title.constant.syntax"), (int)0, (int)0, null, null));
        this.myDefineRadioButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIntroduceConstantDialog.class).getString("radio.button.define"));
        jPanel3.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConstRadioButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIntroduceConstantDialog.class).getString("radio.button.const"));
        jPanel3.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVisibilityPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIntroduceConstantDialog.class).getString("border.title.visibility"), (int)0, (int)0, null, null));
        this.myPublicRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIntroduceConstantDialog.class).getString("radio.button.public"));
        jPanel2.add((Component)jRadioButton4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIntroduceConstantDialog.class).getString("radio.button.protected"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPrivateRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIntroduceConstantDialog.class).getString("radio.button.private"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIntroduceConstantDialog.class).getString("radio.button.default"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTargetClassWrapperPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCenterPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

