/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceConstant;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpClassConstantInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpConstantInFileIntroducePanel;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantHandler;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantPresenter;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantSettings;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFileConstantInplaceIntroducer
extends PhpBaseInplaceIntroducer<Constant, PhpIntroduceConstantSettings> {
    private static final String LAST_SELECTED_SYNTAX = PhpFileConstantInplaceIntroducer.class.getName() + ".lastSelectedSyntax";
    @Nullable
    private final PhpConstantInFileIntroducePanel myPanel;
    private RangeMarker myIntroducedConstantMarker;

    public PhpFileConstantInplaceIntroducer(@NotNull PhpIntroduceConstantHandler handler, @NotNull PhpIntroduceContext context, @NotNull PhpIntroduceConstantSettings settings) {
        if (handler == null) {
            PhpFileConstantInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpFileConstantInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PhpFileConstantInplaceIntroducer.$$$reportNull$$$0(2);
        }
        super(handler, context, settings);
        this.myPanel = PhpConstantInFileIntroducePanel.canBeShown(context) ? new PhpConstantInFileIntroducePanel(this.myProject, ((PhpIntroduceConstantSettings)this.mySettings).isDefineSyntax()) : null;
    }

    @Nullable
    protected Constant createFieldToStartTemplateOn(boolean replaceAll, String @NotNull [] names) {
        if (names == null) {
            PhpFileConstantInplaceIntroducer.$$$reportNull$$$0(3);
        }
        PhpIntroduceBaseHandler.PhpIntroduceResult introduceResult = this.runRefactoring();
        Constant constant = (Constant)PhpPsiUtil.getChildByCondition(introduceResult.getIntroducedElement(), (Condition<? super PsiElement>)Constant.INSTANCEOF);
        assert (constant != null);
        PsiElement expressionForOriginalElement = introduceResult.getExpressionForOriginalElement();
        ConstantReference reference = PhpFileConstantInplaceIntroducer.findIntroducedElementReference(expressionForOriginalElement, (PsiElement)constant, ConstantReference.class);
        assert (reference != null) : expressionForOriginalElement;
        this.myIntroducedConstantMarker = this.myEditor.getDocument().createRangeMarker(constant.getTextRange());
        this.myExprMarker = this.myEditor.getDocument().createRangeMarker(reference.getTextRange());
        return constant;
    }

    @Override
    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable Constant variable) {
        String[] stringArray = new PhpIntroduceConstantNameSuggestionProvider(this.myContext, ContainerUtil.map2Set(PhpIntroduceConstantPresenter.collectConstDeclarations(this.myContext), PhpNamedElement::getName)).getSuggestedNames();
        if (stringArray == null) {
            PhpFileConstantInplaceIntroducer.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @Override
    @Nullable
    protected JComponent getComponent() {
        return this.myPanel != null ? this.myPanel.getRootPanel() : null;
    }

    @Override
    @Nullable
    protected Constant getVariable() {
        return this.restoreElementFromMarker(this.myIntroducedConstantMarker, Constant.class);
    }

    protected void moveOffsetAfter(boolean success) {
        if (!success || this.myPanel == null) {
            return;
        }
        boolean defineSyntax = this.myPanel.isDefineSyntax();
        PhpReference reference = PhpClassConstantInplaceIntroducer.getConstantReferenceAtCaret(this.myContext, false);
        PhpNamedElement constant = (PhpNamedElement)ObjectUtils.tryCast((Object)(reference != null ? reference.resolve() : null), PhpNamedElement.class);
        Object constantWrapper = PhpPsiUtil.getParentByCondition((PsiElement)constant, (Condition<? super PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, ((PhpIntroduceConstantSettings)this.mySettings).isDefineSyntax() ? PhpElementTypes.STATEMENT : PhpElementTypes.CONSTANTS)));
        if (constantWrapper == null) {
            return;
        }
        if (this.myPanel.moveToAnotherClass()) {
            TextRange originalExpressionRange = PhpClassConstantInplaceIntroducer.revertIntroducingAndGetOriginalExpressionRange(reference, constant, constantWrapper, this.myContext);
            if (originalExpressionRange != null) {
                PhpClassConstantInplaceIntroducer.restartIntroducingWithDialogForMove(PhpModifier.Access.PUBLIC, constant.getName(), originalExpressionRange, false, this.myEditor, this.myContext);
            }
        } else if (defineSyntax != ((PhpIntroduceConstantSettings)this.mySettings).isDefineSyntax()) {
            WriteAction.run(() -> constantWrapper.replace(new PhpIntroduceConstantHandler().createFileConstantDeclaration(this.myContext, defineSyntax, constant.getName())));
            PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_SELECTED_SYNTAX, defineSyntax);
        }
    }

    public static <T extends PhpReference> T findIntroducedElementReference(@Nullable PsiElement expressionForOriginalElement, @NotNull PsiElement introducedElement, Class<T> clazz) {
        if (introducedElement == null) {
            PhpFileConstantInplaceIntroducer.$$$reportNull$$$0(5);
        }
        Collection constRefs = PsiTreeUtil.findChildrenOfAnyType((PsiElement)expressionForOriginalElement, (boolean)false, (Class[])new Class[]{clazz});
        return (T)((PhpReference)ContainerUtil.find((Iterable)constRefs, ref -> ref.isReferenceTo(introducedElement)));
    }

    public static boolean lastSelectedSyntaxIsDefine(@NotNull Project project) {
        if (project == null) {
            PhpFileConstantInplaceIntroducer.$$$reportNull$$$0(6);
        }
        return PropertiesComponent.getInstance((Project)project).isValueSet(LAST_SELECTED_SYNTAX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpFileConstantInplaceIntroducer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpFileConstantInplaceIntroducer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findIntroducedElementReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lastSelectedSyntaxIsDefine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

